/*+***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is: vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 *************************************************************************************/
EmailCampaigns_Edit_Js("EmailCampaigns_Edit2_Js", {}, {

    step2Container: false,

    advanceFilterInstance: false,


    init: function () {
        this.initialize();
    },

    /**
     * Function to get the container which holds all the report elements
     * @return jQuery object
     */
    getContainer: function () {
        return this.step2Container;
    },

    /**
     * Function to set the report step2 container
     * @params : element - which represents the report step2 container
     * @return : current instance
     */
    setContainer: function (element) {
        this.step2Container = element;
        return this;
    },

    /**
     * Function  to intialize the reports step2
     */
    initialize: function (container) {
        if (typeof container == 'undefined') {
            container = jQuery('#emailcampaigns_step2');
            this.advanceFilterInstance = Vtiger_AdvanceFilter_Js.getInstance(jQuery('.filterContainer', container));

        }

        if (container.is('#emailcampaigns_step2')) {
            this.setContainer(container);
        } else {
            this.setContainer(jQuery('#emailcampaigns_step2'));
        }
    },

    /*
     * Function to validate special cases in the form
     * returns result
     */
    isFormValidate: function () {
        /*
        var thisInstance = this;
        var select2Element = vtUtils.showSelect2ElementView(selectElement);
        var result = Vtiger_MultiSelect_Validator_Js.invokeValidation(selectElement);
        if(result != true){
            select2Element.validationEngine('showPrompt', result , 'error','bottomLeft',true);
            var form = thisInstance.getContainer();
            app.formAlignmentAfterValidation(form);
            return false;
        } else {
            select2Element.validationEngine('hide');
            return true;
        }
        */
        return true;
    },

    /*
     * Fucntion to perform all the requires calculation before submit
     */

    calculateValues: function () {
        var thisInstance = this;
        //handled advanced filters saved values.
        jQuery('[name="filtersavedinnew"]').val("6");
        var advfilterlist = thisInstance.advanceFilterInstance.getValues();
        jQuery('#advanced_filter').val(JSON.stringify(advfilterlist));

    },

    submit: function () {
        var aDeferred = jQuery.Deferred();
        this.calculateValues();
        var form = this.getContainer();
        var formData = form.serializeFormData();
        app.helper.showProgress();
        app.request.post({data: formData}).then(function (error, data) {
                form.hide();
                app.helper.hideProgress();
                aDeferred.resolve(data);
            },
            function (error, err) {

            });
        return aDeferred.promise();
    },

    registerEnableFilterOption: function () {
        jQuery('[name="conditionstype"]').on('change', function (e) {
            var advanceFilterContainer = jQuery('#advanceFilterContainer');
            var currentRadioButtonElement = jQuery(e.currentTarget);
            if (currentRadioButtonElement.hasClass('recreate')) {
                if (currentRadioButtonElement.is(':checked')) {
                    advanceFilterContainer.removeClass('zeroOpacity');
                }
            } else {
                advanceFilterContainer.addClass('zeroOpacity');
            }
        });
    },
    // VTCONN_TT17186 #RG Inizio
    selectoptionshowhide: function () {
        jQuery('[name="select_option"]').on('change', function (e) {
            var selectvalue = jQuery('[name="select_option"]').val();
            //alert(selectvalue);
            if (selectvalue == 'Start from past campaign') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('div#advcond').hide();
                jQuery('#subscriber_select').hide();
                jQuery('#howto').hide();
                jQuery('#past_emailcampaign').show();
                jQuery('#emailclicklink').show();
                jQuery('#whopenemail').show();

                jQuery('#notwhopenemail').show();
                jQuery('#notemailclicklink').show();
                jQuery('#allprevsubcribers').show();
                jQuery('#flex_report').hide();
                jQuery('#past_report').hide();
            }
            if (selectvalue == 'Select a list') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('div#advcond').show();
                jQuery('#subscriber_select').show();
                jQuery('#howto').show();
                jQuery('#past_emailcampaign').hide();
                jQuery('#emailclicklink').hide();
                jQuery('#whopenemail').hide();

                jQuery('#notwhopenemail').hide();
                jQuery('#notemailclicklink').hide();
                jQuery('#allprevsubcribers').hide();
                jQuery('#flex_report').hide();
                jQuery('#past_report').hide();
            }
            if (selectvalue == 'Select from report') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('div#advcond').hide();
                jQuery('#subscriber_select').hide();
                jQuery('#howto').hide();
                jQuery('#past_emailcampaign').hide();
                jQuery('#emailclicklink').hide();
                jQuery('#whopenemail').hide();

                jQuery('#notwhopenemail').hide();
                jQuery('#notemailclicklink').hide();
                jQuery('#allprevsubcribers').hide();
                jQuery('#flex_report').hide();
                jQuery('#past_report').show();
            }
            if (selectvalue == 'Select from Flex report') {
                //jQuery('#EmailCampaigns_step2').reset();
                jQuery('div#advcond').hide();
                jQuery('#subscriber_select').hide();
                jQuery('#howto').hide();
                jQuery('#past_emailcampaign').hide();
                jQuery('#emailclicklink').hide();
                jQuery('#whopenemail').hide();

                jQuery('#notwhopenemail').hide();
                jQuery('#notemailclicklink').hide();
                jQuery('#allprevsubcribers').hide();
                jQuery('#past_report').hide();
                jQuery('#flex_report').show();
            }
        });
    },
    // VTCONN_TT17186 #RG Fine

    // VTCONN_TT17186 #RG Inizio
    registerReportSelChange: function () {
        var thisInstance = this;
        jQuery("#searchReports").on("change", function (i) {
            var reportid = jQuery('#searchReports').find('option:selected').val();
            if (reportid == 0) {
                return;
            }

            var moduleNamePicklist = jQuery("#searchReportModules");
            moduleNamePicklist.find('option').remove().end().append('<option value="--">Select an option</option>').val('0');

            var params = {
                'module': app.getModuleName(),
                'action': "SaveAjax",
                'mode': "getModulesByReport",
                'reportid': reportid,
            };
            AppConnector.request(params).then(function (data) {
                jQuery.each(data.result.options, function (i, item) {
                    var o = new Option(item, item);
                    jQuery(o).html(item);
                    moduleNamePicklist.append(o);
                });
                moduleNamePicklist.trigger('liszt:updated');
            });
        });
    },
    // VTCONN_TT17186 #RG Fine
    registerFlexReportSelChange: function () {
        var thisInstance = this;
        jQuery("#searchFlexReports").on("change", function (i) {
            var reportid = jQuery('#searchFlexReports').find('option:selected').val();
            if (reportid == 0) {
                return;
            }

            var moduleNamePicklist1 = jQuery("#searchFlexReportModules");
            moduleNamePicklist1.find('option').remove().end().append('<option value="--">Select an option</option>').val('0');

            var params = {
                'module': app.getModuleName(),
                'action': "SaveAjax",
                'mode': "getModulesByFlexReport",
                'reportid': reportid,
            };
            AppConnector.request(params).then(function (data) {
                jQuery.each(data.result.options, function (i, item) {
                    var o = new Option(item, item);
                    jQuery(o).html(item);
                    moduleNamePicklist1.append(o);
                });
                moduleNamePicklist1.trigger('liszt:updated');
            });
        });
    },

    registerApplyFilterConditionsEvent: function () {
        var a = this;
        jQuery(".filterClick").off();


        jQuery(".filterClick").on("click", function (e) {
            e.preventDefault();
            //var selectElement = jQuery('input[name="src_list_module"]');
            var source_module = jQuery('input[name="src_list_module"]').val();
            a.calculateValues();
            var advfilterlist = jQuery('#advanced_filter').val();
            var isError = false;
            var selectSource = $('select[name="select_option"]').val();
            var record = $('#emailcampaigns_step2').find('input[name="record"]').val();
            if (selectSource == 'Select a list') {
                var subscriperListId = $('input[name="subscribers_list"]').val();
                if (subscriperListId == '' && $("div.EmailCampaignsLog").children().length == 0) {
                    var g = {
                        title: app.vtranslate("Please select a subscribers list. Then press add button."),
                        type: "error"
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {

                    var j = $('#conditionForm :input').serializeFormData();
                    j.module = app.getModuleName();
                    j.action = 'SaveAjax';
                    j.mode = 'step2';
                    j.name = 'From SubscribersList';
                    j.module_name = source_module;
                    j.subscriperListId = subscriperListId;
                    j.record = record;

                }

            } else if (selectSource == 'Start from past campaign') {
                var parent_emailcampaignsid = $('input[name="parent_emailcampaignsid"]').val();
                if (parent_emailcampaignsid == '') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a past campaign. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    if ($("#EmailCampaigns_editView_fieldName_whopenemail").is(":checked")) {
                        var whopenemail = '1';
                    } else {
                        var whopenemail = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_emailclicklink").is(":checked")) {
                        var emailclicklink = '1';
                    } else {
                        var emailclicklink = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_notwhopenemail").is(":checked")) {
                        var notwhopenemail = '1';
                    } else {
                        var notwhopenemail = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_notemailclicklink").is(":checked")) {
                        var notemailclicklink = '1';
                    } else {
                        var notemailclicklink = '0';
                    }

                    if ($("#EmailCampaigns_editView_fieldName_allprevsubcribers").is(":checked")) {
                        var allprevsubcribers = '1';
                    } else {
                        var allprevsubcribers = '0';
                    }

                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'whopenemail': whopenemail,
                        'emailclicklink': emailclicklink,
                        'notwhopenemail': notwhopenemail,
                        'notemailclicklink': notemailclicklink,
                        'allprevsubcribers': allprevsubcribers,
                        'parent_emailcampaignsid': parent_emailcampaignsid,
                        'name': "From Emailcampaigns",
                        'record': record
                    };
                }

            } else if (selectSource == 'Select from report') {

                var searchReports = $('#searchReports').val();
                var searchReportModules = $('#searchReportModules').val();
                if (searchReports == '' || searchReports == 0) {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Report. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else if (searchReportModules == '' || searchReportModules == '--') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Report Module. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'reportId': searchReports,
                        'reportModule': searchReportModules,
                        'name': "From Report",
                        'record': record
                    };
                }
            } else if (selectSource == 'Select from Flex report') {

                var searchFlexReports = $('#searchFlexReports').val();
                var searchFlexReportModules = $('#searchFlexReportModules').val();
                if (searchFlexReports == '' || searchFlexReports == 0) {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Flex Report. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else if (searchFlexReportModules == '' || searchFlexReportModules == '--') {
                    var g = {
                        title: app.vtranslate("Warning"),
                        type: "error",
                        text: app.vtranslate("Please select a Flex Report Module. Then press add button.")
                    };
                    Vtiger_Helper_Js.showPnotify(g);
                    var isError = true;
                } else {
                    var j = {
                        'module': app.getModuleName(),
                        'action': "SaveAjax",
                        'mode': 'step2',
                        'module_name': source_module,
                        'reportId': searchFlexReports,
                        'reportModule': searchFlexReportModules,
                        'name': "From Flex Report",
                        'record': record
                    };
                }
            }
//            console.log(j);
            if (!isError) {
                jQuery(".filterClick").prop("disabled", true);
                AppConnector.request(j).then(function (k) {
                    var e = k.result.count;
                    if (e == null) {
                        e = 0;
                    }
                    jQuery("#filter_1").html(e);

//                    var related_recorts = k.result.related_recorts;
                    //jQuery('[name="related_recorts"]').val(related_recorts);
//                    if (related_recorts == null) {
//                        related_recorts = "";
//                    }
//                    jQuery('#related_recorts_current').val(related_recorts);


                    var logHtml = '<p  style="line-height: 30px"> ' +
                        '&nbsp;' +
                        '<span class="campaignslLog">' +
                        '<span class="logName">' +
                        k.result.emailListName +
                        '</span>' +
                        '<span class="pull-right">' +
                        '<span class="alert alert-warning logTotal">' +
                        e +
                        '</span>&nbsp;&nbsp;&nbsp;' +
                        '<button class="btn btn-success refreshTotal" data-id = "' + k.result.emaillistRelId + '" title="Refresh the Total" type="button"><i class="fa fa-refresh" title="Refresh"></i>&nbsp;' + app.vtranslate("JS_TOTAL") + '</button>&nbsp;' +
                        '<button class="btn btn-info viewRecords" data-id = "' + k.result.emaillistRelId + '" title="' + app.vtranslate("JS_VIEW_RECORDS") + '" type="button"><i class="fa fa-eye" title="' + app.vtranslate("JS_VIEW_RECORDS") + '"></i></button>&nbsp;' +
                        '<button class="btn btn-danger deleteRel" data-id = "' + k.result.emaillistRelId + '"> <i title="Delete" class="fa fa-trash"></i>&nbsp;' + app.vtranslate("JS_DELETE") + '</button>' +
                        '</span>' +
                        '</span>' +
                        '</p>';
                    $('.EmailCampaignsLog').append(logHtml);

//                    var searchmodulelist = k.result.module_name;
//                    jQuery('[name="searchmodulelist"]').val(searchmodulelist);
//                    jQuery('[name="module_name"]').val(searchmodulelist);
                    jQuery(".filterClick").prop("disabled", false);
                    a.RegisterViewRecordsClick();
                });
            }
        });


        jQuery(".addClick").off();
        jQuery(".addClick").on("click", function (i) {
            // Accoda il related_recorts_current al related_recorts
            if (jQuery('#related_recorts_current').val() != "") {
                jQuery('[name="related_recorts"]').val(jQuery('#related_recorts_current').val() + "," + jQuery('[name="related_recorts"]').val());
            }
            if (parseInt(jQuery("#filter_1").html()) != 0) {
                jQuery("#filter_2").html(parseInt(jQuery("#filter_1").html()) + parseInt(jQuery("#filter_2").html()));
            }

            var ecLog = jQuery(".EmailCampaignsLog").html();
            var typeSel = "";
            var textVal = "";
            var selectvalue = jQuery('[name="select_option"]').val();
            if (selectvalue == 'Start from past campaign') {
                typeSel = "Previous Campaign : ";
                textVal = jQuery('#parent_emailcampaignsid_display').val();
            } else if (selectvalue == 'Select a list') {
                typeSel = "Subscribers List : ";
                textVal = jQuery('#subscribers_list_display').val();
            } else if (selectvalue == 'Select from report') {
                typeSel = "Report : ";
                textVal = jQuery('#searchReports').find('option:selected').text();
            } else if (selectvalue == 'Select from Flex report') {
                typeSel = "Flex Report : ";
                textVal = jQuery('#searchFlexReports').find('option:selected').text();
            }

//          ecLog = ecLog + "<p><b>" + jQuery("#filter_1").html() + " </b> " + app.vtranslate('JS_FROM') + typeSel + textVal +"</p>";
            ecLog = ecLog + "<p><b>" + typeSel + textVal + "</p>";
            jQuery(".EmailCampaignsLog").html(ecLog);
            jQuery("#eclog").val(ecLog);

            jQuery(this).prop("disabled", true);
        });

        jQuery(".resetClick").off();
        jQuery(".resetClick").on("click", function (i) {
            // Accoda il related_recorts_current al related_recorts
            jQuery('[name="related_recorts"]').val("");
            jQuery("#filter_2").html(0);
            jQuery('[name="related_recorts_current"]').val("");
            jQuery("#filter_1").html(0);
            jQuery(".addClick").prop("disabled", true);
            //sbianca log
            jQuery(".EmailCampaignsLog").html("");
            jQuery("#eclog").val("");
        });
    },

    registerRefreshTotalClick: function () {
        $(document).on('click', '.refreshTotal', function (e) {
            e.preventDefault();
            var element = $(this);
            var lbTotal = element.closest('p').find('.logTotal');

            var relId = element.attr('data-id');

            var params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'BasicAjax',
                mode: 'refreshTotalCount'
            };

            lbTotal.html('<i class="fa fa-spinner fa-pulse"></i>');
            app.request.post({"data": params}).then(function (err, data) {
                if (err == null) {
                    lbTotal.html(data.count);
                } else {
                    lbTotal.html("0");
                }
            });
        });
    },


    registerDeleteRelClick: function () {
        $(document).on('click', '.deleteRel', function (e) {
            e.preventDefault();
            var element = $(this);
            var relId = element.attr('data-id');
            var progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });
            var params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'BasicAjax',
                mode: 'deleteRel'
            };
            $.post('index.php', params, function (response) {
                if (response.success) {
                    element.closest('p').remove();
                }
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                })
            });
        });
    },

    /**
     * Funtion to register popup search event for reference field
     * @param <jQuery> container
     */

    referenceModulePopupRegisterEvent: function (container) {
        var thisInstance = this;
        container.off('click', '.relatedPopup');
        container.on("click", '.relatedPopup', function (e) {
            thisInstance.openPopUp(e);
        });
        container.on('change', '.referenceModulesList', function (e) {
            var element = jQuery(e.currentTarget);
            var closestTD = thisInstance.getParentElement(element).next();
            var popupReferenceModule = element.val();
            var referenceModuleElement = jQuery('input[name="popupReferenceModule"]', closestTD).length ?
                jQuery('input[name="popupReferenceModule"]', closestTD) : jQuery('input.popupReferenceModule', closestTD);
            var prevSelectedReferenceModule = referenceModuleElement.val();
            referenceModuleElement.val(popupReferenceModule);

            //If Reference module is changed then we should clear the previous value
            if (prevSelectedReferenceModule != popupReferenceModule) {
                closestTD.find('.clearReferenceSelection').trigger('click');
            }
        });
    },


    /**
     * Function to open popup list modal
     */
    openPopUp: function (e) {
        var thisInstance = this;
        var parentElem = thisInstance.getParentElement(jQuery(e.target));

        var params = this.getPopUpParams(parentElem);
        params.view = 'Popup';

        var isMultiple = false;
        if (params.multi_select) {
            isMultiple = true;
        }

        var sourceFieldElement = jQuery('input[class="sourceField"]', parentElem);

        var prePopupOpenEvent = jQuery.Event(Vtiger_Edit_Js.preReferencePopUpOpenEvent);
        sourceFieldElement.trigger(prePopupOpenEvent);

        if (prePopupOpenEvent.isDefaultPrevented()) {
            return;
        }
        var popupInstance = Vtiger_Popup_Js.getInstance();

        app.event.off(Vtiger_Edit_Js.popupSelectionEvent);
        app.event.one(Vtiger_Edit_Js.popupSelectionEvent, function (e, data) {
            var responseData = JSON.parse(data);
            var dataList = new Array();
            jQuery.each(responseData, function (key, value) {
                var counter = 0;
                for (var valuekey in value) {
                    if (valuekey == 'name') continue;
                    if (typeof valuekey == 'object') continue;
                    var data = {
                        'name': value.name,
                        'id': key
                    }
                    if (valuekey == 'info') {
                        data['name'] = value.name;
                    }
                    dataList.push(data);
                    if (!isMultiple && counter === 0) {
                        counter++;
                        thisInstance.setReferenceFieldValue(parentElem, data);
                        thisInstance.loadFilter(data);
                    }

                    //var emcInstance = new window['EmailCampaigns_Edit2_Js']();

                }
            });

            if (isMultiple) {
                sourceFieldElement.trigger(Vtiger_Edit_Js.refrenceMultiSelectionEvent, {'data': dataList});
            }
            sourceFieldElement.trigger(Vtiger_Edit_Js.postReferenceSelectionEvent, {'data': responseData});
        });
        popupInstance.showPopup(params, Vtiger_Edit_Js.popupSelectionEvent, function () {
        });
    },

    loadFilter: function (data) {
        thisInstance = this;

        var aDeferred = jQuery.Deferred();
        var container = this.getContainer();

        var searchableModulesParams = {
            "module": "EmailCampaigns",
            "view": "BasicAjax",
            "mode": "AdvanceFilter",
            "record": data.id
        };

        app.helper.showProgress();
        app.request.post({data: searchableModulesParams}).then(
            function (err, data) {
                //console.log(data);
                app.helper.hideProgress();
                //add to cache
                jQuery("#advcond").html(data);
                vtUtils.applyFieldElementsView(container);
                app.changeSelectElementView(container);
                thisInstance.advanceFilterInstance = Vtiger_AdvanceFilter_Js.getInstance(jQuery('.filterContainer', container));
                thisInstance.calculateValues();
                if (jQuery('[name="filtersavedinnew"]', container).val() == '5') {
                    this.registerEnableFilterOption();
                }
                //aDeferred.resolve(data);
            },
            function (error, err) {
                aDeferred.reject(error);
            }
        );
        return aDeferred.promise();
    },
    registerAddReferenceSubscribersListEvent: function () {
        var thisInstance = this;
        var container = this.getContainer();

        container.on('click', '.fa-plus', function (e) {
            var url = "index.php?module=SubscribersList&view=Edit";
            window.open(url, '_blank');
        });
    },
    RegisterViewRecordsClick: function () {
        let thisInstance = this;
        $('.viewRecords').click(function (e) {
            e.preventDefault();
            let progressIndicatorElement = jQuery.progressIndicator({
                'position': 'html',
                'blockInfo': {
                    'enabled': true
                }
            });
            let element = $(this);
            let relId = element.attr('data-id');
            let params = {
                relId: relId,
                module: 'EmailCampaigns',
                view: 'RelatedRecordsAjax',
                mode: 'LoadRelatedRecordList'
            };
            $.post('index.php', params, function (response) {
                let modalParams = {
                    cb: function () {
                        setTimeout(function () {
                            thisInstance.registerFloatingThead();
                        }, 10);
                        app.event.on('Vtiger.Post.MenuToggle', function () {
                            thisInstance.reflowList();
                        });
                        thisInstance.registerHeaderReflowOnListSearchSelections();
                        thisInstance.initializePaginationEvents();
                        thisInstance.registerListViewSearch();
                        thisInstance.registerListModuleChange();
                    }
                }
                app.helper.showModal(response, modalParams);
                progressIndicatorElement.progressIndicator({
                    'mode': 'hide'
                });
            });
        });
    },
    registerListModuleChange: function(){
        let thisInstance = this;
        let listViewContainer = thisInstance.getListViewContainer();
        listViewContainer.on('change','[name="relModule"]', function(e){
            e.preventDefault();
            let urlParams = {};
            thisInstance.loadListViewRecords(urlParams);
        });
    },
    initializePaginationEvents: function () {
        let thisInstance = this;
        let paginationObj = new Vtiger_Pagination_Js();
        let listViewContainer = thisInstance.getListViewContainer();
        paginationObj.initialize(listViewContainer);
        app.event.on(paginationObj.nextPageButtonClickEventName, function () {
            let pageLimit = listViewContainer.find('#pageLimit').val();
            let noOfEntries = listViewContainer.find('#noOfEntries').val();
            let nextPageExist = listViewContainer.find('#nextPageExist').val();
            let pageNumber = listViewContainer.find('#pageNumber').val();
            let nextPageNumber = parseInt(parseFloat(pageNumber)) + 1;
            if (noOfEntries === pageLimit && nextPageExist) {
                let urlParams = {};
                listViewContainer.find("#pageNumber").val(nextPageNumber);
                thisInstance.loadListViewRecords(urlParams);
            }
        });

        app.event.on(paginationObj.previousPageButtonClickEventName, function () {
            let pageNumber = listViewContainer.find('#pageNumber').val();
            let previousPageNumber = parseInt(parseFloat(pageNumber)) - 1;

            if (pageNumber > 1) {
                let urlParams = {};
                listViewContainer.find('#pageNumber').val(previousPageNumber);
                thisInstance.loadListViewRecords(urlParams);
            }
        });

        app.event.on(paginationObj.pageJumpButtonClickEventName, function (event, currentEle) {
            thisInstance.pageJump();
        });

        app.event.on(paginationObj.totalNumOfRecordsButtonClickEventName, function (event, currentEle) {
            thisInstance.totalNumOfRecords(currentEle);
        });

        app.event.on(paginationObj.pageJumpSubmitButtonClickEvent, function (event, currentEle) {
            thisInstance.pageJumpOnSubmit(currentEle);
        });
    },
    /**
     * Function to register the list view row search event
     */
    registerListViewSearch: function () {
        var listViewPageDiv = this.getListViewContainer();
        var thisInstance = this;
        listViewPageDiv.on('click', '[data-trigger="listSearch"]', function (e) {
            e.preventDefault();
            var params = {
                'page': '1'
            }
            thisInstance.loadListViewRecords(params).then(
                function (data) {
                    //To unmark the all the selected ids
                    jQuery('#deSelectAllMsgDiv').trigger('click');
                },
                function (textStatus, errorThrown) {
                }
            );
        });

        //floatThead change event object has undefined keyCode, using keyup instead
        var prevSearchValues = [];

        listViewPageDiv.on('keyup', '.listSearchContributor', function (e) {
            var element = jQuery(e.currentTarget);
            var fieldName = element.attr('name');
            var searchValue = element.val();
            if (e.which == 13 && prevSearchValues[fieldName] !== searchValue) {
                e.preventDefault();
                var element = jQuery(e.currentTarget);
                var parentElement = element.closest('tr');
                var searchTriggerElement = parentElement.find('[data-trigger="listSearch"]');
                searchTriggerElement.trigger('click');
                prevSearchValues[fieldName] = searchValue;
            }
        });
        listViewPageDiv.on('keyup', '.listSearchContributorClone', function (e) {
            var element = jQuery(e.currentTarget);
            var fieldName = element.attr('name');
            var searchValue = element.val();
            if (e.which == 13 && prevSearchValues[fieldName] !== searchValue) {
                e.preventDefault();
                var element = jQuery(e.currentTarget);
                var searchTriggerElement = listViewPageDiv.find('.triggerListSearch');
                searchTriggerElement.trigger('click');
                prevSearchValues[fieldName] = searchValue;
            }
        });

        listViewPageDiv.on('datepicker-change', '.dateField', function (e) {
            var element = jQuery(e.currentTarget);
            element.trigger('change');
        });
    },
    totalNumOfRecords_performingAsyncAction: false,
    totalNumOfRecords: function (currentEle) {
        var thisInstance = this;
        var listViewContainer = thisInstance.getListViewContainer();
        var totalRecordsElement = listViewContainer.find('#totalCount');
        var totalNumberOfRecords = totalRecordsElement.val();
        if (thisInstance.totalNumOfRecords_performingAsyncAction) {
            return;
        }
        currentEle.find('.showTotalCountIcon').addClass('hide');
        if (totalNumberOfRecords === '') {
            thisInstance.totalNumOfRecords_performingAsyncAction = true;
            thisInstance.getPageCount().then(function (data) {
                currentEle.addClass('hide');
                totalNumberOfRecords = data.numberOfRecords;
                totalRecordsElement.val(totalNumberOfRecords);
                listViewContainer.find('ul#listViewPageJumpDropDown #totalPageCount').text(data.page);
                thisInstance.showPagingInfo();
                thisInstance.totalNumOfRecords_performingAsyncAction = false;
            });
        } else {
            currentEle.addClass('hide');
            thisInstance.showPagingInfo();
        }
    },
    showPagingInfo: function () {
        var thisInstance = this;
        var listViewContainer = thisInstance.getListViewContainer();
        var totalNumberOfRecords = jQuery('#totalCount', listViewContainer).val();
        var pageNumberElement = jQuery('.pageNumbersText', listViewContainer);
        var pageRange = pageNumberElement.text();
        var newPagingInfo = pageRange.trim() + " " + app.vtranslate('of') + " " + totalNumberOfRecords + "  ";
        var listViewEntriesCount = parseInt(jQuery('#noOfEntries', listViewContainer).val());

        if (listViewEntriesCount !== 0) {
            jQuery('.pageNumbersText', listViewContainer).html(newPagingInfo);
        } else {
            jQuery('.pageNumbersText', listViewContainer).html("");
        }
    },
    pageJump: function () {
        var thisInstance = this;
        var listViewContainer = thisInstance.getListViewContainer();
        var element = listViewContainer.find('#totalPageCount');
        var totalPageNumber = element.text();
        var pageCount;

        if (totalPageNumber === "") {
            var totalCountElem = listViewContainer.find('#totalCount');
            var totalRecordCount = totalCountElem.val();
            if (totalRecordCount !== '') {
                var recordPerPage = listViewContainer.find('#pageLimit').val();
                if (recordPerPage === '0')
                    recordPerPage = 1;
                pageCount = Math.ceil(totalRecordCount / recordPerPage);
                if (pageCount === 0) {
                    pageCount = 1;
                }
                element.text(pageCount);
                return;
            }

            thisInstance.getPageCount().then(function (data) {
                var pageCount = data.page;
                totalCountElem.val(data.numberOfRecords);
                if (pageCount === 0) {
                    pageCount = 1;
                }
                element.text(pageCount);
            });
        }
    },
    pageJumpOnSubmit: function (element) {
        var thisInstance = this;
        var container = this.getListViewContainer();
        var currentPageElement = container.find('#pageNumber');
        var currentPageNumber = parseInt(currentPageElement.val());
        var newPageNumber = parseInt(container.find('#pageToJump').val());
        var totalPages = parseInt(container.find('#totalPageCount').text());
        if (newPageNumber > totalPages) {
            var message = app.vtranslate('JS_PAGE_NOT_EXIST');
            app.helper.showErrorNotification({'message': message})
            return;
        }

        if (newPageNumber === currentPageNumber) {
            var message = app.vtranslate('JS_YOU_ARE_IN_PAGE_NUMBER') + " " + newPageNumber;
            app.helper.showAlertNotification({'message': message});
            return;
        }

        var urlParams = thisInstance.getPagingParams();
        urlParams['page'] = newPageNumber;
        thisInstance.loadListViewRecords(urlParams).then(function (data) {
            element.closest('.btn-group ').removeClass('open');
        });
    },
    /**
     * Function to get Page Jump Params
     */
    getPageJumpParams: function () {
        var params = this.getDefaultParams();
        params['view'] = "RelatedRecordsAjax";
        params['mode'] = "getPageCount";

        return params;
    },
    getPagingParams: function () {
        var thisInstance = this;
        var params = {
            "orderby": jQuery('#orderBy').val(),
            "sortorder": jQuery("#sortOrder").val()
        };
        return params;
    },
    loadListViewRecords: function (urlParams) {
        var self = this;
        var aDeferred = jQuery.Deferred();
        var defParams = this.getDefaultParams();
        if (typeof urlParams == "undefined") {
            urlParams = {};
        }
        if (typeof urlParams.search_params == "undefined") {
            urlParams.search_params = JSON.stringify(this.getListSearchParams(false));
        }
        urlParams = jQuery.extend(defParams, urlParams);
        app.helper.showProgress();

        app.request.post({data: urlParams}).then(function (err, res) {
            aDeferred.resolve(res);
            self.postLoadListViewRecords(res);
        });
        return aDeferred.promise();
    },
    postLoadListViewRecords: function (res) {
        var self = this;
        self.placeListContents(res);
        app.event.trigger('post.listViewFilter.click', jQuery('.searchRow'));
        app.helper.hideProgress();
        self.registerFloatingThead();
        let container = self.getListViewContainer();
        vtUtils.applyFieldElementsView(container);
    },
    registerPostListLoadListener: function () {
        var self = this;
        app.event.on('post.listViewFilter.click', function (event, searchRow) {
            if (searchRow) {
                vtUtils.applyFieldElementsView(searchRow);
                self.filterClick = false;
            }
            setTimeout(function(){self.registerFloatingThead();},10);

        });
    },
    registerDynamicListHeaders: function () {
        var self = this;
        var listViewContainer = this.getListViewContainer();
        if (jQuery('#filterListColumns').length > 0) {
            jQuery('#filterListColumns').instaFilta({
                targets: '.listColumnFilter .list-group-item',
                sections: '.listColumnFilter .block-item',
                hideEmptySections: true,
                beginsWith: false,
                caseSensitive: false,
                typeDelay: 0
            });
        }
        jQuery('.listColumnFilter .dropdown-menu').on('click', function (e) {
            e.stopPropagation();
        });
        var params = {
            setHeight: ''
        };
        app.helper.showVerticalScroll(jQuery('.viewColumnsList'), params);

        jQuery('.viewColumnsList').on('click', 'input[type="checkbox"]', function (e, params) {
            var listHeaderFieldEle = $('input[name="list_headers"]');
            var listHeaderFields = JSON.parse(listHeaderFieldEle.val());
            if ($(this).is(':checked')) {
                listHeaderFields = app.helper.array_merge(listHeaderFields, [$(this).val()]);
            } else {
                var index = app.helper.array_search($(this).val(), listHeaderFields);
                delete listHeaderFields[index];
            }
            listHeaderFieldEle.val(JSON.stringify(listHeaderFields));
        });

        jQuery('#updateListing').on('click', function (e, params) {
            if (typeof params === "undefined" || !params.noFilterLoad) {
                self.loadListViewRecords();
            }
        });
    },
    placeListContents: function (contents) {
        var container = this.getListViewContainer();
        container.html(contents);
    },
    getDefaultParams: function () {
        let container = this.getListViewContainer();
        let pageNumber = container.find('#pageNumber').val();
        let module = this.getModuleName();
        let parent = app.getParentModuleName();
        let relId = $('input[name="relId"]').val();
        let orderBy = container.find('[name="orderBy"]').val();
        let sortOrder = container.find('[name="sortOrder"]').val();
        let relModule = container.find('[name="relModule"]').val();
        var params = {
            'module': module,
            'parent': parent,
            'page': pageNumber,
            'view': "RelatedRecordsAjax",
            'relId': relId,
            'orderby': orderBy,
            'sortorder': sortOrder,
            mode: 'LoadRelatedRecordListAjax',
            relModule: relModule
        }
        params.search_params = JSON.stringify(this.getListSearchParams());
        params.list_headers = container.find('[name="list_headers"]').val();
        return params;
    },
    isInteger: function (num) {
        return !isNaN(num);
    },
    getListSearchParams: function (includeStarFilters) {
        if (typeof includeStarFilters == "undefined") {
            includeStarFilters = true;
        }
        var listViewPageDiv = this.getListViewContainer();
        var listViewTable = listViewPageDiv.find('.searchRow');
        var searchParams = new Array();
        var currentSearchParams = new Array();
        if (listViewPageDiv.find('#currentSearchParams').val()) {
            currentSearchParams = JSON.parse(listViewPageDiv.find('#currentSearchParams').val());
        }

        if (this.filterClick) {
            return;
        }
        listViewTable.find('.listSearchContributor').each(function (index, domElement) {
            var searchInfo = new Array();
            var searchContributorElement = jQuery(domElement);
            var fieldName = searchContributorElement.attr('name');
            var fieldInfo = uimeta.field.get(fieldName);

            /**
             *  If we have any related record fields in the list, then list search will not work.
             *  Because, uimeta will only hold field info of current module not all related modules
             */
            if (typeof fieldInfo == 'undefined') {
                fieldInfo = searchContributorElement.data("fieldinfo");
            }

            if (currentSearchParams != null) {
                if (typeof fieldName != 'undefined') {
                    if (fieldName in currentSearchParams) {
                        delete currentSearchParams[fieldName];
                    }
                }

                if ('starred' in currentSearchParams) {
                    delete currentSearchParams['starred'];
                }
            }

            var searchValue = searchContributorElement.val();

            if (typeof searchValue == "object") {
                if (searchValue == null) {
                    searchValue = "";
                } else {
                    searchValue = searchValue.join(',');
                }
            }
            searchValue = searchValue.trim();
            if (searchValue.length <= 0) {
                //continue
                return true;
            }
            var searchOperator = 'c';
            if (fieldInfo.type == "date" || fieldInfo.type == "datetime") {
                searchOperator = 'bw';
            } else if (fieldInfo.type == 'percentage' || fieldInfo.type == "double" || fieldInfo.type == "integer"
                || fieldInfo.type == 'currency' || fieldInfo.type == "number" || fieldInfo.type == "boolean" ||
                fieldInfo.type == "picklist") {
                searchOperator = 'e';
            }
            var storedOperator = searchContributorElement.parent().parent().find('.operatorValue').val();
            if (storedOperator) {
                searchOperator = storedOperator;
                storedOperator = false;
            }
            searchInfo.push(fieldName);
            searchInfo.push(searchOperator);
            searchInfo.push(searchValue);

            searchParams.push(searchInfo);
        });
        for (var i in currentSearchParams) {
//			Number.isInteger(parseInt(i)) (Previously Used which is not supported by IE.)
//			http://codereview.stackexchange.com/questions/101484/simple-function-to-verify-if-a-number-is-integer
//			http://stackoverflow.com/questions/26482645/number-isintegerx-which-is-created-can-not-work-in-ie
            if (!this.isInteger(parseInt(i))) {
                continue;
            }
            var fieldName = currentSearchParams[i]['fieldName'];
            var searchValue = currentSearchParams[i]['searchValue'];
            var searchOperator = currentSearchParams[i]['comparator'];
            if (fieldName == null || fieldName.length <= 0) {
                continue;
            }
            var searchInfo = new Array();
            searchInfo.push(fieldName);
            searchInfo.push(searchOperator);
            searchInfo.push(searchValue);
            searchParams.push(searchInfo);
        }
        if (searchParams.length > 0) {
            var listSearchParams = new Array(searchParams);
        } else {
            var listSearchParams = new Array();
        }
        return listSearchParams;
    },
    getListViewContainer: function () {
        return jQuery('.listViewPageDiv');
    },
    registerHeaderReflowOnListSearchSelections: function () {
        var listViewContentDiv = this.getListViewContainer();
        var thisInstance = this;
        var $table = jQuery('#listview-table');
        listViewContentDiv.on('select2-selecting select2-close select2-removed',
            '.listSearchContributor',
            function () {
                thisInstance.reflowList($table);
            });
    },
    getListViewContentHeight: function () {
        var windowHeight = jQuery(window).height();
        //list height should be 76% of window height
        var listViewContentHeight = windowHeight * 0.76103500761035;
        var listViewTable = jQuery('#listview-table');
        if (listViewTable.length) {
            if (!listViewTable.find('tr.emptyRecordsDiv').length) {
                var listTableHeight = jQuery('#listview-table').height();
                if (listTableHeight < listViewContentHeight) {
                    listViewContentHeight = listTableHeight + 25;
                }
            }
        }
        listViewContentHeight = listViewContentHeight + 17;
        return listViewContentHeight + 'px';
    },
    getListViewContentWidth: function () {
        return '100%';
    },

    reflowList: function () {
        var thisInstance = this;
        if (typeof $.fn.perfectScrollbar !== 'function' || typeof $.fn.floatThead !== 'function') {
            return;
        }
        var $table = jQuery('#listview-table');
        if (!$table.length)
            return;
        var height = this.getListViewContentHeight();
        var width = this.getListViewContentWidth();
        var tableContainer = $table.closest('.table-container');

        if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
            tableContainer.css({
                'position': 'relative',
                'width': width
            });
            $('#listViewContent #listview-table').attr('style', 'margin-top: 0 !important');
            $('#table-content,.table-content').attr('style', 'overflow-x: auto !important; position: relative; width: 100%;');
        } else {
            tableContainer.css({
                'position': 'relative',
                'height': height,
                'width': width
            });
        }
        tableContainer.perfectScrollbar('update');
        $table.floatThead('reflow');
    },
    registerFloatingThead: function () {
        /*return;*/
        if (typeof $.fn.perfectScrollbar !== 'function' || typeof $.fn.floatThead !== 'function') {
            return;
        }
        var $table = jQuery('#listview-table');
        if (!$table.length)
            return;
        var height = this.getListViewContentHeight();
        var width = this.getListViewContentWidth();
        var tableContainer = $table.closest('.table-container');
        if (/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
            tableContainer.css({
                'position': 'relative',
                'width': width
            });

            $('#listViewContent #listview-table').attr('style', 'margin-top: 0 !important');

            $('#table-content,.table-content').attr('style', 'overflow-x: auto !important; position: relative; width: 100%;');
        } else {
            tableContainer.css({
                'position': 'relative',
                'height': height,
                'width': width
            });
            tableContainer.perfectScrollbar({
                'wheelPropagation': true
            });
            $table.floatThead({
                scrollContainer: function ($table) {
                    return $table.closest('.table-container');
                }
            });
        }

    },
    registerEvents: function () {
        var container = this.getContainer();

        //If the container is reloading, containers cache should be reset

        vtUtils.applyFieldElementsView(container);
        app.changeSelectElementView(container);
        //this.advanceFilterInstance = Vtiger_AdvanceFilter_Js.getInstance(jQuery('.filterContainer',container1));

        if (jQuery('[name="filtersavedinnew"]', container).val() == '5') {
            this.registerEnableFilterOption();
        }
        this.selectoptionshowhide();
        this.registerApplyFilterConditionsEvent();

        this.registerClearReferenceSelectionEvent(container);
        //this.registerReferenceCreate(container);
        this.referenceModulePopupRegisterEvent(container);

        this.registerAddReferenceSubscribersListEvent();

        this.registerDeleteRelClick();
        this.registerRefreshTotalClick();
        this.registerReportSelChange();
        this.registerFlexReportSelChange();
        this.RegisterViewRecordsClick();
        this.registerPostListLoadListener();
    }
});


