<?php

/**
 * JourneyFunnel Manager
 * WebApp
 *
 * @see http://www.jamiebutler.com/tutorials/iphone_web.php
 */
// ================================================================ includes

require_once('config.php');
//require_once('veb/classes/webapp.php');
require_once('veb/webapp/action.php');
require_once('veb/webapp/classes/html.php');
require_once('veb/webapp/classes/format.php');
require_once('veb/webapp/classes/datetime.php');
require_once('veb/webapp/classes/signing.php');
require_once('veb/webapp/classes/geomap.php');

//require_once('veb/webapp/classes/authenticate.php'); // handles all login
require_once('veb/webapp/modules/Webappusers.php');

require_once('includes/runtime/Globals.php');
require_once('includes/runtime/BaseModel.php');

require_once('include/utils/utils.php');
//require_once('modules/Users/Users.php');
//require_once('modules/Leads/Leads.php');
// ================================================================ Error timezone, session
// @see https://developer.apple.com/library/content/documentation/iPhone/Conceptual/SafariJSDatabaseGuide/OfflineApplicationCache/OfflineApplicationCache.html#//apple_ref/doc/uid/TP40007256-CH7-SW1
// @see https://developer.apple.com/library/content/documentation/iPhone/Conceptual/SafariJSDatabaseGuide/OfflineApplicationCache/OfflineApplicationCache.html#//apple_ref/doc/uid/TP40007256-CH7-SW1
session_start();

// Extend cookie life time by an amount of your liking
$cookieLifetime = 365 * 24 * 60 * 60; // A year in seconds
setcookie(session_name(), session_id(), time() + $cookieLifetime);

ini_set('display_errors', 1);
error_reporting(E_ERROR | E_WARNING | E_PARSE);
//error_reporting(E_ALL);
date_default_timezone_set("Europe/Amsterdam");
// ================================================================ Handle parameters
// get params -- only accept validated input
$mod = getParam('m', 'string');
$act = getParam('a', 'string');
$crmid = getParam('i', 'integer');
if ($crmid == '' && isset($_POST['i']))
{
    $crmid = $_POST['i'];
}

// ================================================================ Authenticate
// Check to see if there is an authenticated user in the session.
$user = new Webappusers();

if ($mod == 'users' && $act == 'logout')
{
    $user->logout();
} elseif ($mod == 'users' && $act == 'save')
{
//    echo '<li>unexpected action'; 
//    echo '<li>user: '.$login_user_name;
//    echo '<li>sessie: '.print_r($_SESSION);
//    print "<li>mod=$mod, act=$act, crmid=$crmid";
//    die();
}

$login_user_name = $user->login($application_unique_key);

// ================================================================ Dispatcher / Main routine

echo html::header();

$action = ActionFactory::create($mod, $act, $crmid);

if (!$action)
{
//$user->logout();
    $login_user_name = '';
}


if ($login_user_name)
{
    try {
        echo $action->getBody($crmid);
    } catch (Exception $e) {
        echo 'Caught exception: ', $e->getMessage(), "mod={$mod}, act={$act}, crmid={$crmid}\n";
    }
} else
{
    echo Webappusers::loginscreen();
}

echo html::footer();

// ================================================================ helpers

function getParam($name, $type = 'string')
{

    $options = array();
    $filter = '';

    if (!isset($_GET[$name]) || $_GET[$name] == '')
    {
        return '';
    }

    switch ($type)
    {
        case 'integer' :
            $filter = FILTER_VALIDATE_INT;
            $options['options']['min_range'] = 1;
            break;
        default:
            $filter = FILTER_DEFAULT;
    }

    $var = filter_input(INPUT_GET, $name, $filter, $options);

    return $var;
}
