<?php

/**
 * Request a crm id
 * - see if it is a converted Lead
 * - or a merged record
 * - or a normal one
 * 
 * @param integer id
 *
 * @return array 
 * - id => $id - same id as given
 * - setype => $setype, - name of the aobject if found
 * - result => $result, - converted|found|merged
 *
 * If converted or merged it will return data of the new crmid as follows:
 * - Lead => $leadId
 * - Account => $accountId
 * - Contact => $contactId
 *
 */
function get_wvacrmid($id)
{
    global $log, $adb;

    $result = false;
    $leadId = false;
    $accountId = false;
    $contactId = false;
    $setype = false;
    $messages = array();

    $orgid = $id;

    // can be merged more than once!
    $merged = wvacrmid_findmerged($id);
    if ($merged['result'] == 'merged')
    {
        $id = $merged['newid'];
        $messages[] = $merged['message'];
    } else
    {
        $messages[] = 'no merged found';
    }

    // can be converted only once
    $converted = wvacrmid_findconverted($id);
    if ($converted['result'] == 'converted')
    {
        $id = $converted['Contact_id'];
        $messages[] = $converted['message'];
    } else
    {
        $messages[] = 'no converted found';
    }

    // Again! can be merged more than once!
    $merged = wvacrmid_findmerged($id);
    if ($merged['result'] == 'merged')
    {
        $id = $merged['newid'];
        $messages[] = $merged['message'];
    } else
    {
        $messages[] = 'no merged2 found';
    }

    $found = wvacrmid_find($id);
    if ($found['result'] == 'found')
    {
        $setype = $found['setype'];
        $result = $found['result'];
        $leadId = $found['Lead_id'];
//        $accountId = $found['Account_id']; no need for having accounts at the moment
        $contactId = $found['Contact_id'];
        $message[] = '- ' . $found['message'];
    } else
    {
        $result = 'error';
        $message[] = "no results for id $id\n";
    }

    $return = array(
        'id' => $orgid,
        'setype' => $setype,
        'result' => $result,
        'Lead_id' => $leadId,
//        'Account_id' => $accountId,
        'Contact_id' => $contactId,
        'message' => implode(', ', $messages),
    );

    file_put_contents('/home/cs1002/public_html/logs/'.__FILE__ . '-'.date("Y-m").'.log', date("Y-m-d H:m:i") . ' - ' . __FUNCTION__ . ' - ' . print_r($return, true), FILE_APPEND);

    return $return;
}

/**
 * @return  array
 */
function wvacrmid_findconverted($id)
{
    global $adb;

    $leadId = 0;
    $accountId = 0;
    $contactId = 0;
    $newid = 0;
    $setype = false;
    $result = false;
    $message = '';

    // no need to see if the lead has converted=1
    $sql = " 
    SELECT * 
    FROM 
      vtiger_wv_converted as conv
    INNER JOIN 
      vtiger_crmentity as ce
    ON 
      conv.lead_id = ce.crmid
    WHERE 
      conv.lead_id = {$id}
      AND ce.deleted = 0;";

    // handle result
    //  we need to add info about merged records, unfortunately vtiger does not register that in a separate table
    $params = array();
    $resultConv = $adb->pquery($sql, $params);
    $noofrows = $adb->num_rows($resultConv); // get number of rows

    if ($noofrows > 0)
    {
        $result = 'converted';
        $setype = $adb->query_result($resultConv, 0, 'setype');
        $leadId = $id;
        $accountId = $adb->query_result($resultConv, 0, 'account_id');
        $contactId = $adb->query_result($resultConv, 0, 'contact_id');
        $message .= "Lead {$id} was converted to Account {$accountId} and Contact {$contactId}";
    }

    $return = array(
        'id' => $id,
        'setype' => $setype,
        'result' => $result,
        'Lead_id' => $leadId,
        'Account_id' => $accountId,
        'Contact_id' => $contactId,
        'message' => $message,
    );

    file_put_contents('/home/cs1002/public_html/logs/'.__FILE__ . '-'.date("Y-m").'.log', date("Y-m-d H:m:i") . ' - ' . __FUNCTION__ . ' - ' . print_r($return, true), FILE_APPEND);
    return $return;
}

/**
 * @return  array
 */
function wvacrmid_findmerged($id)
{
    global $adb;
    
    $leadId = 0;
    $accountId = 0;
    $contactId = 0;
    $newid = 0;
    $setype = false;
    $result = false;
    $message = '';

    // vtiger_wv_merged
    $sql = " 
    SELECT * 
    FROM 
      vtiger_wv_merged as merg
    INNER JOIN 
      vtiger_crmentity as ce
    ON 
      merg.crmid_source = ce.crmid
    WHERE 
      merg.crmid_source = {$id};";

    // handle result
    //  we need to add info about merged records, unfortunately vtiger does not register that in a separate table
    $params = array();
    $resultMerg = $adb->pquery($sql, $params);
    $noofrows = $adb->num_rows($resultMerg); // get number of rows

    if ($noofrows > 0)
    {
        $result = 'merged';
        $setype = $adb->query_result($resultMerg, 0, 'setype');
        $crmid_target = $adb->query_result($resultMerg, 0, 'crmid_target');
        $newid = $crmid_target;
        switch ($setype)
        {
            case 'Leads': $leadId = $crmid_target;
                break;
            case 'Accounts': $accountId = $crmid_target;
                break;
            case 'Contacts': $contactId = $crmid_target;
                break;
            default:
                $result = false;
                $message .= "problem finding right id with setype";
        }
        $message .= "{$setype} {$id} was merged with $setype {$crmid_target}";
    }

    // assumed: since we call the same function this will loop until no further merged records are found
    if ($leadId > 0 && $leadId <> $id)
    {
        $newlead = wvacrmid_findmerged($leadId);
        if ($newlead['result'] == 'merged')
        {
            $leadId = $newlead['Lead_id'];
            $message .= "{$setype} {$id} was merged with {$setype} {$crmid_target}";
        }
    }

    if ($accountId > 0)
    {
        $newaccount = wvacrmid_findmerged($accountId);
        if ($newaccount['result'] == 'merged')
        {
            $accountId = $newaccount['Account_id'];
            $message .= "{$setype} {$id} was merged with {$setype} {$crmid_target}";
        }
    }

    if ($contactId > 0)
    {
        $newcontact = wvacrmid_findmerged($contactId);
        if ($newcontact['result'] == 'merged')
        {
            $contactId = $newaccount['Contact_id'];
            $message .= "{$setype} {$id} was merged with {$setype} {$crmid_target}";
        }
    }

    $return = array(
        'id' => $id,
        'newid' => $newid,
        'setype' => $setype,
        'result' => $result,
        'Lead_id' => $leadId,
        'Account_id' => $accountId,
        'Contact_id' => $contactId,
        'message' => $message,
    );

    file_put_contents('/home/cs1002/public_html/logs/'.__FILE__ . '-'.date("Y-m").'.log', date("Y-m-d H:m:i") . ' - ' . __FUNCTION__ . ' - ' . print_r($return, true), FILE_APPEND);
    return $return;
}

function wvacrmid_find($id)
{
    global $adb;
    
    $leadId = 0;
    $accountId = 0;
    $contactId = 0;
    $newid = 0;
    $setype = false;
    $result = false;
    $message = '';

    // look in normal tables
    // don't do this first because then we dontsee if a lead is converted
    $sql = "SELECT * FROM vtiger_crmentity as ce WHERE ce.crmid = {$id} AND ce.deleted = 0;";

    $params = array();
    $resultCe = $adb->pquery($sql, $params);
    $noofrows = $adb->num_rows($resultCe); // get number of rows

    if ($noofrows > 0)
    {
        $setype = $adb->query_result($resultCe, 0, 'setype');
        $result = 'found';
        $message .= "found an existing {$setype} for id {$id}";
        switch ($setype)
        {
            case 'Leads': $leadId = $id;
                break;
            case 'Accounts': $accountId = $id;
                break;
            case 'Contacts': $contactId = $id;
                break;
            case 'Installations':
                $sql = "SELECT * FROM vtiger_installations as inst WHERE inst.installationsid = {$id};";  // dont care if it is deleted or not..
                $params = array();
                $resultInst = $adb->pquery($sql, $params);
                $noofrows = $adb->num_rows($resultInst); // get number of rows
            
                if ($noofrows > 0)
                {
                    $contactId = $adb->query_result($resultInst, 0, 'inst_contact');
                    $message .= " found an existing Contact for id {$contactId}";
                }
                break;
            default:
                $result = false;
                $message .= "problem finding right id with setype";
        }
    }

    $return = array(
        'id' => $id,
        'setype' => $setype,
        'result' => $result,
        'Lead_id' => $leadId,
        'Account_id' => $accountId,
        'Contact_id' => $contactId,
        'message' => $message,
    );

    file_put_contents('/home/cs1002/public_html/logs/'.__FILE__ . '-'.date("Y-m").'.log', date("Y-m-d H:m:i") . ' - ' . __FUNCTION__ . ' - ' . print_r($return, true)."\n", FILE_APPEND);
    return $return;
}
