<?php

// https://castellum.vicus.nl/include/Webservices/VebGetFormData.php
// we want to use get_wvacrmid
include 'VebWvaCrmId.php';

/**
 * Returns relevant formdata to prefill a form from a given crmid
 * @param   integer id
 * @param   string  key
 * @param   string formid
 * @param   string  hash
 * @return  json
 */
function get_wvaformdata($id, $versionRaw = 1, $formid = 0, $hash = 'hash')
{
    global $adb;

    $newData = array();

    $urlparams = explode('f', $versionRaw);
    $date = $urlparams[1];
    $version = $urlparams[0];

// 0b != 2fe01f42231c9cc1e7f3be8a1200f159 75265.1a2aed517d6176d.14012211019102.1"
//    $hashHasToBe = md5($id.$date.$version.$formid.'j863hbskd998i23j');
// removed formid since it gives problems in mixing php and js in client
    $hashHasToBe = md5($id.$date.$version.'j863hbskd998i23j');

    $id = intval($id);

    if ($hash != $hashHasToBe) 
    {
//        $errMsg = " $hash != $hashHasToBe $id.$date.$version.$formid";
        $errMsg = " $hash != $hashHasToBe $id.$date.$version";
        $result = false;
    
    } 
    else if ($id > 0 && $version == 1)
    {
        // see if we have a valid id (or converted, merged, deleted)
        $data = get_wvacrmid($id);

        // dataformat as
        $crmid = $data['id'];
        $setype = $data['setype'];
        $result = $data['result'];
        $leadId = $data['Lead_id'];
        $contactId = $data['Contact_id'];
    } 
    else
    {
        $errMsg = " $id > 0 && $version == 1 ";
        $result = false;
    }

    $sql = '';
    
    if ($result == 'found')
    {
        switch (strtolower($setype))
        {
            case 'leads':
                $crmid = $leadId;
                $sql = "SELECT d.salutation, d.firstname, d.lastname, d.email, d.company, a.phone, a.mobile, d.veb_l_mautic_leadid as mautic_leadid
                        FROM vtiger_leaddetails d, vtiger_leadaddress a
                        WHERE d.leadid = a.leadaddressid
                        AND d.leadid = ?";
                break;
            case 'contacts':
            case 'installations':
                $crmid = $contactId;
                $setype = 'Contacts';
                $sql = "SELECT c.salutation, c.firstname, c.lastname, c.email, c.phone, c.mobile, a.accountname as company, c.veb_c_mautic_leadid as mautic_leadid
                        FROM vtiger_contactdetails as c
                        JOIN vtiger_account as a
                        ON c.accountid = a.accountid
                        WHERE c.contactid = ?";
                break;
            default:
            // no results, no actions
        }

        if ($sql)
        {
            $params = array($crmid);
            $result = $adb->pquery($sql, $params);
            $noofrows = $adb->num_rows($result); // get number of rows
            if ($noofrows > 0)
            {
                $newData = $adb->query_result_rowdata($result, 0);
            }
        }
    }

    $fieldmapping = array(
        'companyname' => "mauticform[organisatie]",
        'firstname' => "mauticform[voornaam]",
        'lastname' => "mauticform[achternaam]",
        'email' => "mauticform[email]",
        'phone' => "mauticform[telefoon]",
        'mobile' => "mauticform[mobile]",
    );

    if (count($newData > 0) && $setype != '')
    {
        $return = array(
            'status' => 'succes',
            'code' => '200',
            'data' => array(
                'setype' => $setype,
                'crmid' => $crmid,
                'mautic_leadid' => $newData['mautic_leadid'],
                'companyname' => $newData['company'],
                'firstname' => $newData['firstname'],
                'lastname' => $newData['lastname'],
                'email' => $newData['email'],
                'phone' => $newData['phone'],
                'mobile' => $newData['mobile']
            ),
            'fieldmapping' => $fieldmapping,
            'message' => "Details fetched successfully"
        );
    } else
    {
        $return = array(
            'status' => 'error',
            'code' => '400',
            'message' => "no valid data or no data found x " . $errMsg . print_r($newData),
            );
    }

    file_put_contents(__FILE__ . '.log', date("Y-m-d H:m:i") . ' - ' . __FUNCTION__ . " - id=$id, version=$version, date = $date, formid = $formid, hash=$hash " . print_r($return, true)."\n", FILE_APPEND);
    return json_encode($return);
}
