<?php

include_once "VebWvaCrmId.php";

/**
 * Request a mautic lead id
 * find & return the related crm entity and crmid
 * 
 * @param integer id
 *
 * @return array 
 * -status => $id - same id as given
 *  code
 * -data array
 *      setype => $setype, - name of the aobject if found
 *      crmid => $crm entity id
 * -message => $messae, - converted|found|merged
 *
 */
function get_vebentityidbymauticid($mauticid, $version = 1, $hash = 'hash')
{
    // fieldname contact
    $entityid = get_vebcontactbymauticid($mauticid);
    
    // fieldname lead
    
    if (!$entityid ) {
        $entityid = get_vebleadbymauticid($mauticid);
    }
    
    
    // see if we have a lead
    
    // see if we have a contact
    
    // see if it is converted / deduplicated or else in the meantime
    
    $entity = get_wvacrmid($entityid);
    
    if ($entity['result'] == 'error') {
        $crmid = '';
        $status = 'error';
        $statuscode = 400;
        $message = "Error - {$entity['message']}";
    } 
    else {
        if ( !empty($entity['Lead_id']) ) {
            $crmid = $entity['Lead_id'];
            $status = 'succes';
            $statuscode = 200;
            $message = "Lead details fetched successfully ".$entity['message'];
        } elseif ( !empty($entity['Contact_id']) ) {
            $crmid = $entity['Contact_id'];
            $status = 'succes';
            $statuscode = 200;
            $message = "Contact details fetched successfully ". $entity['message'];
        } else {
            $crmid = '';
            $status = 'error';
            $statuscode = 400;
            $message = "Error - setype {$entity['setype']} not supported ".$entity['message'];
        } 
    }

    $return = array(
        'status' => $status,
        'code' => $statuscode,
        'data' => array(
            'setype' => $entity['setype'],
            'id' => $crmid
        ),
        'message' => $message,
    );
    
    return json_encode($return);
}

function get_vebcontactbymauticid($mauticid)
{
    global $adb;

    // SELECT leadid FROM vtiger_leaddetails WHERE veb_l_mautic_leadid = 31585
    
    $sql = " 
    SELECT contactid
    FROM 
      vtiger_contactdetails
    WHERE 
      veb_c_mautic_leadid = {$mauticid};";

    // handle result
    //  we need to add info about merged records, unfortunately vtiger does not register that in a separate table
    $params = array();
    $resultMerg = $adb->pquery($sql, $params);
    $noofrows = $adb->num_rows($resultMerg); // get number of rows

    if ($noofrows > 0)
    {
        $crmid = $adb->query_result($resultMerg, 0, 'contactid');
    } 
    else {
        $crmid = false;
    }

    return $crmid;
}

function get_vebleadbymauticid($mauticid)
{
    global $adb;

    // SELECT leadid FROM vtiger_leaddetails WHERE veb_l_mautic_leadid = 31585
    
    $sql = " 
    SELECT leadid
    FROM 
      vtiger_leaddetails
    WHERE 
      veb_l_mautic_leadid = {$mauticid};";

    // handle result
    //  we need to add info about merged records, unfortunately vtiger does not register that in a separate table
    $params = array();
    $resultMerg = $adb->pquery($sql, $params);
    $noofrows = $adb->num_rows($resultMerg); // get number of rows

    if ($noofrows > 0)
    {
        $crmid = $adb->query_result($resultMerg, 0, 'leadid');
    } 
    else {
        $crmid = false;
    }

    return $crmid;
}