<?php
// need to get the config from vtiger
require_once('include/utils/utils.php');
require_once('include/database/PearDatabase.php');

$hubActionPath = 'veb/hub/';

if (file_exists($hubActionPath . 'config.php'))
{
  $class = 'vtAction';

  require_once($hubActionPath . 'config.php');

  require_once($hubActionPath . 'classes/Log.php');

  require_once($hubActionPath . 'functions/translate.php');
  require_once($hubActionPath . 'action.php');

  if (VEBHUB_DEBUG)
  {
    error_reporting(E_ALL & ~E_NOTICE & ~E_STRICT & ~E_DEPRECATED);
    ini_set('display_errors', '1');
  }
  else
  {
    error_reporting(0);
    ini_set('display_errors', '0');
  }

  $actionHubAction = strtolower($_GET['a']);

  $actual_link = $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

  HubLog::info("start {$actionHubAction} ----- ".$actual_link);
  
  // opvragen settings from hubconfig
  $action = new vtAction($actionHubAction);

  // @change 170204 lro all lowwr
  $actionHubLanguage = strtolower($action->getLanguage());
  $actionApplication = strtolower($action->getApplication());
  $actionRequest = strtolower($action->getModule());

  if (file_exists($hubActionPath . 'languages/' . $actionHubLanguage . '.php'))
  {
    include($hubActionPath . 'languages/' . $actionHubLanguage . '.php');
    include($hubActionPath . 'languages/' . $actionHubLanguage . '_custom.php');
  } else {
    HubLog::error(__FILE__." languagefile [{$actionHubLanguage}] is missing ");
  }

  // see if a application action-class is defined
  if (file_exists($hubActionPath . 'action/' . $actionApplication . '/' . $actionApplication . '.php'))
  {
    include($hubActionPath . 'action/' . $actionApplication . '/' . $actionApplication . '.php');
    
    // extend class name
    $class .= '_' . ucfirst(strtolower($actionApplication));

    // see if a request action-class is defined
    if (file_exists($hubActionPath . 'action/' . $actionApplication . '/' . $actionRequest . '/' . $actionRequest . '.php'))
    {
      include($hubActionPath . 'action/' . $actionApplication . '/' . $actionRequest . '/' . $actionRequest . '.php');

      // extend class name
      $class .= '_' . ucfirst(strtolower($actionRequest));

      // hubAction must exist!
      if (file_exists($hubActionPath . 'action/' . $actionApplication . '/' . $actionRequest . '/' . $actionHubAction . '.php'))
      {
        include($hubActionPath . 'action/' . $actionApplication . '/' . $actionRequest . '/' . $actionHubAction . '.php');

        // extend class name
        $class .= '_' . ucfirst(strtolower($actionHubAction));
      }
    } else {
      HubLog::error(__FILE__." actionApplication [{$hubActionPath}action/{$actionApplication}/{$actionRequest}.php] is missing ");
    }
    
  } else {
    HubLog::error(__FILE__." actionApplication [{$hubActionPath}action/{$actionApplication}.php] is missing ");
  }

  $action = new $class($actionHubAction);

  $result = $action->run();
  $action->redirect($result);
  exit();
}

// cannot be translated, invalid action language is not defined
echo 'should_never_get_here';
HubLog::critical(__FILE__." config [{$hubActionPath}config.php] is missing ");