<?php
/**
 * script to recover relations
 * 
 * @package	WebVisitAnalyser
 * @author	l.roovers
 * @version	3 feb 2016
 *
 * Version 3 feb 2016
 * - added query to get all Webvisits related to Accounts 
 * - removed some debugging leftovers
 * - reduced errorreporting level
 *
 * @todo	use script from WbeVisitAnalyser must be part of crn/vtiger or do this via the api!
 * @todo	add other modules (Contacts, Campaigns) to the update query
**/

ini_set("include_path", "../");
set_time_limit(0);

chdir( dirname(__FILE__) );

ini_set('display_errors', 1);
error_reporting(E_ALL & ~E_NOTICE);

require_once('config.php');
require_once('include/utils/utils.php');

updateCrmRel('leads');
updateCampaign('leads');

updateCrmRel('accounts');
updateCampaign('accounts');

updateCrmRel('contacts');
updateCampaign('contacts');

updateCrmRel('campaigns');

echo "<li>Finished";

die();


// ======================================================================================== functions

function updateCrmRel($module)
{
  global $adb;

  switch (strtolower($module))
  {
  
    case 'leads':
        $idfield = 'leadid';
  		  $module1 = "Leads";
        break;

    case 'accounts':
        $idfield = 'accountid';
    		$module1 = "Accounts";
        break;

    case 'contacts':
        $idfield = 'contactid';
    		$module1 = "Contacts";
        break;

    case 'campaigns':
        $idfield = 'campaignid';
    		$module1 = "Campaigns";
        break;

    default:
        // error
        echo "wrong module name";
        return false;  
  }

  // get all Webvisits related to lea/ac/con/cam that are not in the crmentityrel table
  $sql = "SELECT vtiger_webvisits.webvisitsid, vtiger_webvisits.{$idfield}, vtiger_webvisits.campaignid 
          FROM vtiger_webvisits 
          WHERE NOT EXISTS (SELECT 1 FROM vtiger_crmentityrel WHERE vtiger_crmentityrel.relcrmid=vtiger_webvisits.webvisitsid) 
          AND {$idfield} > 0;";
  
  echo "<li>Inserting crmentity relations for $module: ";
  
  $result 	= $adb->pquery($sql, array());
  $numrows 	= $adb->num_rows($result);
  
  if ($numrows==0) 
  {
  	echo("<li>Nothing to do for {$module}");
  } 
  else {
  	
  	for($i=1;$i<=$numrows;$i++)
  	{
  	
  		$aCrmRecord = $adb->fetch_array($result);
  	
  		$webvisitsid = $aCrmRecord['webvisitsid'];
  		$recid = $aCrmRecord[$idfield];
  		$campaignid = $aCrmRecord['campaignid'];
  	
  		$module2 = "WebVisits";
  	
  		$update_query = "INSERT INTO `vtiger_crmentityrel`
  			(`crmid`, `module`, `relcrmid`, `relmodule`) 
  			VALUES ($recid,'$module1',$webvisitsid,'$module2');";
  				
  		$adb->pquery($update_query, array());
  		//print '.';
      print "{$webvisitsid}/{$recid}, ";
      print "<li>$insert_query";
  
  	}
  }
}


function updateCampaign($module)
{
  global $adb;

  switch (strtolower($module))
  {
  
    case 'leads':
        $idfield = 'leadid';
        $reltable = 'vtiger_campaignleadrel';
        break;

    case 'accounts':
        $idfield = 'accountid';
        $reltable = 'vtiger_campaignaccountrel';
        break;

    case 'contacts':
        $idfield = 'contactid';
        $reltable = 'vtiger_campaigncontrel';
        break;
        
    default:
        // error
        echo "wrong module name";
        return false;  
  }

  // get all Webvisits with leads that have not direct campaign
  $sql = "
    SELECT vtiger_webvisits.webvisitsid, vtiger_webvisits.{$idfield}, vtiger_webvisits.campaignid
    FROM vtiger_webvisits 
    WHERE NOT EXISTS (SELECT 1 FROM {$reltable} WHERE {$reltable}.{$idfield}=vtiger_webvisits.{$idfield } AND {$reltable}.campaignid=vtiger_webvisits.campaignid) 
    AND vtiger_webvisits.{$idfield} > 0 AND vtiger_webvisits.campaignid > 0
    GROUP BY vtiger_webvisits.campaignid, vtiger_webvisits.accountid;";
  
  echo "<li>Checking campaigns relation for {$module}"; // sql={$sql} 
  
  $result 	= $adb->pquery($sql, array());
  $numrows 	= $adb->num_rows($result);
  
  // INSERT INTO vtiger_campaignleadrel (`campaignid`, `leadid`, `campaignrelstatusid`) VALUES(237558, 234080, '1');
  echo " $numrows records to process: ";
  
  if ($numrows==0) 
  {
  	echo("<li>No {$module}/campaings relations missing");
  } 
  else {
  	for($i=1;$i<=$numrows;$i++)
  	{
  	
  		$aCrmRecord = $adb->fetch_array($result);
  
  		$recid = $aCrmRecord[$idfield];
  		$campaignid = $aCrmRecord['campaignid'];
  			
      $insert_query = "INSERT INTO {$reltable} 
        (`campaignid`, `{$idfield}`, `campaignrelstatusid`)
        VALUES($campaignid, $recid, '1'); ";
  
    		$adb->pquery($insert_query, array());
    		print "{$campaignid}/{$recid}, ";
//  		print "<li>$insert_query";
  
  	}
  }
}

die();
// hieronder staat blijkbaar oude kode //


// get all Webvisits related to leads that are not in the crmentityrel table
$sql = "SELECT vtiger_webvisits.webvisitsid, vtiger_webvisits.leadid, vtiger_webvisits.campaignid FROM vtiger_webvisits WHERE NOT EXISTS(SELECT 1 FROM vtiger_crmentityrel WHERE vtiger_crmentityrel.relcrmid=vtiger_webvisits.webvisitsid) AND leadid > 0;";

echo "<br>Checking Leads: ";

$result 	= $adb->pquery($sql, array());
$numrows 	= $adb->num_rows($result);

if ($numrows==0) {
	echo('No Leads');
} elseif (1==2) {
	
	for($i=1;$i<=$numrows;$i++)
	{
	
		$aCrmRecord = $adb->fetch_array($result);
	
		$webvisitsid = $aCrmRecord['webvisitsid'];
		$leadid = $aCrmRecord['leadid'];
		$campaignid = $aCrmRecord['campaignid'];
	
		$module1 = "Leads";
		$module2 = "WebVisits";
	
		$update_query = "INSERT INTO `vtiger_crmentityrel`
			(`crmid`, `module`, `relcrmid`, `relmodule`) 
			VALUES ($leadid,'$module1',$webvisitsid,'$module2');";
				
		$adb->pquery($update_query, array());
		print '.';

	}
}


// get all Webvisits related to Accounts that are not in the crmentityrel table

$sql = "SELECT vtiger_webvisits.webvisitsid, vtiger_webvisits.accountid, vtiger_webvisits.campaignid FROM vtiger_webvisits WHERE NOT EXISTS(SELECT 1 FROM vtiger_crmentityrel WHERE vtiger_crmentityrel.relcrmid=vtiger_webvisits.webvisitsid) AND accountid > 0;";


$result 	= $adb->pquery($sql, array());
$numrows 	= $adb->num_rows($result);

echo "<br>Checking Accounts: ";

if ($numrows==0) {
	echo('no Accounts');
} else {
	for($i=1;$i<=$numrows;$i++)
	{
	
		$aCrmRecord = $adb->fetch_array($result);
	
		$webvisitsid = $aCrmRecord['webvisitsid'];
		$accountid = $aCrmRecord['accountid'];
		$campaignid = $aCrmRecord['campaignid'];
			
		$module1 = "Accounts";
		$module2 = "WebVisits";
	
		$update_query = "INSERT INTO `vtiger_crmentityrel`
			(`crmid`, `module`, `relcrmid`, `relmodule`) 
			VALUES ($accountid,'$module1',$webvisitsid,'$module2');";
		
		//echo $update_query."<br>";
		
		$adb->pquery($update_query, array());
		print '.';
	}
}


// get all Webvisits related to Campaigns that are not in the crmentityrel table

$sql = "SELECT vtiger_webvisits.webvisitsid, vtiger_webvisits.campaignid FROM vtiger_webvisits WHERE NOT EXISTS(SELECT 1 FROM vtiger_crmentityrel WHERE vtiger_crmentityrel.relcrmid=vtiger_webvisits.webvisitsid) AND vtiger_webvisits.campaignid > 0;";

$result 	= $adb->pquery($sql, array());
$numrows 	= $adb->num_rows($result);

echo "<br>Checking Campaigns: ";

if ($numrows==0) 
{
	echo('no Campaigns');
} else {
	for($i=1;$i<=$numrows;$i++)
	{
		$aCrmRecord = $adb->fetch_array($result);
	
		$webvisitsid = $aCrmRecord['webvisitsid'];
		$campaignid = $aCrmRecord['campaignid'];
	
		$module1 = "Campaigns";
		$module2 = "WebVisits";
	
		$update_query = "INSERT INTO `vtiger_crmentityrel`
			(`crmid`, `module`, `relcrmid`, `relmodule`) 
			VALUES ($campaignid,'$module1',$webvisitsid,'$module2');";
		
		echo "<br>".$update_query."<br>";
		
		$adb->pquery($update_query, array());
		print '.';
	}
}

?>