<?php
/**
 * script
 * 
 * 
 * @author	l.roovers
 * @copyright	Vicus eBusiness Solutions BV
 * Let op de query is op maat gemaakt !!
 *
 * Hanleiding
 * - run dit script
 * - check in de leadlijst bij welke Leadrecords een checkbox aan staan
 * - check of je infromtie uit deze lead  wilt overzetten naar de account of wilt verwijderen
 * - eventueel kun je de lead ook converteren als deze info beter of recenter is. Als de bedrijfsnaam 100% overeenkomt wordt de oude vervangen, anders wordt deze als account toegevoegd (normaal vtiger gedrag).
 */

// Custom fieldname to UPDATE
$field_leadToCheckboxForDuplicate = array('leadscf','cf_1465');

// Custom fieldnames to SELECT
// cf fields are not supported (yet)
//
$fieldname_accCocNr = 'vtiger_account.c_coc_number';
$fieldname_leaCocNr = 'vtiger_leaddetails.c_coc_number';

/**
 * ===================================== changes below this line should not be neccessary ======================================= 
 */

ini_set("include_path", "../");
ini_set('memory_limit', '-1');
set_time_limit(0);

chdir( dirname(__FILE__) );

require_once('config.php');
require_once('include/utils/utils.php');
 
global $log;
global $adb;

error_reporting(E_ALL & ~E_NOTICE);
 
/* 
Build an array with leadid that needs a box checked

Where alternatives
		vtiger_leaddetails.company = vtiger_account.accountname
		vtiger_leaddetails.c_coc_number = vtiger_account.c_coc_number 
		vtiger_leaddetails.wv_sfcocnumber = vtiger_account.c_coc_number
		vtiger_leaddetails.c_coc_number = vtiger_account.wv_sfcocnumber
result:
	lead not covert
	lead not deleted
	Duplicate Accounts
pending:
	Account not deleted

	Limit 2000 ?
	// dont know if this is heavy query, so take max
	// if there are more we catch them on next run
*/


// 
$where = "{$fieldname_leaCocNr} = {$fieldname_accCocNr} AND {$fieldname_leaCocNr} != ''";
$aResult[] = find($where);
	
$where = "vtiger_leaddetails.company = vtiger_account.accountname";
$aResult[] = find($where);

$where = "vtiger_leaddetails.wv_sfcocnumber = {$fieldname_accCocNr} AND vtiger_leaddetails.wv_sfcocnumber != '' AND {$fieldname_accCocNr} != ''";
$aResult[] = find($where);

$where = "{$fieldname_leaCocNr} = vtiger_account.wv_sfcocnumber AND {$fieldname_leaCocNr} != '' AND vtiger_account.wv_sfcocnumber !='' ";
$aResult[] = find($where);

// compose the final result
$finalResult = array();
foreach ($aResult as $id => $oneResult) {
	print "<li> {$id}: ".count($oneResult['leaFound']). " leads";
	$finalResult = array_merge($finalResult, $oneResult['leaFound']);
}
$finalResult = array_unique($finalResult);

asort($finalResult);

if (isset($_GET['test'])) {
    print "<li>Final Unique: ".count($finalResult). " leads";
    print_r( $finalResult );
}

//$result = update($leadsToCheckbox);
$result = update(implode(',',$finalResult));

die();


/** 
 * find all leads that are dulicate
 * 
 * DONT GET CUSTIM FIELDS HERE!!!
 * 
 * @todo	checks now only for vtiger_crmentity.deleted of the lead I guess
 * 
 * @param	string	custom where clause to be added
 * @return	array	containing arrays woth results
 */
function find ($where)
{
	global $adb;

	$sql = "
		SELECT 
			leade.crmid,
			accounte.crmid,
			vtiger_leaddetails.leadid, 
			vtiger_leaddetails.company, 
			vtiger_account.accountid,
			vtiger_account.accountname
		FROM
			vtiger_leaddetails
		LEFT JOIN 
			vtiger_crmentity leade
		ON 
			vtiger_leaddetails.leadid = leade.crmid
		LEFT JOIN
			vtiger_leadscf
		ON 
			vtiger_leaddetails.leadid = vtiger_leadscf.leadid
		CROSS JOIN
			 vtiger_account
		LEFT JOIN 
			vtiger_crmentity accounte
		ON 
			vtiger_account.accountid = accounte.crmid
		LEFT JOIN
			vtiger_accountscf
		ON 
			vtiger_account.accountid = vtiger_accountscf.accountid
		WHERE
			{$where}
			AND leade.deleted = 0
			AND vtiger_leaddetails.converted = 0
			AND accounte.deleted = 0
	";
	// 			AND vtiger_leaddetails.converted = 0

if (isset($_GET['test'])) {
	echo "<li>{$sql}";
}
	
	$result	= $adb->pquery($sql, array());
	
	if (!$result) 
	         print_r( $adb );
	
	$rows = $adb->num_rows($result);	
	
if (isset($_GET['test'])) {
	echo "<li>{$rows} Leads: ";
}
	//print_r($adb);
	
	$leaFound = array(); 
	$accFound = array();
	$accountlist  = array();
	$leadlist  = array();
	
	for($i=0;$i<$rows;$i++)
	{
		$leaFound[$i] = $adb->query_result($result, $i, "leadid");
		$accFound[$i] = $adb->query_result($result, $i, "accountid");
	
		$leaName[$i] = $adb->query_result($result, $i, "company");
		$accName[$i] = $adb->query_result($result, $i, "accountname");
	
		 
	//	echo "<li>{$leaFound[$i]} = {$accFound[$i]}";
	if (isset($_GET['test'])) {
		echo "<li>{$leaFound[$i]} {$leaName[$i]} = {$accFound[$i]} {$accName[$i]}";
	}

		
		if (isset($duplicateLea[$leaFound[$i]])) {
			$leadlist[$leaFound[$i]] = $leaFound[$i];
		} else {
			$duplicateLea[$leaFound[$i]] = $leaFound[$i];
		}		

		/** now we know that there are more than one lead connected, but we did not find duplicate accounts
		if (isset($duplicateAcc[$accFound[$i]])) {
			$accountlist[$accFound[$i]] = $accFound[$i];
		} else {
			$duplicateAcc[$accFound[$i]] = $accFound[$i];
		}
		*/
		
	}

	return array(
		'leaFound' => array_unique($leaFound),
		'leaDuplicates' => array_unique($leadlist),
		'accDuplicates' => array_unique($accountlist)
	);
}


/**
 * 
 * Update Leads checkbox
 * 
 * Set fieldLeadChechbox = checked
 * 
 * @param	string		Where leadid in leadsToCheckbox
 */
function update ( $leadlist )
{
	global $adb;
	global $config;
	global $field_leadToCheckboxForDuplicate;

	$sql = "
	UPDATE 
		vtiger_leadscf AS lcf
	SET 
		{$field_leadToCheckboxForDuplicate[1]} = 1
	WHERE
		lcf.leadid IN ({$leadlist})
	";		
	
	if (isset($_GET['test'])) {
	print $sql;
	}
	
	$result	= $adb->pquery($sql, array());
	
// print_r($adb);
	
	//if (!$result) print $adb->ErrorMsg();
}