<?php

/**
 * script to calculate scores
 * 
 * @package	WebVisitAnalyser
 * @author	l.roovers
 * @version	12 feb 2017
 *
 * Version 3 feb 2016
 * - added query to get all Webvisits related to Accounts
 * - removed some debugging leftovers
 * - reduced errorreporting level
 *
 * version 12 feb 2017
 * - caching added, no duplicate queries are called
 * - reset all dates to NULL first (so we are sure to remove all wrong values, even if visits here removed)
 * - check for resulting 0000-00-00 and change that to NULL
 * - only write date (no more time) preparing for removing the uitype 1000
 * - shortRun can be started with cli param (--mode=shortrun) shortRun (or ?mode=shortrun
 *
 * @todo	use script from WebVisitAnalyser must be part of crm/vtiger or do this via the api!
 * @todo	add other modules (Contacts) to the update query
 */
ini_set("include_path", "../");
ini_set('memory_limit', '-1');
set_time_limit(0);

chdir( dirname(__FILE__) );

require_once('config.php');
require_once('include/utils/utils.php');

error_reporting(E_ALL & ~E_NOTICE);

if( lockfile::locked(__FILE__) )
{
    die();
}

$calculateLea = new ScoreCalculator('lead');

$calculateLea->run();

$calculateAcc = new ScoreCalculator('account');

$calculateAcc->run();

$calculateCam = new ScoreCalculator('campaign');

$calculateCam->run();

echo "<li>Ready."; die();


// =============================================================================================
// to be decided to run from workflow or cron (prefere from workflow, trigger on Webvisit module)
// so perspective is different
// from Webvisit we look which records are related and we fill teh info of these records

/**
 * 
 * steps:
 * 
 * 1. resetDates (optional) to empty all data
 * 
 * 2. _getVisits Get WebVisits
 * 
 * 3. Walk though the related Lea, Con, Acc, Cam
 *    foreach of them:
 *    a. find related visits
 *    b. recalculate the scores
 *    c. update if required
 * 
 * We need to fill the fllowing data:
 * - wv_score (integer)
 * - wv_sourcefirstvisit (textfield)
 * - wv_searchterms (concat)
 * - wv_allsources (concat)
 * - wv_nofvisits (integer)
 * - wv_nofpages (integer)
 * - wv_scoregroups (multiselect)
 */
class ScoreCalculator
{

    private $_cache = array();
    
    private $_shortRunEnabled = false;
    
    private $_shortRunInterval = " INTERVAL -2 DAY ";
    
    private $_module = '';

    private $_moduleIdField = '';

    private $_moduleIdFields = array(
      'lead' => 'leadid',
      'account' => 'accountid',
      'campaign' => 'campaignid',
      'contact' => 'contactid'
    );

    private $_moduleTableNames = array(
      'lead' => 'vtiger_leaddetails',
      'account' => 'vtiger_account',
      'campaign' => 'vtiger_campaign',
      'contact' => 'vtiger_contact'
    );

    /**
     * Fields to recalculate
     */
    
    private $_wv_nofpages = 0;
    
    private $_wv_score = 0;
    
    private $_wv_searchterms = array();
    
    private $_wv_allsources = array();

    private $_wv_sourcefirstvisit = '';
    
    private $_wv_scoregroups = array();
    
    private $_wv_datefirstvisit = NULL;
    
    private $_wv_datelastvisit = NULL;

    function __construct($module = '')
    {

        $this->_module = strtolower($module);

        if(!isset($this->_moduleIdFields[$this->_module])) 
        {
            echo '<li>Wrong module set '.$this->_module;
            return FALSE;
        } else {
            $this->_moduleTableName = $this->_moduleTableNames[$this->_module];
            $this->_moduleIdField = $this->_moduleIdFields[$this->_module];
        }
        
        // web
        $mode = filter_input(INPUT_GET, 'mode', FILTER_SANITIZE_ENCODED);
        if ($mode === 'shortrun')
        {
            $this->_shortRunEnabled = true;
            echo "<li>ShortRun enabled via web";
        }

        // cli
        $shortopts = '';
        $longopts = array('mode:');
        $options = getopt($shortopts, $longopts);

//        if (isset($argv[1]) && $argv[1] == 'shortrun')
        if (isset($options['mode']) && $options['mode'] == 'shortrun')
        {
          $this->_shortRunEnabled = true;
          echo "- Shortrun enabled via cli\n";
        }
        
        echo ($this->_shortRunEnabled) ? "" : "- long run\n";
        
//        echo "<li>Module = {$this->_module}, idField = {$this->_moduleIdField}";
        
    }

    /**
     * Run the whole stuff
     * @return void
     */
    public function run()
    {
        global $adb;
        
        if (!$this->_shortRunEnabled) 
        {
            $this->_resetDates();
        }

        $visits = $this->_getVisits();
        
        $rows = $adb->num_rows($visits);
        
        echo "- {$rows} {$this->_module}, {$this->_moduleIdField}\n";
        
        for($i=0;$i<$rows;$i++)
        {
          $crmid = $adb->query_result($visits, $i, $this->_moduleIdField);
          $this->_relatedWebVisits($crmid);
        }

    }

    /**
     * Reset all wva related date fields to null
     * @return  void
     */
    private function _resetDates()
    {

        $set = array(
            "wv_datefirstvisit = NULL",
            "wv_lastvisitdate = NULL",
        );

        $sql = "UPDATE {$this->_moduleTableName} SET ".implode(', ', $set) . " ;";
        
        $this->_runQuery($sql);
    }

    private function _getVisits()
    {
        // we need to have all id's, and recalc all OR one of them
        // query after each update of a webvisit record
        
        $sql = "SELECT
                    wvi.{$this->_moduleIdField}, wvi.webvisitsid
                FROM 
                    vtiger_webvisits AS wvi
                INNER JOIN 
                    vtiger_crmentity AS ce
                ON 
                    wvi.webvisitsid = ce.crmid
                WHERE 
                    ce.deleted=0
                    AND wvi.{$this->_moduleIdField} != 0
                ";

        /*
        $sql = "SELECT
                    wvi.{$this->_moduleIdField}, wvi.webvisitsid
                FROM 
                    vtiger_webvisits AS wvi
                WHERE 
                    wvi.{$this->_moduleIdField} != 0
                ";
        */

        if ($this->_shortRunEnabled)
        {
            $sql .= " AND wvi.startdate > date_add( now( ) , {$this->_shortRunInterval} )";
        }
        
        $sql .= "; "; // LIMIT 50
        
        /* @var $visits object */
        $visits = $this->_runQuery($sql);

        return $visits;

    }


    /**
     * 
     * @global object $adb
     * @param string $sql
     * @return object
     */
    private function _runQuery($sql)
    {
        global $adb;

//        print "<li>$sql";

        $resupdate = $adb->pquery($sql);
        
        if ($resupdate === FALSE) 
        {
          print "- FALSE result from query! ".$sql."\n";
        }

        return $resupdate;
    }


    /**
     * get related visits from the webvisit
     * 
     * @global object $adb
     * @param integer $crmid
     * @return boolean
     */
    function _relatedWebVisits($crmid = 0)
    {
        global $adb;
        
        $wv_datefirstvisit = array();
        $wv_datelastvisit = array();

        $this->_wv_nofpages = 0;
        $this->_wv_score = 0;
        $this->_wv_searchterms = array();
        $this->_wv_allsources = array();      
        $this->_wv_sourcefirstvisit = array();
        $this->_wv_scoregroups = array();
        $this->_wv_datefirstvisit = NULL;
        $this->_wv_datelastvisit = NULL;

        /* @var $sql type */
//        $sql = "SELECT * FROM vtiger_webvisits WHERE {$this->_moduleIdField} = {$crmid};";
        //vtiger_crmentity.deleted=0;;

        $sql = "SELECT *
                FROM vtiger_webvisits AS wvi
                INNER JOIN vtiger_crmentity AS ce
                ON wvi.webvisitsid = ce.crmid
                WHERE ce.deleted=0
                AND wvi.{$this->_moduleIdField} = {$crmid} ;
                ";

 //       echo "<li>".__FUNCTION__." - $sql";

        $result2 = $this->_runQuery($sql, array());
        $rows2 = $adb->num_rows($result2);

        $this->_wv_nofvisits = $rows2;
      
        for($i = 0; $i<$rows2; $i++)
        {
            $aRecord = $adb->fetch_array($result2);

//echo "<li> -- ".$aRecord['wv_sfvisitid'];

            $this->_wv_score = $this->_wv_score + $aRecord['score'];

            $referrer_keywords = $this->_referrerKeywords($aRecord['referrer_keyword']);

            $referrer_names = $this->_referrerNames($aRecord['referrer_name']);

            $this->_wv_nofpages = $this->_wv_nofpages + $aRecord['nofpages'];

            $this->_addScoregroups($aRecord['wv_scoregroups']);

            $this->_wv_sourcefirstvisit[$i] = $aRecord['referrer_name'];

            $wv_datefirstvisit[$i] = substr($aRecord['startdate'], 0, 10);
            $wv_datelastvisit[$i] = substr($aRecord['enddate'], 0, 10);
        }

        $this->_wv_datefirstvisit = $this->_validDate(reset($wv_datefirstvisit));
        $this->_wv_datelastvisit = $this->_validDate(end($wv_datelastvisit));

        // @change lro 160203 1 point for each visited page
        // @todo configure #points per page
        $this->_wv_score = $this->_wv_score + $this->_wv_nofpages;

        $this->_storeData($crmid);      

        // if (!$resupdate) print_r( $adb );
        return true;
  }
  
  /**
   * Store the data
   * Uses a caching function
   * @param integer $crmid
   */
  private function _storeData($crmid)
  {
    global $adb;
  
    $data = $this->_setData();
    
    $sql = "UPDATE {$this->_moduleTableName} SET ".implode(', ', $data)." WHERE {$this->_moduleIdField} = {$crmid};";
    
    $md5 = md5($sql);
    
    // echo " -- this->cache($crmid.$md5) ";
    if ( $this->_cache[$crmid.$md5] == $crmid )
    {
        // skip, already updated
        echo "<li> -- skip, already updated";
    } else {
        //echo "<li>$sql";
        echo ".";
        try {
            $resupdate = $adb->pquery($sql);
            if ($resupdate === FALSE) 
            {
             print "- FALSE result from query! ".$sql."\n";
            }
            
        } catch (Exception $exc) {
            echo "<br>".__FUNCTION__." failure for $crmid <br> $sql <br> ".$exc->getTraceAsString();
        }

        $this->__cache[$crmid.$md5] = $crmid;
    }
  }
  
  /**
   * 
   * @param string $referrer_keyword
   */
  private function _referrerKeywords($referrer_keyword)
  {
    $referrer_keywords = explode(',', $referrer_keyword);
    
    foreach ($referrer_keywords as $key => $referrer_keyword)
    {  
        $referrer_keyword = trim($referrer_keyword);

        if (!empty($referrer_keyword) && !array_key_exists($referrer_keyword, $this->_wv_searchterms) )
        {
            $this->_wv_searchterms[$referrer_keyword] = $referrer_keyword;
        }
    }
  }

  /**
   * 
   * @param string $referrer_name
   */
  private function _referrerNames($referrer_name)
  {
    $referrer_names = explode(',', $referrer_name);
    
    foreach ($referrer_names as $key => $referrer_name) 
    {
        // @change lro 160213, T21151, added trim and if construction
        $referrer_name = trim($referrer_name);
        if (!empty($referrer_name) &&!array_key_exists($referrer_name, $this->_wv_allsources) ) 
        {
            $this->_wv_allsources[$referrer_name] = $referrer_name;
        }
    }
  }
    
  /**
   * 
   * @param string $newScoregroups
   */
  private function _addScoregroups($newScoregroups)
  {
    $score_groups = explode(' |##| ', $newScoregroups); // scoreGroupsTxt
    
    foreach ($score_groups as $key => $score_group) 
    {

      $score_group = trim($score_group);

      if (!empty($score_group) && !array_key_exists($score_group, $this->_wv_scoregroups) ) 
      {
        $this->_wv_scoregroups[$score_group] = trim($score_group);
      }

    }
  
    // @change lro 160222 sort by key (each record has same key order)
    asort($this->_wv_scoregroups);
  
  }
    
  /**
   * 
   * @return array
   */
  private function _setData()
  {

    $data = array(
      'wv_score' => $this->_wv_score,
      'wv_searchterms' => implode(', ', $this->_wv_searchterms),
      'wv_allsources' => implode(', ', $this->_wv_allsources),
      'wv_nofvisits' => $this->_wv_nofvisits,
      'wv_nofpages' => $this->_wv_nofpages,
      'wv_sourcefirstvisit' => reset($this->_wv_sourcefirstvisit),
      // 'wv_datefirstvisit' => reset($wv_datefirstvisit),
      // 'wv_lastvisitdate' => end($wv_datelastvisit),
      'wv_datefirstvisit' => $this->_validDate($this->_wv_datefirstvisit),
      'wv_lastvisitdate' => $this->_validDate($this->_wv_datelastvisit),
//      'startdate' => $this->_validDate($this->_wv_datefirstvisit),
//      'enddate' => $this->_validDate($this->_wv_datelastvisit)
    );
        
    // @change lro 160309 added campaigns
    // @change lro - oops forgot to do the | ## | thing
    if ($this->_module != 'campaign')
    {
      // $data['wv_scoregroups'] = implode(', ',$wv_scoregroups);
      $data['wv_scoregroups'] = implode(' |##| ', $this->_wv_scoregroups);

      // @change 
      // wva_lastvisitdate
      // wva_lastvisittime
      // wva_firstvisittime
      // wva_firstvisitdate
//      $data['wva_firstvisitdate'] = $this->_validDate(substr($data['wv_datefirstvisit'],0,10));
      //    $data['wva_firstvisittime'] = NULL; // substr($data['wv_datefirstvisit'],11,8);
      
//      $data['wva_lastvisitdate'] = $this->_validDate(substr($data['wv_lastvisitdate'],0,10));
      //    $data['wva_lastvisittime'] = NULL; // substr($data['wv_lastvisitdate'],11,8);
    } 
    else {
      unset($data['wv_scoregroups']);
      unset($data['wva_firstvisitdate']);
      unset($data['wva_lastvisitdate']);
    }
    
    $set = array();
    foreach ($data as $key => $values)
    {
      if ($values === NULL) 
      {
        $set[] = "{$key} = {$values}";
      } 
      else {
        $set[] = "{$key} = '{$values}'";
      }
    }
    
    return $set;
  }

  /**
   * ensure we have valid dat or nulL
   * @param string  $date   date to validate
   * @return string valid date string (or NULL)
   */
  private function _validDate($date)
  {
  
    $date = substr($date,0,10);
  
    // below should never occur, however if something is wrong in Webvisits module, we should prevent passing wrong values
    if ($date == '0000-00-00' || $date == '') 
    {
      echo ' 0000-00-00 found as date, set to NULL ';
      $date = NULL;
    }
    
    return $date;
  }

}

// ====================================================================== classes
// opnemen in Webvisits module !
class lockfile
{
  // @change lro 160225 added lock checking
  // to prevent running more than once
  //
  // if lock file for this module exists then die and wait for next rouond
  // will be locked at the end, but that fails if we run into an error
  // usually all filelocks will be freed if linux reboots
  // @change T20276 151119 lro added to path ../
  
  static function locked($file)
  {
    $lockfile = basename($file).".lock";
    
    $lockfp = fopen($lockfile, 'w') or die ('Cannot create lock file');
    
    if (!flock($lockfp, LOCK_EX | LOCK_NB))
    {
      // unlock if lock is old
      $d1 = filemtime($lockfile);
      $d2 = time();
      $mins = ($d2 - $d1) / 60;
      
      if ($mins > 60)
      {
        // ok to force unlock in case // should never happen
        echo "- Forced unlock {$lockfile} after {$mins} minutes";
        flock($lockfp, LOCK_UN);
        fclose($lockfp);
        die();
      } else {
        echo "- Processing halted - Actual Age of {$lockfile} = {$mins} minutes";
        die();
      }
    }
    return false;
  }

}
// end