<?php
/*********************************************************************************
** 
* Portions created by vtiger are Copyright (C) vtiger.
* Portions created by Vicus are Copyright (C) Vicus (www.vicus.nl).
* All Rights Reserved.
* @author	l.roovers <l.roovers@vicus.nl>
********************************************************************************/

chdir( dirname(__FILE__).'/../' );

require_once('config.php');
require_once('config_veb.php');
require_once('include/utils/utils.php');
ini_set('display_errors', 1);

$handler = new handler();
$handler->run();

class handler
{

    protected $debug = true;

    protected $schedule = array();
    protected $year;
    protected $month;
    protected $day;
    protected $week;
    protected $dayofweek;
    protected $quarter;
    protected $logfile;
    
    function __construct($mode = '')
    {
        global $dbconfig;

        $this->logfile = "logs/veb_datawarehouse_snapshot-".date('Y').".log";
    
        $this->year = date("Y"); // A full numeric representation of a year, 4 digits
        $this->month = date("m"); // Numeric representation of a month, with leading zeros
        $this->week = date("W"); // ISO-8601 week number of year, weeks starting on Monday (added in PHP 4.1.0)
        $this->dayofweek = date("w"); // Numeric representation of the day of the week, 0 = sunday
        $this->day = date("d"); // Day of the month, 2 digits with leading zeros
        
        if ($mode  == 'test') {
            $this->year = 2019;
            $this->month = '10';
            $this->day = 14;
            $this->week = '41';
            $this->dayofweek = 1;
        }

        $this->quarter=(INT)(($this->month-1)/3)+1;

//        $this->DwhDb_name = $dbconfig['db_name'];
        $this->DwhDb_name = 'cs1002_datawarehouse';
        $this->DwhDb_server = $dbconfig['db_server'];
        $this->DwhDb_username = $dbconfig['db_username'];
        $this->DwhDb_password = $dbconfig['db_password'];
        
        $this->MantisDb_name = 'cs1002_mantis';
        $this->MantisDb_server = '185.87.249.108';
        $this->MantisDb_username = 'cs1002_koolrprt';
        $this->MantisDb_password = 'o*mOm#*~LKyF';

        $this->log("Y=$this->year, Q=$this->quarter, M=$this->month, W=$this->week, D=$this->day, DoW=$this->dayofweek");
    }

    function run()
    {
        $this->createSchedule();
        
        if ( count($this->schedule) == 0 ) {
        	$this->log("Nothing scheduled for today");
        	die($msg);
        }
        
        foreach ($this->schedule as $id => $item)
        {
            $snapshot_frequency = $item['snapshot_frequency'];
            $period_label = $item['period_label'];
            $date = new DateTime();
            $date->add(DateInterval::createFromDateString('yesterday'));
            $date_lastdayperiod = $date->format('Y-m-d') . "\n";

            $this->log("Run schedul: snapshot_frequency=$snapshot_frequency, period_label=$period_label");
            // $table, $source, $entity, $snapshot_frequency, $period_label, $date_lastdayperiod, $unit_of_measure, 100, $score);
            // data compleet
            $score = $this->getDatacompletelynessFromVtiger('Accounts');
            $this->save('datacompletelyness', 'vtiger', 'Accounts', $snapshot_frequency, $period_label, $date_lastdayperiod, 'percentage', $score, 100);

            $score = $this->getDatacompletelynessFromVtiger('Leads');
            $this->save('datacompletelyness', 'vtiger', 'Leads', $snapshot_frequency, $period_label, $date_lastdayperiod, 'percentage', $score, 100);

            $score = $this->getDatacompletelynessFromVtiger('Contacts');
            $this->save('datacompletelyness', 'vtiger', 'Contacts', $snapshot_frequency, $period_label, $date_lastdayperiod, 'percentage', $score, 100);

            // aantal records
            $score = $this->getNumberOfRecordsFromVtiger('Accounts');
            $this->save('numberofrecords', 'vtiger', 'Accounts', $snapshot_frequency, $period_label, $date_lastdayperiod, 'records', $score);

            $score = $this->getNumberOfRecordsFromVtiger('Leads');
            $this->save('numberofrecords', 'vtiger', 'Leads', $snapshot_frequency, $period_label, $date_lastdayperiod, 'records', $score);

            $score = $this->getNumberOfRecordsFromVtiger('Contacts');
            $this->save('numberofrecords', 'vtiger', 'Contacts', $snapshot_frequency, $period_label, $date_lastdayperiod, 'records', $score);

            $score = $this->getNumberOfRecordsFromVtiger('Potentials');
            $this->save('numberofrecords', 'vtiger', 'Potentials', $snapshot_frequency, $period_label, $date_lastdayperiod, 'records', $score);

            // geboekte urem uit Mantis
            $booked = $this->getDatacompletelynessFromMantis('Timetracking', $snapshot_frequency);
            $available = $this->getDatacompletelynessFromMantis('Timeavailable', $snapshot_frequency);
            $this->save('datacompletelyness', 'mantis', 'Timetracking', $snapshot_frequency, $period_label, $date_lastdayperiod, 'hours', $booked, $available);

//            $this->save('datacompletelyness', 'mantis', 'MantisHoursAvailable', $snapshot_frequency, $period_label, $date_lastdayperiod, 'hours', $score, NULL);
        }
    }

    function getIsoWeeksInYear($year) {
        $date = new DateTime;
        $date->setISODate($year, 53);
        return ($date->format("W") === "53" ? 53 : 52);
    }

    function getDatacompletelynessFromMantis($entity, $snapshot_frequency)
    {
        $sql = '';
        
        // since we always run on forst of the periode, we need to get the data of the period before
        switch ($snapshot_frequency)
        {
            case 'weekly':
                if ($this->week == 1) {
                    $weeks = $this->getIsoWeeksInYear($this->year-1);
                    $where_week =  $weeks;
                    $where_year = $this->year-1;
                } else {
                    $where_week = $this->week -1;
                    $where_year = $this->year;
                }
                $where_periode_query = " AND ( WEEK(expenditure_date, 1) = $where_week AND YEAR(expenditure_date) = $where_year ) ";
                break;
                
            case 'monthly':
                if ($this->month == 1) {
                    $where_month = 12;
                    $where_year = $this->year-1;
                } else {
                    $where_month = $this->month -1;
                    $where_year = $this->year;
                }
                $where_periode_query = " AND ( MONTH(expenditure_date) = $where_month AND YEAR(expenditure_date) = $where_year ) ";
                break;
                
            case 'quarterly':
                if ($this->quarter == 1) {
                    $where_quarter = 4;
                    $where_year = $this->year-1;
                } else {
                    $where_quarter = $this->quarter -1;
                    $where_year = $this->year;
                }
                $where_periode_query = " AND ( QUARTER(expenditure_date) = $where_month AND YEAR(expenditure_date) = $where_year ) ";
                break;
                
            case 'yearly':
                $where_periode = $this->year -1;
                $where_periode_query = " AND ( YEAR(expenditure_date) = $where_year ) ";
                break;
                
            default:
                $where_periode_query = '';
        }

        switch (strtolower($entity))
        {
            // mantis_module_timetracking.user NOT IN (569, 560, 563, 592, 587)
            case 'timetracking':
                $sql = "
                    SELECT
                        SUM(hours) AS score
                    FROM 
                        mantis_module_timetracking
                    JOIN 
                        mantis_user_table
                    ON 
                        mantis_module_timetracking.user = mantis_user_table.id
                    JOIN 
                    	vicus_user_extra
                    ON
                    	mantis_user_table.username = vicus_user_extra.user
                    WHERE
                        vicus_user_extra.dienstverband IN ('loondienst', 'inhuur')
                        $where_periode_query;
                ";
                break;
            case 'timeavailable':
                $sql = "
                    SELECT
                        SUM(hour_per_week) AS score
                    FROM 
                        vicus_uren_per_week
                    JOIN 
                    	vicus_user_extra
                    ON
                    	vicus_uren_per_week.user = vicus_user_extra.user
                    WHERE
                        vicus_user_extra.dienstverband IN ('loondienst', 'inhuur');
                ";
                break;
            default:
                $this->log(__CLASS__.'::'.__FUNCTION__.' invalid entity '.$entity);
                return 0;
        }
        
        if ($sql) {
            $this->log(__CLASS__.'::'.__FUNCTION__.' query = '.$sql);
            $result = $this->queryMantis($sql);
            $return = $result['score'];
        } else {
            $return = 0;
        }
        
        return $return;
    }

    /**
     * we get the avg datacompletelyness from crm and put it later in the datawarehouse
     */
    function getDatacompletelynessFromVtiger($entity)
    {
        $sql = '';

        switch (strtolower($entity)) 
        {
            case 'accounts':
                $sql = "SELECT avg(cf_2447) AS score FROM vtiger_accountscf LEFT JOIN vtiger_crmentity ON vtiger_accountscf.accountid = vtiger_crmentity.crmid WHERE vtiger_crmentity.deleted = 0;";
                break;
            case 'contacts':
                $sql = "SELECT avg(cf_2445) AS score FROM vtiger_contactscf LEFT JOIN vtiger_crmentity ON vtiger_contactscf.contactid = vtiger_crmentity.crmid WHERE vtiger_crmentity.deleted = 0;";
                break;
            case 'leads':
                $sql = "SELECT avg(cf_2443) AS score FROM vtiger_leadscf LEFT JOIN vtiger_crmentity ON vtiger_leadscf.leadid = vtiger_crmentity.crmid LEFT JOIN vtiger_leaddetails ON vtiger_leaddetails.leadid = vtiger_crmentity.crmid WHERE vtiger_crmentity.deleted = 0 AND vtiger_leaddetails.converted = 0;";
                break;
            default:
                $this->log(__CLASS__.'::'.__FUNCTION__.' invalid entity '.$entity);
        }
        
        if ($sql) {
            $result = $this->queryVtiger($sql);
            $return = $result[0]['score'];
        } else {
            $return = 0;
        }
        
        return $return;
    }
    
    function getNumberOfRecordsFromVtiger($entity)
    {
        $sql = '';

        switch (strtolower($entity)) 
        {
            case 'accounts':
                $sql = "SELECT count(accountname) AS qty FROM vtiger_account LEFT JOIN vtiger_crmentity as ce ON vtiger_account.accountid = ce.crmid WHERE ce.deleted = 0;";
                break;
            case 'contacts':
                $sql = "SELECT count(firstname) AS qty FROM vtiger_contactdetails LEFT JOIN vtiger_crmentity as ce ON vtiger_contactdetails.contactid = ce.crmid WHERE ce.deleted = 0;";
                break;
            case 'leads':
                $sql = "SELECT count(lastname) AS qty FROM vtiger_leaddetails LEFT JOIN vtiger_crmentity as ce ON vtiger_leaddetails.leadid = ce.crmid WHERE ce.deleted = 0 AND vtiger_leaddetails.converted = 0;";
                break;
            case 'potentials':
                $sql = "SELECT count(potentialname) AS qty FROM vtiger_potential LEFT JOIN vtiger_crmentity as ce ON vtiger_potential.potentialid = ce.crmid WHERE ce.deleted = 0;";
                break;
            default:
                $this->log(__CLASS__.'::'.__FUNCTION__.' invalid entity '.$entity);
        }
        
        if ($sql) {
            $result = $this->queryVtiger($sql);
            $return = $result[0]['qty'];
        } else {
            $return = 0;
        }
        
        return $return;
    }
    

    function queryVtiger($sql)
    {
        global $adb;
        try {
            $result = $adb->pquery($sql, array());
            if ($result) {
                while ($row = $adb->fetch_array($result)) {
                    $return[] = $row;
                }
            } else {
                $return[] = array();
            }
        } catch (Exception $e) {
            $this->log(__CLASS__.'::'.__FUNCTION__.' Caught exception: '. $e->getMessage());
        }
        return $return;
    }
    
    // only prepared to get one single value from database
    function queryMantis($sql)
    {
        $this->connectMantisDb();

        if (!$result = mysqli_query($this->MantisDb, $sql)) 
        {
            $this->log("ERROR executing sql: $sql");
            die();
        }
        $this->log(__CLASS__.'::'.__FUNCTION__.' query '.$sql);
        if ($result->num_rows == 1) {
            $value = $result->fetch_array(MYSQLI_ASSOC);
        }
        
        mysqli_free_result($result);
        
        return $value;
        
    }

    function createSchedule() 
    {
        // calculate kind of run (might be more than one!)
        // weekly (monday)
        if ($this->dayofweek == 1) {
        	$this->addToSchedule('weekly', $this->year.$this->week);
        }
        // monthly
        if ($this->day == 1) {
        	$this->addToSchedule('monthly', $this->year.$this->month);
        }
        // quarterly
        if ($this->day == 1 AND ( in_array ($this->month,array(1,4,7,10)) )) {
        	$this->addToSchedule('quarterly', $this->year.'Q'.$this->quarter);
        }
        // yearly
        if ($this->day == 1 AND ( $this->month == 1 )) {
        	$this->addToSchedule('yearly', $this->year);
        } 
    }
    
    function addToSchedule($snapshot_frequency, $period_label)
    {
        	$this->schedule[] = array(
        		'snapshot_frequency' => $snapshot_frequency,
        		'period_label' => $period_label
        	);
    }
    
    /**
     * Save to the Wharehouse database
     */
    function save($table, $source, $entity, $snapshot_frequency, $period_label, $date_lastdayperiod, $unit_of_measure, $value_actual, $value_target = NULL)
    {
        $this->connectWhwDb();

        if ($table == 'datacompletelyness') {
            $sql = "INSERT INTO `$table` (`source`, `entity`, `snapshot_frequency`, `period_label`, `date_lastdayperiod`, `unit_of_measure`, `value_target`, `value_actual`)
                    VALUES ('$source', '$entity', '$snapshot_frequency', '$period_label', '$date_lastdayperiod', '$unit_of_measure', '$value_target', '$value_actual');";
        }
        elseif ($table == 'numberofrecords') {
            $sql = "INSERT INTO `$table` (`source`, `entity`, `snapshot_frequency`, `period_label`, `date_lastdayperiod`, `value_actual`)
                    VALUES ('$source', '$entity', '$snapshot_frequency', '$period_label', '$date_lastdayperiod', '$value_actual');";
        }

        if (!mysqli_query($this->DwhDb, $sql)) 
        {
            $this->log("ERROR executing sql: $sql");
            die();
        }
    }

    function connectWhwDb()
    {
        if ($this->DwhDb) {
            return $this->DwhDb;
        } else {
            $this->DwhDb = mysqli_connect($this->DwhDb_server, $this->DwhDb_username, $this->DwhDb_password, $this->DwhDb_name);
            if (mysqli_connect_errno()) {
            	$this->log("Failed to connect to DataWharehouse MySQL: " . mysqli_connect_error());
            	die();
            }
        }
    }

    function connectMantisDb()
    {
        if ($this->MantisDb) {
            return $this->MantisDb;
        } else {
            $this->MantisDb = mysqli_connect($this->MantisDb_server, $this->MantisDb_username, $this->MantisDb_password, $this->MantisDb_name);
            if (mysqli_connect_errno()) {
            	$this->log("Failed to connect to Mantis MySQL: " . mysqli_connect_error());
            	die();
            }
        }
    }


    function log($msg) {
        file_put_contents($this->logfile,date("Y-m-d H:m:i").' '.$msg."\n", FILE_APPEND);
        if ($this->debug) { print '<li>'.$msg; }
    }

}