<?php

/**
 * Lead essentie (verdelen over 100 punten)
 * Data quality says nothing about lead probability !
 * But better data gives more opportunities
 */
chdir(dirname(__FILE__) . '/../');
// echo getcwd()."\n";

$logfile = "logs/veb_datacompletelyness-" . date('Y') . ".log";

require_once('config.php');
require_once('config_veb.php');
require_once('include/utils/utils.php');

$debug = false; // prints results when set to true

$leads = array();
$contacts = array();
$accounts = array();

// get all leads
$leads = getLeads();
$rules = getLeadsRules();

foreach ($leads as $lid => $lead)
{
    $score = 0;
    $maxpoints = 0;
    $leadid = $lead['leadid'];

    foreach ($rules as $rid => $rule)
    {
        $field = $rule['field'];
        $maxpoints += ($rule['points'] > 0) ? $rule['points'] : 0;
        $score = $score + calculateFieldScore($lead, $field, $rule);
    }

    // score must be >= 0 AND <= 100
    if ($score < 0)
    {
        $ratio = 0;
    } else
    {
        $ratio = round($score / $maxpoints * 100, 0);
    }

    // update leadscore in lead
    if ($debug)
        print "<li> ratio=$ratio, score=$score, maxpoints=$maxpoints - leadid=$leadid";
    updateLead($leadid, $ratio);
}


// get all Contacts
$contacts = getContacts();
$rules = getContactsRules();

foreach ($contacts as $cid => $contact)
{
    global $debug;

    $score = 0;
    $maxpoints = 0;
    $contactid = $contact['contactid'];

    foreach ($rules as $rid => $rule)
    {
        $field = $rule['field'];
        $maxpoints += ($rule['points'] > 0) ? $rule['points'] : 0;
        $score = $score + calculateFieldScore($contact, $field, $rule);
    }

    // score must be >= 0 AND <= 100
    if ($score < 0)
    {
        $ratio = 0;
    } else
    {
        $ratio = round($score / $maxpoints * 100, 0);
    }

    // update leadscore in lead
    if ($debug)
        print "<li> ratio=$ratio, score=$score, maxpoints=$maxpoints - contactid=$contactid";
    updateContact($contactid, $ratio);
}

// get all Accounts
$accounts = getAccounts();
$rules = getAccountsRules();

foreach ($accounts as $cid => $account)
{
    global $debug;

    $score = 0;
    $maxpoints = 0;
    $accountid = $account['accountid'];

    foreach ($rules as $rid => $rule)
    {
        $field = $rule['field'];
        $maxpoints += ($rule['points'] > 0) ? $rule['points'] : 0;
        $score = $score + calculateFieldScore($account, $field, $rule);
    }

    // score must be >= 0 AND <= 100
    if ($score < 0)
    {
        $ratio = 0;
    } else
    {
        $ratio = round($score / $maxpoints * 100, 0);
    }

    // update leadscore in lead
    if ($debug)
        print "<li> ratio=$ratio, score=$score, maxpoints=$maxpoints - accountid=$accountid";
        
    updateAccount($accountid, $ratio);
}

/**
 * Calulate the score for a single field.
 */
function calculateFieldScore($entity, $field, $rule)
{
    global $debug;

    if ($debug)
        print "<li> calculate: $field = {$rule['test']}";
    $score = 0;

    // if field is in the lead then handle
    if (isset($entity[$field]))
    {
        $fieldvalue = $entity[$field];

        $test = $rule['test'];
        $compare = $rule['compare'];
        $points = $rule['points'];

        switch ($test)
        {
            case 'notempty':
                if ($fieldvalue != '')
                {
                    $score = $score + $points;
                    if ($debug)
                        print "<li> $field = $fieldvalue | notempty points: $points";
                } else
                {
                    if ($debug)
                        print "<li> Vul $field in voor $points extra kwaliteitspunten";
                }
                break;

            case 'value':
                if ($compare == $fieldvalue)
                {
                    $score = $score + $points;
                    if ($debug)
                        print "<li> $field = $fieldvalue = $compare | value points: $points";
                } else
                {
                    if ($debug)
                        print "<li> Vul $field in voor $points extra kwaliteitspunten";
                }
                break;

            case 'notvalue':
                if ($compare != $fieldvalue)
                {
                    $score = $score + $points;
                    if ($debug)
                        print "<li> $field = $fieldvalue = $compare | value points: $points";
                } else
                {
                    if ($debug)
                        print "<li> Vul $field in voor $points extra kwaliteitspunten";
                }
                break;

            case 'contains':
                if (stripos($fieldvalue, $compare) !== FALSE)
                {
                    $score = $score + $points;
                    if ($debug)
                        print "<li> $field = $fieldvalue = $compare | value points: $points";
                } else
                {
                    if ($debug)
                        print "<li> Vul $field in voor $points extra kwaliteitspunten";
                }
                break;

            case 'notcontains':
                if (stripos($fieldvalue, $compare) === FALSE)
                {
                    $score = $score + $points;
                    if ($debug)
                        print "<li> $field | expected = $compare | value points: $points";
                } else
                {
                    if ($debug)
                        print "<li> Vul $field in voor $points extra kwaliteitspunten";
                }
                break;

            default:
                if ($debug)
                    print "<li> Vul $field in voor $points extra kwaliteitspunten";
            //
        }
    }

    return $score;
}

/** #########################################################################
 *      LEADS
 */
function getLeads()
{
    global $adb;

    $sql = "
		SELECT * 
		FROM 
		    vtiger_leaddetails as ld 
		LEFT JOIN 
		    vtiger_leadscf as ldcf
		ON 
		    ld.leadid = ldcf.leadid
		LEFT JOIN
		    vtiger_leadaddress
		ON 
		    ld.leadid = vtiger_leadaddress.leadaddressid
		LEFT JOIN 
		    vtiger_crmentity as ce
		ON
			ld.leadid = ce.crmid
		WHERE 
			ce.deleted = 0
			AND converted = 0
		";

    $result = $adb->pquery($sql, array());

    return $result;
}

function updateLead($crmid, $ratio)
{
    global $adb;
    global $leadDataCompletelynessField;

    $sql = "
        UPDATE
            vtiger_leadscf
        SET 
            $leadDataCompletelynessField = $ratio
        WHERE 
            leadid = $crmid;
    ";
    $result = $adb->pquery($sql, array());

    return $result;
}

/** #########################################################################
 *      CONTACTS
 */
function getContacts()
{
    global $adb;

    $sql = "
        SELECT * 
        FROM 
            vtiger_contactdetails as cd
        LEFT JOIN 
            vtiger_contactscf as cdcf
        ON 
            cd.contactid = cdcf.contactid
        LEFT JOIN 
            vtiger_crmentity as ce
        ON
                cd.contactid = ce.crmid
        WHERE 
                ce.deleted = 0
        ";

    $result = $adb->pquery($sql, array());

    return $result;
}

function updateContact($crmid, $ratio)
{
    global $adb;
    global $contactDataCompletelynessField;

    $sql = "
        UPDATE
            vtiger_contactscf
        SET 
            $contactDataCompletelynessField = $ratio
        WHERE 
            contactid = $crmid;
        ";

    $result = $adb->pquery($sql, array());
    return $result;
}

/** #########################################################################
 *      ACCOUNTS
 */
function getAccounts()
{
    global $adb;

    $sql = "
		SELECT * 
		FROM 
		    vtiger_account as ad 
		LEFT JOIN 
		    vtiger_accountscf as adcf
		ON 
		    ad.accountid = adcf.accountid
		LEFT JOIN
		    vtiger_accountshipads
		ON 
		    ad.accountid = vtiger_accountshipads.accountaddressid
		LEFT JOIN 
		    vtiger_crmentity as ce
		ON
			ad.accountid = ce.crmid
		WHERE 
			ce.deleted = 0
		";

    $result = $adb->pquery($sql, array());

    return $result;
}

function updateAccount($crmid, $ratio)
{
    global $adb;
    global $accountDataCompletelynessField;

    $sql = "
        UPDATE
            vtiger_accountscf
        SET 
            $accountDataCompletelynessField = $ratio
        WHERE 
            accountid = $crmid;
    ";
    $result = $adb->pquery($sql, array());

    return $result;
}

/** ======================== set the rules here
 * auto calculated the score of x%
 */
function getLeadsRules()
{
    return array(
        // person 
        'salutation_not_emtpy' => array('field' => 'salutation', 'test' => 'notempty', 'points' => 10),
        'preamble_not_emtpy' => array('field' => 'c_lead_preamble', 'test' => 'notempty', 'points' => 10),
        'firstname_not_emtpy' => array('field' => 'firstname', 'test' => 'notempty', 'points' => 10),
        'lastname_not_emtpy' => array('field' => 'lastname', 'test' => 'notempty', 'points' => 20),
        'lastname_not_directie' => array('field' => 'lastname', 'test' => 'contains', 'compare' => 'irectie van', 'points' => -10),
        'email_not_emtpy' => array('field' => 'email', 'test' => 'notempty', 'points' => 20),
        'phone_not_emtpy' => array('field' => 'phone', 'test' => 'notempty', 'points' => 10),
        'mobile_not_emtpy' => array('field' => 'mobile', 'test' => 'notempty', 'points' => 5),
        //    'linkedincontact_not_emtpy' => array('field' => 'c_linkedin_contact', 'test' => 'notempty', 'points' => 5),
        'linkedincontact_url' => array('field' => 'c_linkedin_contact', 'test' => 'contains', 'compare' => 'linkedin.com', 'points' => 5),
        'function_not_emtpy' => array('field' => 'cf_2271', 'test' => 'notempty', 'points' => 5),
        // company
        'company_not_emtpy' => array('field' => 'company', 'test' => 'notempty', 'points' => 10),
        'salesregion_not_emtpy' => array('field' => 'c_salesregion', 'test' => 'notempty', 'points' => 10),
        //    'linkedincompany_not_emtpy' => array('field' => 'c_linkedin_account', 'test' => 'notempty', 'points' => 5),
        'linkedincompany_url' => array('field' => 'c_linkedin_account', 'test' => 'contains', 'compare' => 'linkedin.com', 'points' => 5),
        //    'sbicodes_not_emtpy' => array('field' => 'c_sbi_codes', 'test' => 'notempty', 'points' => 5),
        'c_coc_number_not_emtpy' => array('field' => 'c_coc_number', 'test' => 'notempty', 'points' => 20),
        'vicusbranche_not_emtpy' => array('field' => 'cf_2253', 'test' => 'notempty', 'points' => 5),
        //    'c_is_insolvent_not_empty' => array('field' => 'c_is_insolvent', 'test' => 'notempty', 'points' => 10),
        //    'c_is_insolvent_not_set' => array('field' => 'c_is_insolvent', 'test' => 'value', 'compare' => 'Onbekend', 'points' => -10),
        // Interesse oplossingen / products
        'solutions_not_emtpy' => array('field' => 'c_lead_solutions', 'test' => 'notempty', 'points' => 5),
        'products_not_emtpy' => array('field' => 'c_lead_products', 'test' => 'notempty', 'points' => 10),
        // Huidige infra
        'crmsw_not_emtpy' => array('field' => 'c_current_crm_sw', 'test' => 'notempty', 'points' => 5),
        'shopsw_not_emtpy' => array('field' => 'c_current_shop_sw', 'test' => 'notempty', 'points' => 5),
        // proces
        'leadstatus_not_emtpy' => array('field' => 'leadstatus', 'test' => 'notempty', 'points' => 10),
        'leadsource_not_emtpy' => array('field' => 'c_lead_source', 'test' => 'notempty', 'points' => 10),
    );
}

function getContactsRules()
{
    return array(
        // person 
        'salutation_not_emtpy' => array('field' => 'salutation', 'test' => 'notempty', 'points' => 10),
        'preamble_not_emtpy' => array('field' => 'c_contact_preamble', 'test' => 'notempty', 'points' => 10),
        'firstname_not_emtpy' => array('field' => 'firstname', 'test' => 'notempty', 'points' => 10),
        'lastname_not_emtpy' => array('field' => 'lastname', 'test' => 'notempty', 'points' => 20),
        'lastname_not_directie' => array('field' => 'lastname', 'test' => 'contains', 'compare' => 'irectie van', 'points' => -10),
        'email_not_emtpy' => array('field' => 'email', 'test' => 'notempty', 'points' => 20),
        'phone_not_emtpy' => array('field' => 'phone', 'test' => 'notempty', 'points' => 10),
        'mobile_not_emtpy' => array('field' => 'mobile', 'test' => 'notempty', 'points' => 5),
        //    'linkedincontact_not_emtpy' => array('field' => 'c_linkedin_contact', 'test' => 'notempty', 'points' => 5),
        'linkedincontact_url' => array('field' => 'c_linkedin_contact', 'test' => 'contains', 'compare' => 'linkedin.com', 'points' => 5),
        'function_not_emtpy' => array('field' => 'cf_2087', 'test' => 'notempty', 'points' => 5),
        // company
        'company_not_emtpy' => array('field' => 'accountid', 'test' => 'notvalue', 'compare' => 0, 'points' => 10),
    );
}

function getAccountsRules()
{
    return array(
        // core info
        'accountname_not_emtpy' => array('field' => 'accountname', 'test' => 'notempty', 'points' => 10),
        'account_type_not_emtpy' => array('field' => 'cf_1759', 'test' => 'notempty', 'points' => 10),
        'c_coc_number_not_emtpy' => array('field' => 'c_coc_number', 'test' => 'notempty', 'points' => 20),
        // Huidige infra
        'crmsw_not_emtpy' => array('field' => 'c_current_crm_sw', 'test' => 'notempty', 'points' => 5),
        'shopsw_not_emtpy' => array('field' => 'c_current_shop_sw', 'test' => 'notempty', 'points' => 5),
        'cms_not_emtpy' => array('field' => 'c_current_cms_sw', 'test' => 'notempty', 'points' => 5),
        'erp_not_emtpy' => array('field' => 'c_current_erp_sw', 'test' => 'notempty', 'points' => 5),
        // Contact data
        'phone_not_emtpy' => array('field' => 'phone', 'test' => 'notempty', 'points' => 10),
        'website_not_emtpy' => array('field' => 'website', 'test' => 'notempty', 'points' => 10),
        'linkedincompany_url' => array('field' => 'c_linkedin_account', 'test' => 'contains', 'compare' => 'linkedin.com', 'points' => 5),
        // Geografisch
        'ship_city_not_emtpy' => array('field' => 'ship_city', 'test' => 'notempty', 'points' => 10),
        'ship_country_not_emtpy' => array('field' => 'ship_country', 'test' => 'notempty', 'points' => 10),
        // Demografisch
        'vicusbranche_not_empty' => array('field' => 'cf_1757', 'test' => 'notempty', 'points' => 5),
        'employee_not_empty' => array('field' => 'c_total_employees', 'test' => 'notempty', 'points' => 5),
    );
}
