<?php

// https://discussions.vtiger.com/index.php?p=/discussion/168411/birth-date-wish-in-crm/p1

chdir(dirname(__FILE__) . '/../');

require_once('config.php');
require_once('include/utils/utils.php');
// require_once('include/language/nl_nl.lang.php');

global $adb;
global $site_URL;
global $current_user;
require_once('includes/Loader.php');
require_once('modules/Emails/mail.php'); // nodig om mail te sturen, aanlaten dus!
// require_once('modules/Contacts/Contacts.php');
// require_once('modules/Vtiger/models/Module.php');

$sql = $adb->pquery("
SELECT 
  contactsubscriptionid, cf_1724
FROM 
  vtiger_contactsubdetails 
INNER JOIN 
  vtiger_crmentity
ON 
  vtiger_contactsubdetails.contactsubscriptionid=vtiger_crmentity.crmid 
INNER JOIN
  vtiger_contactscf
  ON 
  vtiger_contactsubdetails.contactsubscriptionid=vtiger_contactscf.contactid 
WHERE  
  DAYOFYEAR(curdate()) = dayofyear(vtiger_contactsubdetails.birthday)
  AND cf_1724 = 0
  AND vtiger_crmentity.deleted=0", array()
);
//   AND c_picklist_contact_preferences NOT LIKE '%Geen verjaardagskaart%'
//   AND DAYOFYEAR(curdate()) <= dayofyear(vtiger_contactsubdetails.birthday) 

if ($adb->num_rows($sql) > 0) {

    $assign_array = array();

    while ($fetch = $adb->fetch_array($sql)) {

        $contactid = $fetch["contactsubscriptionid"];
        $focus = CRMEntity::getInstance('Contacts');
        $focus->retrieve_entity_info($contactid, 'Contacts');
        $col_flds = $focus->column_fields;
        $salutationtype = $col_flds["salutationtype"];
        $firstname = $col_flds["firstname"];
        $lastname = $col_flds["lastname"];
        $birthday = $col_flds["birthday"];
//	$blocksendcard = $col_flds["cf_1312"];
        $blocksendcard = $col_flds["c_picklist_contact_preferences"];
//	$function = $col_flds["cf_565"];
        $function = $col_flds["c_occupation"];
        $assignto_id = $col_flds["assigned_user_id"];
        $contactname = $firstname . " " . $lastname;
        $sql1 = $adb->pquery("SELECT first_name,last_name,email1 FROM vtiger_users WHERE id=?", array($assignto_id));

        if ($adb->num_rows($sql1) > 0) {

            $result = $adb->fetch_array($sql1);
            $assign_fname = $result["first_name"];
            $assign_lname = $result["last_name"];
            $assign_email = $result["email1"];
            $assign_birthday = $result["birthday"];
            $contact_details[] = array(
                "ASSIGNID" => $assignto_id,
                "ASSIGNNAME" => $assign_fname,
                "ASSIGNEMAIL" => $assign_email,
                "CONTACTID" => $contactid,
                "CONTACTNAME" => $contactname,
                "BIRTHDAY" => $birthday,
                "FUNCTION" => $function,
                "BLOCKSENDCARD" => $blocksendcard,
                "ALLDATA" => $col_flds);
            array_push($assign_array, $assignto_id);
        }
    }
}

if (count($assign_array) > 0) {

    $assign_array = array_values(array_filter(array_unique($assign_array)));

    for ($i = 0; $i < count($assign_array); $i++) {

        $assingtoid = $assign_array[$i];
        $sql1 = $adb->pquery("SELECT first_name,last_name,email1 FROM vtiger_users WHERE id=?", array($assingtoid));
        $result = $adb->fetch_array($sql1);
        $firstname = $result["first_name"];
        //	$email=$result["email1"];
        $email = "lro@vicus.nl"; // during test only to me sales

        $html_str = _vebtr('Hallo') . ' ' . $firstname . ",<br />";
        $html_str .= _vebtr('De volgende mensen zijn jarig') . "<br />";
        $html = '<ul>';
        for ($j = 0; $j < count($contact_details); $j++)
        {
            if ($assingtoid == $contact_details[$j]["ASSIGNID"])
            {

                $contactname = $contact_details[$j]["CONTACTNAME"];
                $birthday = $contact_details[$j]["BIRTHDAY"];
                $contactid = $contact_details[$j]["CONTACTID"];
                $function = $contact_details[$j]["FUNCTION"];
                $blocksendcard = $contact_details[$j]["BLOCKSENDCARD"];
                //			$html .="<li>"._vebtr('Contact name')." - <i><b>".$contactname.'</b></i> '.$function.' - ('.$birthday.') -  <a href="'.$site_URL.'/index.php?module=Contacts&parenttab=Marketing&action=DetailView&record='.$contactid.'" target="_blank">CRM Link</a>';
                $html .= "<li>" . _vebtr('Contact name') . " - <i><b>" . $contactname . '</b></i> ' . $function . ' - (' . $birthday . ') -  <a href="' . $site_URL . '/index.php?module=Contacts&view=Detail&record=' . $contactid . '" target="_blank">CRM Link</a>';
                $html .= " " . $blocksendcard;
                $html .= ($blocksendcard == 'Geen verjaardagskaart' ) ? " -- Stuur geen kaart!" : "";
                $html .= "</li>";
//      	$html_str .= print_r($contact_details[$j]["ALLDATA"])."<hr>";
            }
        }



        $html .= '</ul>';
        $html_str .= $html . "<br /><br />";
        $html_str .= _vebtr('Regards') . ",<br />";
        $html_str .= "CRM";

        echo $html_str."<br />";
//        $mail_status = mail('Users', $email, $HELPDESK_SUPPORT_NAME, $HELPDESK_SUPPORT_EMAIL_REPLY_ID, _vebtr('Upcoming Birthday'), $html_str);
        $mail_status = send_mail('Users', $email, $HELPDESK_SUPPORT_NAME, $HELPDESK_SUPPORT_EMAIL_REPLY_ID, _vebtr('Upcoming Birthday'), $html_str);
    }
    echo 'SUCCESS';
} else
{
    echo _vebtr("No upcoming birthday found!");
}

function _vebtr($string)
{
    if (isset($app_strings[$string]))
        return $app_strings[$string];
    else
        return $string;
}

?>
