<?PHP
/*VICUS - START SCRIPT TO */
//ini_set("include_path", "../");
set_time_limit(0);

// echo getcwd()."\n";
chdir( dirname(__FILE__).'/../' );
// echo getcwd()."\n";

require_once('config.php');
require_once('include/utils/utils.php');

/**
 * Do the Leads
 *
 */
$strSql 	= "SELECT 
	leadaddressid, code, state, country
FROM 
	vtiger_leadaddress
WHERE
	code != ''
;
";

$result 	= $adb->pquery($strSql, array());
$numrows 	= $adb->num_rows($result);

for($i=1;$i<=$numrows;$i++)
{
	$aResult = $adb->fetch_array($result);

	if ( $aResult['code'] > 0 ) 
	{
		$state = WichStateFromPC( $aResult['code'],$aResult['country']);
		$leadaddressid = $aResult['leadaddressid'];
// var_dump(mb_detect_encoding($aResult['country']));
		$country = StandardizeCountry($aResult['country'], $leadaddressid);
// var_dump(mb_detect_encoding($country));

		// region is first two digits of postcode
//		$region = substr($aResult['code'],0,2);
		$region = getPoCoRegion($aResult['code']);
	
		// $update_query = "UPDATE vtiger_leadaddress SET state = '".$state."', country = '".$country."' WHERE leadaddressid = $leadaddressid;";
		$update_query = "UPDATE vtiger_leadaddress SET state = ?, country = ? WHERE leadaddressid = ?";
		$params = array($state, $country, $leadaddressid);
		// echo "\n".$update_query;
		$adb->pquery($update_query, $params);

		$update_query = "UPDATE vtiger_leaddetails SET c_salesregion = '".$region."' WHERE leadid = $leadaddressid;";
//		echo "\n".$update_query;
		$adb->pquery($update_query, array());

	}
}

/**
 * Do the Accounts Shipping
 *
 */
$strSql 	= "SELECT 
	accountaddressid, ship_code, ship_country, ship_state
FROM 
	vtiger_accountshipads
WHERE
	ship_code != ''
;
";

$result 	= $adb->pquery($strSql, array());
$numrows 	= $adb->num_rows($result);

for($i=1;$i<=$numrows;$i++)
{
	$aResult = $adb->fetch_array($result);

	if ( $aResult['ship_code'] > 0 ) 
	{
		$state = WichStateFromPC( $aResult['ship_code'],$aResult['ship_country']);
		$accountaddressid = $aResult['accountaddressid'];
		$country = StandardizeCountry($aResult['ship_country'], $accountaddressid);
	
		$region = getPoCoRegion($aResult['ship_code']);
	
		$update_query = "UPDATE vtiger_accountshipads SET ship_state = '".$state."', ship_country = '".$country."' WHERE accountaddressid = $accountaddressid;";
//		echo "\n".$update_query;
		$adb->pquery($update_query, array());
		
		$update_query = "UPDATE vtiger_accountscf SET cf_1473 = '".$region."' WHERE accountid = $accountaddressid;";
//		echo "\n".$update_query;
		$adb->pquery($update_query, array());
		
	}
}

/**
 * Do the Accounts Billing
 *
 */
$strSql 	= "SELECT 
	accountaddressid, bill_code, bill_country, bill_state
FROM 
	vtiger_accountbillads
WHERE
	bill_code != ''
;
";

$result 	= $adb->pquery($strSql, array());
$numrows 	= $adb->num_rows($result);

for($i=1;$i<=$numrows;$i++)
{
	$aResult = $adb->fetch_array($result);

	if ( $aResult['bill_code'] > 0 ) 
	{
		$state = WichStateFromPC( $aResult['bill_code'],$aResult['bill_country']);
		$accountaddressid = $aResult['accountaddressid'];
		$country = StandardizeCountry($aResult['bill_country'], $accountaddressid);
	
		$update_query = "UPDATE vtiger_accountbillads SET bill_state = '".$state."', bill_country = '".$country."' WHERE accountaddressid = $accountaddressid;";
//		echo "\n".$update_query;
		$adb->pquery($update_query, array());
	}
}


function WichStateFromPC($postcode,$country="Nederland")
{
	$state = ''; $region = '';
	if ($country = "Nederland")
	{
		$postcode = substr($postcode,0,4);
		$postcode = (int)$postcode;

		// source WikiPedia
		if ( $postcode >= 1000 AND $postcode <= 1299 ) { $state = 'Noord Holland';	$region = ''; }
		if ( $postcode >= 1300 AND $postcode <= 1379 ) { $state = 'Flevoland';		$region = ''; }
		if ( $postcode >= 1380 AND $postcode <= 1383 ) { $state = 'Noord Holland';	$region = ''; }
		if ( $postcode >= 1390 AND $postcode <= 1393 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 1394 AND $postcode <= 1394 ) { $state = 'Noord Holland';	$region = ''; }
		if ( $postcode >= 1396 AND $postcode <= 1396 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 1398 AND $postcode <= 1425 ) { $state = 'Noord Holland';	$region = ''; }
		if ( $postcode >= 1426 AND $postcode <= 1427 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 1428 AND $postcode <= 1429 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 1430 AND $postcode <= 2158 ) { $state = 'Noord Holland';	$region = ''; }
		if ( $postcode >= 2159 AND $postcode <= 3381 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 3382 AND $postcode <= 3464 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 3465 AND $postcode <= 3466 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 3467 AND $postcode <= 3769 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 3770 AND $postcode <= 3794 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 3795 AND $postcode <= 3836 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 3837 AND $postcode <= 3888 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 3890 AND $postcode <= 3899 ) { $state = 'Flevoland';		$region = ''; }
		if ( $postcode >= 3900 AND $postcode <= 3999 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 4000 AND $postcode <= 4119 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 4120 AND $postcode <= 4125 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 4126 AND $postcode <= 4129 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4130 AND $postcode <= 4139 ) { $state = 'Utrecht';		$region = ''; }
		if ( $postcode >= 4140 AND $postcode <= 4146 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4147 AND $postcode <= 4162 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 4163 AND $postcode <= 4169 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4170 AND $postcode <= 4199 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 4200 AND $postcode <= 4209 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4211 AND $postcode <= 4212 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 4213 AND $postcode <= 4213 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4214 AND $postcode <= 4219 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 4220 AND $postcode <= 4249 ) { $state = 'Zuid Holland';	$region = ''; }
		if ( $postcode >= 4250 AND $postcode <= 4299 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 4300 AND $postcode <= 4599 ) { $state = 'Zeeland';		$region = ''; }
		if ( $postcode >= 4600 AND $postcode <= 4671 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 4672 AND $postcode <= 4679 ) { $state = 'Zeeland';		$region = ''; }
		if ( $postcode >= 4680 AND $postcode <= 4681 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 4682 AND $postcode <= 4699 ) { $state = 'Zeeland';		$region = ''; }
		if ( $postcode >= 4700 AND $postcode <= 5299 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 5300 AND $postcode <= 5335 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 5340 AND $postcode <= 5765 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 5766 AND $postcode <= 5817 ) { $state = 'Limburg';		$region = ''; }
		if ( $postcode >= 5820 AND $postcode <= 5846 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 5850 AND $postcode <= 6019 ) { $state = 'Limburg';		$region = ''; }
		if ( $postcode >= 6020 AND $postcode <= 6029 ) { $state = 'Noord Brabant';	$region = ''; }
		if ( $postcode >= 6030 AND $postcode <= 6499 ) { $state = 'Limburg';		$region = ''; }
		if ( $postcode >= 6500 AND $postcode <= 6584 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 6584 AND $postcode <= 6599 ) { $state = 'Limburg';		$region = ''; }
		if ( $postcode >= 6600 AND $postcode <= 7399 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 7400 AND $postcode <= 7739 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 7740 AND $postcode <= 7766 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 7767 AND $postcode <= 7799 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 7800 AND $postcode <= 7949 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 7950 AND $postcode <= 7955 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 7956 AND $postcode <= 7999 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 8000 AND $postcode <= 8049 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8050 AND $postcode <= 8054 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 8055 AND $postcode <= 8069 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8070 AND $postcode <= 8099 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 8100 AND $postcode <= 8159 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8160 AND $postcode <= 8195 ) { $state = 'Gelderland';		$region = ''; }
		if ( $postcode >= 8196 AND $postcode <= 8199 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8200 AND $postcode <= 8259 ) { $state = 'Flevoland';		$region = ''; }
		if ( $postcode >= 8260 AND $postcode <= 8299 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8300 AND $postcode <= 8322 ) { $state = 'Flevoland';		$region = ''; }
		if ( $postcode >= 8323 AND $postcode <= 8349 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8350 AND $postcode <= 8354 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 8355 AND $postcode <= 8379 ) { $state = 'Overijssel';		$region = ''; }
		if ( $postcode >= 8380 AND $postcode <= 8387 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 8388 AND $postcode <= 9299 ) { $state = 'Friesland';		$region = ''; }
		if ( $postcode >= 9300 AND $postcode <= 9349 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 9350 AND $postcode <= 9399 ) { $state = 'Groningen';		$region = ''; }
		if ( $postcode >= 9400 AND $postcode <= 9499 ) { $state = 'Drenthe';		$region = ''; }
		if ( $postcode >= 9500 AND $postcode <= 9999 ) { $state = 'Groningen';		$region = ''; } // @change lro 110529 added
	}
	return $state;
}

function StandardizeCountry($country, $adresid)
{
	$country = strtolower($country);
	$country = trim($country);
//	$country = str_replace(';amp;amp;amp;', '', $country);

	$replaced = true;
	
//	while (	$replaced = true ) {
//	  $countryOld = $country;
  	$country = str_replace('&ampampampamp;', '&amp;', $country);
  	$country = str_replace('&ampampamp;', '&amp;', $country);
  	$country = str_replace('&ampamp;', '&amp;', $country);
  	$country = str_replace(';amp;amp;', '', $country);
//  	if ($countryOld = $country) $replaced = false;
//  }

	// echo $country . ':' . bin2hex($country) . "\n";

	if (!$country) return $country;
	
	switch($country)
	{
		case "be":
		case "belgie":
		case "belgi":
		case "belgi":
		case "belgium":
		case "belgi&euml;":
		case "belgi&amp;euml;":
		case "belgi&eacute;":
		// @change t48135
		case 'belgi?':
		//
				$country = "Belgi"; break;
				
		case "bosni":
		case "bosnie&uml;":
		case "bosni":
		case "bosnia and herzegovina":
		case "bosnia and herzegov":
		case "bosinia and herzegov":
		case "bosni en herzegovina":
		case "bosni&euml; en herzegovina":
				$country = "Bosni en Herzegovina"; break;
				
		case "ch":
		case "zwitserland":
				$country = "Zwitserland"; break;
				
		case "curacao":
				$country = "Curacao"; break;

		case "cyprus":
				$country = "Cyprus"; break;
				
		case "du":
		case "de":
		case "duitsland":
		case "germany":
		case "deutschland":
				$country = "Duitsland"; break;
				
		case "es":
		case "spain":
		case "spanje":
		case "espania":
		case "espana":
				$country = "Spanje"; break;
				
		case "estonia":
				$country = "Estonia"; break;
				
		case "fi":
		case "finland":
				$country = "Finland"; break;
				
		case "fr":
		case "france":
		case "frankrijk":
				$country = "Frankrijk"; break;
				
		case "gb":
		case "groot-brittani":
		case "groot-brittanni":
		case "groot-brittanie":
		case "groot-brittani":
		case "groot-brittani":
		case "groot-brittani&euml;":
		case "groot-brittanni&euml;":
		// @change t48135
		case "groot-brittanni?":
		//
		case "great britain":
		case "uk":
				$country = "Groot-Brittanni"; break;
				
  		case "in":
  		case "india":
				$country = "India"; break;
				
		case "it":
		case "itali":
		case "italie":
		case "itali":
		// @change t48135
		case "itali?":
		//
		case "itali&euml;":
		case "itali&amp;euml;":
				$country = "Itali"; break;

  		case "no":
				$country = "Noorwegen"; break;

  		case "nedeland":
  		case "nederland":
  		case "the netherlands":
  		case "nl":
				$country = "Nederland"; break;

		case "nieuw-zeeland":
			$country = "Nieuw-Zeeland"; break;

  		case "suriname":
				$country = "Suriname"; break;
  		case "thailand":
				$country = "Thailand"; break;
  		case "us":
  		case "usa":
  		case "united states":
  		case "america":
  		case "amerika":
				$country = "United States"; break;
  		case "ukraine":
  		case "oekrane":
  		case "oekra&iuml;ne":
				$country = "Ukraine"; break;
  		case "zuid-afrika":
  		case "republic of south af":
  		case "rep. of south africa":
				$country = "Rep. of South Africa"; break;
  		case "zwitserland":
  		case "schweiz":
				$country = "Zwitserland"; break;
		case "tsjechi":
		case "tjechi":
		case "tsjechi":
		case "tjechi":
		case "tsjechi&euml;":
		case "tjechi&euml;":
		case "tsjechi&amp;euml;":
		case "tjechi&amp;euml;":
		case "czech republic":
				$country = "Tsjechi"; break;
  		case "pl":
  		case "polen":
				$country = "Polen"; break;
  		case "pakistan":
				$country = "Pakistan"; break;
  		case "denemarken":
  		case "danmark":
  		case "denmark":
  		case "dk":
  		case "dnk":
				$country = "Denemarken"; break;
  		case "sweden":
  		case "zweden":
				$country = "Zweden"; break;


  		case "slowakije":
  		case "slovak republic":
				$country = "Slowakije"; break;
				
				
      		case "oostenrijk":
  		case "sterreich":
  		case "&ouml;sterreich":
  		case "&amp;ouml;sterreich":
				$country = "Oostenrijk"; break;
  		case "xx":
  		case "eu":
				$country = ""; break;
  		case "republic of belarus":
  		case "wit rusland":
  		case "wit-rusland":
  		case "republiek belarus (wit-rusland)":
  		case "republiek belarus (wit-rusland":
  		case "republiek belarus, wit-rusland":
				$country = "Republiek Belarus, Wit-Rusland"; break;
  		default:
				// mail('sales@vicus.nl', 'CRM unknown or empty country', "Country: |$country|, Adresid: $adresid in \n".__FILE__.':'.__LINE__);
				// ter test van t48135
				// mail('jho@vicus.nl', 'CRM unknown or empty country', "Country: |$country|, Adresid: $adresid in \n".__FILE__.':'.__LINE__);
	}
				
// var_dump($country);
// var_dump(mb_detect_encoding($country));
	return $country;
}


// indeleing volgens poco kaart
function getSalesRegions()
{
	$region[1] = array(17,86,87,88,89,90,91);
	$region[2] = array(84,85,92);
	$region[3] = array(93,94,95,96,97,98,99);

	$region[7] = array(12,13,36);
	$region[10] = array(37,38);
	$region[13] = array(34,35,39);
	
}

/**
 * Returns the name of the region
 * @param	string	poco
 * @return	string	 name of the region
 */
function getPoCoRegion($postcode)
{

	$data = array(
		10 => "Amsterdam",
		11 => "Volendam, Zwanenburg, Amstelveen",
		12 => "Hilversum, Laren, Huizen",
		13 => "Almere, Weesp",
		14 => "Bussum, Uithoorn, Purmerend",
		15 => "Zaandam, Wormerveer",
		16 => "Enkhuizen, Hoorn",
		17 => "Heerhugowaard, Schagen, Den Helder",
		18 => "Alkmaar",
		19 => "Castricum, Beverwijk, IJmuiden",
		20 => "Haarlem",
		21 => "Heemstede, Hoofddorp, Lisse",
		22 => "Noordwijk, Wassenaar, Voorschoten, Rijswijk, Katwijk ZH, Leidschendam, Voorburg",
		23 => "Leiden",
		24 => "Alphen aan den Rijn",
		25 => "\s-Gravenhage",
		26 => "Delft, Naaldwijk, Monster",
		27 => "Zoetemeer, Waddinxveen",
		28 => "Gouda",
		29 => "Capelle a/d IJssel, Krimpen a/d IJssel, Ridderkerk, Alblasserdam",
		30 => "Rotterdam",
		31 => "Schiedam, Vlaardingen, Maassluis, Hoogvliet",
		32 => "Spijkenisse, Hellevoetsluis, Oud-Beijerland, Middelharnis",
		33 => "Dordrecht, Zwijndrecht, Papendrecht",
		34 => "IJsselstein, Nieuwegein, Woerden",
		35 => "Utrecht",
		36 => "Maarssen",
		37 => "Zeist, Baarn, Bilthoven, Soest, Barneveld",
		38 => "Amersfoort, Harderwijk, Nijkerk",
		39 => "Veenendaal, Doorn, Driebergen",
		40 => "Tiel",
		41 => "Culemborg, Leerdam",
		42 => "Gorinchem",
		43 => "Zierikzee, Middelburg, Vlissingen",
		44 => "Goes",
		45 => "Oostburg, Terneuzen, Hulst",
		46 => "Bergen op Zoom",
		47 => "Roosendaal",
		48 => "Breda",
		49 => "Oosterhout",
		50 => "Tilburg",
		51 => "Waalwijk",
		52 => "s-Hertogenbosch, Vught",
		53 => "Zaltbommel, Oss",
		54 => "Uden,Veghel",
		55 => "Veldhoven, Valkenswaard",
		56 => "Eindhoven",
		57 => "Helmond, Deurne",
		58 => "Venray",
		59 => "Venlo",
		60 => "Weert, Roermond",
		61 => "Sittard, Geleen",
		62 => "Maastricht",
		63 => "Heerlen",
		64 => "Brunssum, Kerkrade",
		65 => "Nijmegen",
		66 => "Wychen, Elst",
		67 => "Wageningen, Ede",
		68 => "Arnhem, Velp, Oosterbeek",
		69 => "Zevenaar, Dieren",
		70 => "Doetinchem",
		71 => "Winterswijk, Lichtenvoorde",
		72 => "Zutphen",
		73 => "Apeldoorn",
		74 => "Deventer, Nijverdal, Goor",
		75 => "Enschede, Hengelo, Oldenzaal",
		76 => "Almelo, Vriezenveen",
		77 => "Dedemsvaart, Coevorden",
		78 => "Emmen",
		79 => "Hoogeveen, Meppel",
		80 => "Zwolle, Nunspeet",
		81 => "Raalte, Epe",
		82 => "Lelystad, Kampen",
		83 => "Emmenloord, Steenwijk",
		84 => "Gorredijk, Heerenveen",
		85 => "Joure",
		86 => "Sneek",
		87 => "Bolsward",
		88 => "Franeker",
		89 => "Leeuwarden",
		90 => "Grouw, Berlikum",
		91 => "Dokkum",
		92 => "Drachten",
		93 => "Roden",
		94 => "Assen",
		95 => "Stadskanaal",
		96 => "Hoogezand, Veendam, Winschoten",
		97 => "Groningen",
		98 => "Aduard",
		99 => "Appingedam, Winsum"
		);

	$code = substr($postcode,0,2);

	// postcode => postcoderegion
	$salesRegion['Amsterdam'] = array(10,11);
	$salesRegion['Haarlem-Hoorn'] = array(15,16,17,18,19);
	$salesRegion['Den Haag'] = array(20,21,22,23,25,26);
	$salesRegion['Gouda-woerden'] = array(24,27,28);
	$salesRegion['Utrecht-noord'] = array(36);
	$salesRegion['Utrecht-zuid'] = array(34,35,39);
	$salesRegion['Eemland'] = array(37);
	$salesRegion['Amersfoort'] = array(38);
	$salesRegion['Midden'] = array(12,13,14,40,41,67);
	$salesRegion['Rotterdam'] = array(29,30,31,32,33);
	$salesRegion['Zeeland'] = array(43,44,45,46);
	$salesRegion['Gorinchem'] = array(42);
	$salesRegion['Brabant-Breda'] = array(47,48,49);
	$salesRegion['Brabant-Tilburg'] = array(50,51);
	$salesRegion['Brabant-DenBosch'] = array(52);
	$salesRegion['Brabant-Nijmegen'] = array(53,54,55,65,66,58);
	$salesRegion['Brabant-Eindhoven'] = array(56,57,60);
	$salesRegion['Arnhem-Apeldoorn'] = array(68,69,72,73); // Cad2M, Burton, 
	$salesRegion['Zwolle-Kampen'] = array(80,81,82); // geen klanten !
	$salesRegion['Deventer-Enschede'] = array(74,75,76); // idrogist, braams
	$salesRegion['Limburg-Venlo'] = array(59);
	$salesRegion['Limburg-Maastricht'] = array(61,62,63,64);
	$salesRegion['Hengelo'] = array(70,71,72);
	$salesRegion['Friesland-Heerenveen'] = array(77,79,83,84,85); // geen klanten
	$salesRegion['Friesland-Leeuwarden'] = array(89); // geen klanten	
	$salesRegion['Groningen'] = array(78,87,86,88,90,91,92,93,94,95,96,97,98,99);
	
	// can be cached later on
	foreach ($salesRegion as $regionname => $pocos) {
		if (in_array($code,$pocos)) {
			return $regionname;
		} 
	}

//	return $data[$code];
	return FALSE;
}
