<?php
/*
 * needed for cmdline php call, not for cron call
 * require_once('includes/Loader.php');
 * require_once('include/utils/utils.php');
 * require_once('include/database/PearDatabase.php');
 * include_once ('includes/main/WebUI.php');
 *
 */

include('cron/modules/VebEmailConsent/VebEmailConsent.php');

/*
 *
 *
 */
class VebEmailConsentCron extends VebEmailConsent {

  public function __construct() {

    parent::__construct();

    $this->processLeads();
    $this->processContacts();
  }

  private function processLeads() {

    // leads active
    if (!vtlib_isModuleActive('Leads')) return;

    // check for fieldname
    $focus = CRMEntity::getInstance('Leads');
    $emailconsentStatusField = 'veb_l_emailconsent';
    $offsetExists = $focus->column_fields->offsetExists($emailconsentStatusField);
    if ($offsetExists === false) $emailconsentStatusField = 'veb_emailconsent_status';

    // now
    $now = date('Y-m-d');

    // first leads
    $query = sprintf("SELECT e.crmid
                      FROM vtiger_leaddetails l, vtiger_crmentity e
                      WHERE l.leadid = e.crmid
                      AND e.deleted = 0
                      AND l.%s = ?
                      AND l.veb_emailconsent_date <= SUBDATE(?, ?)", $emailconsentStatusField);

    // from config
    $result = $this->adb->pquery($query, array('Invited', $now, $this->consentSettings->get('send_reminder_delta')));

    $noOfRecords = $this->adb->num_rows($result);

    for($i=0; $i<$noOfRecords; $i++) {

      // get the id of the applicable lead
      $entityId = $this->adb->query_result($result, $i, 'crmid');

      $this->crmId = $entityId;

      $object = new VTEntityData;
      $entity = $object::fromEntityId($this->adb, $entityId, 'Leads');

      $this->assignedUserId = $entity->get('assigned_user_id');

      // call the workflow function
      $this->run($entity);
    }

    // leads - expired
    $result = $this->adb->pquery($query, array('Reminded', $now, $this->consentSettings->get('set_expired_delta')));

    $noOfRecords = $this->adb->num_rows($result);

    for($i=0; $i<$noOfRecords; $i++) {

      // get the id of the applicable lead
      $entityId = $this->adb->query_result($result, $i, 'crmid');

      $this->crmId = $entityId;

      $object = new VTEntityData;
      $entity = $object::fromEntityId($this->adb, $entityId, 'Leads');

      $this->assignedUserId = $entity->get('assigned_user_id');

      // call the workflow function
      $this->run($entity);
    }
  }

  private function processContacts() {

    // contacts active
    if (!vtlib_isModuleActive('Contacts')) return;

    // check for fieldname
    $focus = CRMEntity::getInstance('Contacts');
    $emailconsentStatusField = 'veb_c_emailconsent';
    $offsetExists = $focus->column_fields->offsetExists($emailconsentStatusField);
    if ($offsetExists === false) $emailconsentStatusField = 'veb_emailconsent_status';

    $now = date('Y-m-d');

    // next contacts
    $query = sprintf("SELECT e.crmid
                      FROM vtiger_contactdetails c, vtiger_crmentity e
                      WHERE c.contactid = e.crmid
                      AND e.deleted = 0
                      AND c.%s = ?
                      AND c.veb_emailconsent_date <= SUBDATE(?, ?)", $emailconsentStatusField);

    // from config
    $result = $this->adb->pquery($query, array('Invited', $now, $this->consentSettings->get('send_reminder_delta')));

    $noOfRecords = $this->adb->num_rows($result);

    $this->log($query);
    $this->log('Invited');
    $this->log($now);
    $this->log($this->consentSettings->get('send_reminder_delta'));
    $this->log($noOfRecords);

    for($i=0; $i<$noOfRecords; $i++) {

      $entityId = $this->adb->query_result($result, $i, 'crmid');

      $this->crmId = $entityId;

      $object = new VTEntityData;
      $entity = $object::fromEntityId($this->adb, $entityId, 'Contacts');

      $this->assignedUserId = $entity->get('assigned_user_id');

      $this->log(var_export($entity,true));
      $this->log($entity->get('assigned_user_id'));

      // call the workflow function
      $this->run($entity);
    }

    // contacts - expired
    $result = $this->adb->pquery($query, array('Reminded', $now, $this->consentSettings->get('set_expired_delta')));

    $noOfRecords = $this->adb->num_rows($result);

    $this->log($noOfRecords);

    for($i=0; $i<$noOfRecords; $i++) {

      $entityId = $this->adb->query_result($result, $i, 'crmid');

      $this->crmId = $entityId;

      $object = new VTEntityData;
      $entity = $object::fromEntityId($this->adb, $entityId, 'Contacts');

      $this->assignedUserId = $entity->get('assigned_user_id');

      // call the workflow function
      $this->run($entity);
    }
  }

  protected function log($msg) {

    return;
    error_log('VebEmailConsent - ' . $msg);
  }
}

// initiate object and run
$consentMail = new VebEmailConsentCron;
