<?php
/*
 *
 *
 */
function emailConsent($entity) {

  // first of all - module active?
  if (!vtlib_isModuleActive('VebEmailConsent')) return false;

  $entityId = $entity->getId();
  list($wsModule, $crmId) = explode('x', $entityId);

  $assignedUser = $entity->get('assigned_user_id');
  list($wsModule, $assignedUserId) = explode('x', $assignedUser);

  $consent = new VebEmailConsent;
  $consent->setAssignedUserId($assignedUserId);
  $consent->setCrmId($crmId);

  // execute the flow
  $consent->run($entity);
}

class VebEmailConsent {

  protected $adb;
  protected $consentSettings = false;

  function __construct() {

    $this->adb = PearDatabase::getInstance();

    // next - settings from config
    $this->consentSettings = Settings_VebEmailConsent_Record_Model::getInstance();

    // configured?
    if ($consentSettings->configured === false) return false;

    // overrule current user - from config
    $user = new Users;
    $current_user = $user->retrieveCurrentUserInfoFromFile($this->consentSettings->get('emailconsent_from_id'));
    $current_user->authenticated = true;

    // set it in global array - do we need to unset is at the end of this function?
    vglobal('current_user', $current_user);
  }

  public function setAssignedUserId($assignedUserId) {

    $this->assignedUserId = $assignedUserId;
  }

  public function setCrmId($crmId) {

    $this->crmId = $crmId;
  }

  public function run($entityData) {

    $moduleName = $entityData->moduleName;

    $focus = CRMEntity::getInstance($moduleName);
    $focus->retrieve_entity_info($this->crmId, $moduleName);
    $focus->mode = 'edit';
    $focus->id = $this->crmId;

    /*
     * old:veb_l_emailconsent/veb_c_emailconsent
     * new:veb_emailconsent_status
     * 
     * old:veb_l_emailoptin/veb__emailoption
     * new:veb_emailconsent_optin
     * 
     * old:veb_emailconsent_date
     * new:veb_emailconsent_date
     * 
     * old:veb_emailconsent_nofbounces
     * new:veb_emailconsent_nofbounces
     * 
     * old:veb_emailconsent_text
     * new:veb_emailconsent_text
     * 
     * old:emailconsent_optout_reason
     * new:veb_emailconsent_optout_reason
     * 
     * old:c_newsletter_optout
     * new:veb_emailconsent_optout
     */
    // jho: if changed to switch
    switch ($moduleName) {

      case 'Leads':

        $optinField = 'veb_l_emailoptin';
        $offsetExists = $focus->column_fields->offsetExists($optinField);
        if ($offsetExists === false) $optinField = 'veb_emailconsent_optin';

        $optoutField = 'c_newsletter_optout';
        $offsetExists = $focus->column_fields->offsetExists($optoutField);
        if ($offsetExists === false) $optoutField = 'veb_emailconsent_optout';

        $optoutReasonField = 'emailconsent_optout_reason';
        $offsetExists = $focus->column_fields->offsetExists($optoutReasonField);
        if ($offsetExists === false) $optoutReasonField = 'veb_emailconsent_optout_reason';

        $emailconsentStatusField = 'veb_l_emailconsent';
        $offsetExists = $focus->column_fields->offsetExists($emailconsentStatusField);
        if ($offsetExists === false) $emailconsentStatusField = 'veb_emailconsent_status';

        $emailAddress = $entityData->get('email');

        // @todo move this to the vtiger settings module (later in version 2 or 3)
        $templates = array(
            'consent-invite-to-confirm' => $this->consentSettings->get('leads_invite_tpl_id'),
            'consent-remind-to-confirm' => $this->consentSettings->get('leads_remind_tpl_id'),
            'consent-confirm-optout' => $this->consentSettings->get('leads_confirm_optout_tpl_id'),
        );
        break;

      case 'Contacts':

        $optinField = 'veb_c_emailoptin';
        $offsetExists = $focus->column_fields->offsetExists($optinField);
        if ($offsetExists === false) $optinField = 'veb_emailconsent_optin';

        $optoutField = 'c_newsletter_optout';
        $offsetExists = $focus->column_fields->offsetExists($optoutField);
        if ($offsetExists === false) $optoutField = 'veb_emailconsent_optout';

        $optoutReasonField = 'emailconsent_optout_reason';
        $offsetExists = $focus->column_fields->offsetExists($optoutReasonField);
        if ($offsetExists === false) $optoutReasonField = 'veb_emailconsent_optout_reason';

        $emailconsentStatusField = 'veb_c_emailconsent';
        $offsetExists = $focus->column_fields->offsetExists($emailconsentStatusField);
        if ($offsetExists === false) $emailconsentStatusField = 'veb_emailconsent_status';

        $emailAddress = $entityData->get('email');

        // @todo move this to the vtiger settings module (later in version 2 or 3)
        $templates = array(
            'consent-invite-to-confirm' => $this->consentSettings->get('contacts_invite_tpl_id'),
            'consent-remind-to-confirm' => $this->consentSettings->get('contacts_remind_tpl_id'),
            'consent-confirm-optout' => $this->consentSettings->get('contacts_confirm_optout_tpl_id')
        );

        break;

      default:

        //  wrong module
        return;
    }

    // @change lro 190829
    $emailconsent_optin = ($entityData->get($optinField) == 'on' || $entityData->get($optinField) == 1);
    $emailconsent_optout = ($entityData->get($optoutField) == 'on' || $entityData->get($optoutField) == 1);
    $emailconsent_status = strtolower($entityData->get($emailconsentStatusField));
    $email_optout = ($entityData->get('emailoptout') == 'on' || $entityData->get('emailoptout') == 1);

    $emailcampaign_optout = false;
    if (vtlib_isModuleActive('EmailCampaigns')) $emailcampaign_optout = strtolower($entityData->get('emailcampaign_optout'));

    // nodig om te weten wat er is aangepast!
    //
    // @todo als changed emailoptout naar 1 en emailconsent_status != blacklisted dan => Blacklisted

    // is possible that optin or optout was checked, is such case the emailconsent_status field might be empty
    // $emailconsent_status is gezet in willekeurige waarde (niet leeg, niet optout/subscribed)
    // en dan de checkbox optout wordt aangevinkt
    // maar wellicht hebben we die checkbox (optout) niet nodig
    // optin hebben we wel nodig omdat die via een formulier aangevinkt binnenkomt
    if ($emailconsent_status == '' && $emailconsent_optin) {

      $emailconsent_status = 'optin';
    }
    elseif ($emailconsent_status != 'unsubscribed' && $emailconsent_status != 'blacklisted' && ($emailconsent_optout || $emailcampaign_optout)) {

      $emailconsent_status = 'optout';
    }
    elseif ($emailconsent_status != 'blacklisted' && $email_optout) {

      // als emailoptout -> dan in principe geen mail sturen => blacklisted
      // @todo maar als iemand dan een optin stuurt, wat doen we dan?
      // blacklisted moet altijd handmatig worden omgezet, de blokkkade staat er niet voor niets (bv concurrent, uit dienst) handmatige controle is dan dus nodig
      // dus stuur dan een mail naar sales@vicus.nl
      // @todo instelbaar in settings
      $emailconsent_status = 'add2blacklist';
    }

    switch ($emailconsent_status) {

      case 'optin':

        // stuur email: Invite to Conform
        $sendEmail = true;
        $emailTemplateId = $templates['consent-invite-to-confirm'];

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op Invited
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Invited');
        $focus->column_fields->offsetSet($campaignOptoutField, '0');

        // no workflows
        $focus->saveentity($moduleName);
        break;

     case 'invited':

        // wacht periode x
        $date_today = new DateTime( date('Y-m-d')) ;
        $date_consent = new DateTime($focus->column_fields['veb_emailconsent_date']);
        $difference = $date_consent->diff($date_today);
 
        // @todo move this to the vtiger settings module (later in version 2 or 3)
        if ($difference->days < $this->consentSettings->get('send_reminder_delta')) break;

        // als nog steeds invited stuur email: reminder - another workflow
        // @todo why not also through this file??
        $sendEmail = true;
        $emailTemplateId = $templates['consent-remind-to-confirm'];

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op Reminded
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Reminded');

        $focus->saveentity($moduleName);
        break;

      case 'reminded':
 
        // wacht periode x
        $date_today = new DateTime( date('Y-m-d')) ;
        $date_consent = new DateTime($focus->column_fields['veb_emailconsent_date']);
        $difference = $date_consent->diff($date_today);
 
        // @todo move this to the vtiger settings module (later in version 2 or 3)
        if ($difference->days < $this->consentSettings->get('set_expired_delta'))  break;
 
        $sendEmail = false;

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op Expired
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Expired');

        $focus->saveentity($moduleName);
        break;

      case 'add2blacklist':

        $sendEmail = false;

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op Expired
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Blacklisted');

        // set emailconsent_optin to false
        // set emailcampaign_optout to true
        $focus->column_fields->offsetSet($optinField, '0');
        $focus->column_fields->offsetSet($optoutField, '1');

        if (vtlib_isModuleActive('EmailCampaigns')) $focus->column_fields->offsetSet('emailcampaign_optout', '1');

        $focus->saveentity($moduleName);
        break;

      case 'blacklisted':
      case 'expired':

        // do nothing
        $sendEmail = false;
        break;

      case 'confirmed':

        // stuur email: confirmed
        $sendEmail = false;

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op Subscribed
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Subscribed');
        $focus->column_fields->offsetSet($optoutReasonField, '');

        // set emailoptout to false
        $focus->column_fields->offsetSet($optoutField, '0');

        // set emailcampaign_optout to false
        if (vtlib_isModuleActive('EmailCampaigns')) $focus->column_fields->offsetSet('emailcampaign_optout', '0');

        $focus->saveentity($moduleName);
        break;

      case 'subscribed':

        // wacht
        $sendEmail = false;
        break;

      case 'optout':

        // stuur email: bevestiging opt-out (doel: win back, goed gevoel achterlaten)
        $sendEmail = true;

        $emailTemplateId = $templates['consent-confirm-optout'];

        // zet E-mail consent datum nu
        $focus->column_fields->offsetSet('veb_emailconsent_date', date('Y-m-d'));

        // zet emailconsent op unsubscribed
        $focus->column_fields->offsetSet($emailconsentStatusField, 'Unsubscribed');

        // only when empty - otherwise reasons from vema will be overwritten
        if (empty($focus->column_fields->offsetGet($optoutReasonField))) {

          $focus->column_fields->offsetSet($optoutReasonField, 'Afgemeld via werkstroom');
        }

        // set emailconsent_optin to false
        // set optout to true
        $focus->column_fields->offsetSet($optinField, '0');
        $focus->column_fields->offsetSet($optoutField, '1');

        // set emailcampaign_optout to true
        if (vtlib_isModuleActive('EmailCampaigns')) $focus->column_fields->offsetSet('emailcampaign_optout', '1');

        $focus->saveentity($moduleName);
        break;

      case 'unsubscribed':

        // wacht
        $sendEmail = false;
        break;

      case 'bounced':

        // wacht
        $sendEmail = false;
        break;

      default:

        // no change
        $sendEmail = false;
        break;
    }

    if ($sendEmail) {

      // @todo if email out is blocked we still send this confirmations. sounds strange but lets do so.
      if ($email_optout) {

        $userInstance = new Users();
        $user = $userInstance->retrieve_entity_info($this->consentSettings->get('emailconsent_to_id'), 'Users', false) ;
        $emailAddress = $user->email1;
      }

      // @change lro 190829 added templateid
      // @change WHERE templatename = ? => WHERE templateid = ?';
      // @todo wellicht checkbox systemtemplate aanzetten zodat deze sjablonen ook niet verwijderd kunnen worden door de user!
      $query = 'SELECT vtiger_emailtemplates.subject,vtiger_emailtemplates.body, vtiger_emailtemplates.templateid
                FROM vtiger_emailtemplates
                WHERE templateid = ?';

      $result = $this->adb->pquery($query, array($emailTemplateId));

      $body = decode_html($this->adb->query_result($result,0,'body'));

      if (!empty($body)) {

        // clean instance of Emails_Record_Model
        $recordModel = Vtiger_Record_Model::getCleanInstance('Emails');
        $recordModel->set('mode', '');

        // @change t45154
        $body = $recordModel->setVemaBody($body);
        //

        $contents = $body;
        $contents = decode_html(getMergedDescription($contents, $this->crmId, $moduleName));

        $emailTemplateName = decode_html($this->adb->query_result($result, 0, 'templatename'));
        
        $subject = decode_html($this->adb->query_result($result, 0, 'subject'));
        $subject = decode_html(getMergedDescription($subject, $this->crmId, $moduleName));

        $recordId = $this->crmId;
        $signature = 'Yes'; // @change lro 190830 added yes

        // $recordModel = Vtiger_Record_Model::getCleanInstance('Emails');
        $recordModel->set('mode', '');

        // To remove script tags
        $processedContent = Emails_Mailer_Model::getProcessedContent($contents);
        $mailerInstance = Emails_Mailer_Model::getInstance();
        $processedContentWithURLS = decode_html($mailerInstance->convertToValidURL($processedContent));

        // @TODO forced to prevent emails to externals for test
        // $emailAddress = 'sales@vicus.nl';

        $recordModel->set('description', $processedContentWithURLS);
        $recordModel->set('subject', $subject);
        $recordModel->set('saved_toid', $emailAddress);
        $recordModel->set('ccmail', array());
        $recordModel->set('bccmail', array());
        $recordModel->set('assigned_user_id', $this->assignedUserId);
        $recordModel->set('email_flag', 'SENT');
        $recordModel->set('signature' , $signature);
      
        // fill the required array (dont know why, just need to be filled
        // @see modules\Emails\models\Record.php aprox line 122
        $toemailinfo = array();
        $toemailinfo[$recordId] = array($emailAddress);
        $recordModel->set('toemailinfo' , $toemailinfo);

        $parentIds = $recordId . '@1|';
        $recordModel->set('parent_id', $parentIds);

        // save_module still depends on the $_REQUEST, need to clean it up
        $_REQUEST['parent_id'] = $parentIds;

        // same issue
        $_REQUEST['tkstempid'] = $emailTemplateId;
        $_REQUEST['tkstempname'] = $emailTemplateName;

        // save the record - gets the id for email tracking (if enabled)
        $recordModel->save();

        $status = $recordModel->send();

        // This is needed to set vtiger_email_track table as it is used in email reporting
        if ($status === true) $recordModel->setAccessCountValue();
      }
    }
  }
}
