<?php
/*
 *
 *
 */
function emailConsent($entity) {

  // first of all - module active?
  if (!vtlib_isModuleActive('VebEmailConsent')) return false;

  $entityId = $entity->getId();
  list($wsModule, $crmId) = explode('x', $entityId);

  $assignedUser = $entity->get('assigned_user_id');
  list($wsModule, $assignedUserId) = explode('x', $assignedUser);

  $consent = new VebEmailConsent;
  $consent->setAssignedUserId($assignedUserId);
  $consent->setCrmId($crmId);

  // execute the flow
  $consent->run($entity);
}

class VebEmailConsent {

  protected $adb;

  function __construct() {

    $this->adb = PearDatabase::getInstance();

    if (Settings_VebSettings_Record_Model::isConfigured('VebEmailConsent') === false) return false;

    // overrule current user - from config
    $userId = Settings_VebSettings_Record_Model::getSetting('emailconsent_from_id', 'VebEmailConsent');

    if (!empty($userId)) {

      $user = new Users;
      $current_user = $user->retrieveCurrentUserInfoFromFile($userId);
      $current_user->authenticated = true;

      // set it in global array - do we need to unset is at the end of this function?
      vglobal('current_user', $current_user);
    }
  }

  public function setAssignedUserId($assignedUserId) {

    $this->assignedUserId = $assignedUserId;
  }

  public function setCrmId($crmId) {

    $this->crmId = $crmId;
  }

  public function run($entityData) {

    $moduleName = $entityData->moduleName;

    switch ($moduleName) {

      case 'Leads':

        $templates = array(
            'consent-invite-to-confirm' => Settings_VebSettings_Record_Model::getSetting('leads_invite_tpl_id', 'VebEmailConsent'),
            'consent-remind-to-confirm' => Settings_VebSettings_Record_Model::getSetting('leads_remind_tpl_id', 'VebEmailConsent'),
            'consent-confirm-optout' => Settings_VebSettings_Record_Model::getSetting('leads_confirm_optout_tpl_id', 'VebEmailConsent'),
        );
        break;

      case 'Contacts':

        $templates = array(
            'consent-invite-to-confirm' => Settings_VebSettings_Record_Model::getSetting('contacts_invite_tpl_id', 'VebEmailConsent'),
            'consent-remind-to-confirm' => Settings_VebSettings_Record_Model::getSetting('contacts_remind_tpl_id', 'VebEmailConsent'),
            'consent-confirm-optout' => Settings_VebSettings_Record_Model::getSetting('contacts_confirm_optout_tpl_id', 'VebEmailConsent'),
        );
        break;

      default:

        //  wrong module
        return;
    }

    $focus = VebEmailConsent_Record_Model::getEntityById($this->crmId);

    // initialize the data - values for flow - standarised fields
    $emailAddress = $focus->email;

    $emailconsent_optin = ($focus->emailconsent_optin == 'on' || $focus->emailconsent_optin == 1);
    $emailconsent_optout = ($focus->emailconsent_optout == 'on' || $focus->emailconsent_optout == 1);
    $emailconsent_status = strtolower($focus->emailconsent_status);

    $email_optout = ($focus->emailconsent_optout == 'on' || $focus->emailconsent_optout == 1);

    $emailcampaign_optout = false;
    if (vtlib_isModuleActive('EmailCampaigns')) $emailcampaign_optout = $focus->emailcampaign_optout;

    // nodig om te weten wat er is aangepast!
    //
    // @todo als changed emailoptout naar 1 en emailconsent_status != blacklisted dan => Blacklisted

    // is possible that optin or optout was checked, is such case the emailconsent_status field might be empty
    // $emailconsent_status is gezet in willekeurige waarde (niet leeg, niet optout/subscribed)
    // en dan de checkbox optout wordt aangevinkt
    // maar wellicht hebben we die checkbox (optout) niet nodig
    // optin hebben we wel nodig omdat die via een formulier aangevinkt binnenkomt
    if ($emailconsent_status == '' && $emailconsent_optin) {

      $emailconsent_status = 'optin';
    }
    elseif ($emailconsent_status != 'unsubscribed' && $emailconsent_status != 'blacklisted' && ($emailconsent_optout || $emailcampaign_optout)) {

      $emailconsent_status = 'optout';
    }
    elseif ($emailconsent_status != 'blacklisted' && $email_optout) {

      // als emailoptout -> dan in principe geen mail sturen => blacklisted
      // @todo maar als iemand dan een optin stuurt, wat doen we dan?
      // blacklisted moet altijd handmatig worden omgezet, de blokkkade staat er niet voor niets (bv concurrent, // uit dienst)
      // handmatige controle is dan dus nodig
      // dus stuur dan een mail naar sales@vicus.nl
      $emailconsent_status = 'add2blacklist';
    }

    switch ($emailconsent_status) {

      case 'optin':

        // stuur email: Invite to Conform
        $sendEmail = true;
        $emailTemplateId = $templates['consent-invite-to-confirm'];

        // standarised  saving
        VebEmailConsent_Record_Model::setEmailConsentInvited($focus);
        break;

     case 'invited':

        // wacht periode x
        $dateToday = new DateTime(date('Y-m-d')) ;
        $dateConsent = new DateTime($focus->emailconsent_date);
        $difference = $dateConsent->diff($dateToday);

        $deltaDays = Settings_VebSettings_Record_Model::getSetting('send_reminder_delta', 'VebEmailConsent');

        if ($difference->days > $deltaDays) {

          // als nog steeds invited stuur email: reminder - another workflow
          $sendEmail = true;
          $emailTemplateId = $templates['consent-remind-to-confirm'];

          // standarised  saving
          VebEmailConsent_Record_Model::setEmailConsentReminded($focus);
        }
        break;

      case 'reminded':

        // wacht periode x
        $dateToday = new DateTime( date('Y-m-d')) ;
        $dateConsent = new DateTime($focus->emailconsent_date);
        $difference = $dateConsent->diff($dateToday);

        $deltaDays = Settings_VebSettings_Record_Model::getSetting('send_expired_delta', 'VebEmailConsent');

        if ($difference->days > $deltaDays) {

          $sendEmail = false;

          // standarised  saving
          VebEmailConsent_Record_Model::setEmailConsentExpired($focus);
        }
        break;

      case 'add2blacklist':

        $sendEmail = false;

        // standarised  saving
        VebEmailConsent_Record_Model::setEmailConsentExpired($focus);
        break;

      case 'blacklisted':
      case 'expired':

        // do nothing
        $sendEmail = false;
        break;

      case 'confirmed':

        // stuur email: confirmed
        $sendEmail = false;

        // standarised  saving
        VebEmailConsent_Record_Model::setEmailConsentConfirmed($focus);
        break;

      case 'subscribed':

        // wacht
        $sendEmail = false;
        break;

      case 'optout':

        // stuur email: bevestiging opt-out (doel: win back, goed gevoel achterlaten)
        $sendEmail = true;
        $emailTemplateId = $templates['consent-confirm-optout'];

        // standarised  saving
        VebEmailConsent_Record_Model::setEmailConsentOptout($focus);
        break;

      case 'unsubscribed':

        // wacht
        $sendEmail = false;
        break;

      case 'bounced':

        // wacht
        $sendEmail = false;
        break;

      default:

        // no change
        $sendEmail = false;
        break;
    }

    if ($sendEmail) {

      // @todo if email out is blocked we still send this confirmations. sounds strange but lets do so.
      if ($email_optout) {

        // email address to send the blacklistmails to (overruling the contact/lead emailaddress)
        $emailAddress = VebEmailConsent_Record_Model::blacklistToAddress();

        // notihing to do when not set
	if ($emailAddress === false) return;
      }

      // get the correct emailtemplate
      $templateRecordModel = EmailTemplates_Record_Model::getInstanceById($emailTemplateId);
      $body = $templateRecordModel->get('body');

      // no body, no mail
      if (empty($body)) return;

      // clean instance of Emails_Record_Model
      $recordModel = Vtiger_Record_Model::getCleanInstance('Emails');
      $recordModel->set('mode', '');
      $body = $recordModel->setVemaBody($body);
      // $body = $recordModel->getBody();

      $contents = decode_html(getMergedDescription($body, $this->crmId, $moduleName));

      $emailTemplateName = decode_html($templateRecordModel->get('templatename'));

      $subject = decode_html($templateRecordModel->get('subject'));
      $subject = decode_html(getMergedDescription($subject, $this->crmId, $moduleName));

      $recordId = $this->crmId;
      $signature = 'Yes';

      // to remove script tags
      $processedContent = Emails_Mailer_Model::getProcessedContent($contents);
      $mailerInstance = Emails_Mailer_Model::getInstance();
      $processedContentWithURLS = decode_html($mailerInstance->convertToValidURL($processedContent));

      // in test, send to 1 specific email-address
      $testMailTo = VebEmailConsent_Record_Model::testmailToAddress();

      if ($testMailTo !== false) $emailAddress = $testMailTo;

      $recordModel->set('description', $processedContentWithURLS);
      $recordModel->set('subject', $subject);
      $recordModel->set('saved_toid', $emailAddress);
      $recordModel->set('ccmail', array());
      $recordModel->set('bccmail', array());
      $recordModel->set('assigned_user_id', $this->assignedUserId);
      $recordModel->set('email_flag', 'SENT');
      $recordModel->set('signature' , $signature);

      // fill the required array (dont know why, just need to be filled
      // @see modules/Emails/models/Record.php aprox line 122
      $toemailinfo = array();
      $toemailinfo[$recordId] = array($emailAddress);
      $recordModel->set('toemailinfo' , $toemailinfo);

      $parentIds = $recordId . '@1|';
      $recordModel->set('parent_id', $parentIds);

      // save_module still depends on the $_REQUEST, need to clean it up
      $_REQUEST['parent_id'] = $parentIds;

      // same issue
      $_REQUEST['tkstempid'] = $emailTemplateId;
      $_REQUEST['tkstempname'] = $emailTemplateName;

      // save the record - gets the id for email tracking (if enabled)
      $recordModel->save();

      $status = $recordModel->send();

      // This is needed to set vtiger_email_track table as it is used in email reporting
      if ($status === true) $recordModel->setAccessCountValue();
    }
  }
}
