<?php

/**
 * CreditDevice 
 * 
 * Cron task to check and enrich existing Accounts
 * 
 * @status	first beta
 * @since 	2019-04-04
 * @author	L.Roovers
 * @copyright	Vicus eBusiness Solutions BV  - www.vicus.nl
 * 
 */
chdir(dirname(__FILE__));
set_include_path(get_include_path() . PATH_SEPARATOR . '../../..');

ini_set('display_errors', 'On');
require_once('include/utils/utils.php');
require_once('includes/Loader.php');
require_once('includes/runtime/BaseModel.php');
require_once('includes/runtime/Globals.php');
require_once('includes/runtime/Controller.php');
require_once('includes/http/Request.php');  //for Vtiger_Request
require_once('includes/runtime/LanguageHandler.php'); // for vttranslate
// to revise the data
// https://community.vtiger.com/help/vtigercrm/developers/server-apis.html
include_once 'include/Webservices/Utils.php';
include_once 'include/Webservices/Revise.php';

ini_set('display_errors', 'On');
require_once('modules/VebCompanyData/actions/SearchVebCompanyData.php');

ini_set('display_errors', 'On');

////////////////////////////////////////////////////////////////////////////////////////// Get the user

$current_user = CRMEntity::getInstance('Users');
$current_user->retrieveCurrentUserInfoFromFile(1); // 1 = administrator

////////////////////////////////////////////////////////////////////////////////////////// get mappings from core module

$request = new Vtiger_Request(array());

////////////////////////////////////////////////////////////////////////////////////////// get Leads
// use adb to read, use focus/ webservcie revice to update the record to ensure it is included in the tracelog
// for test we use the last change date

//print '<h2>Leads</h2>';
$leads = getLeads();
$nofleads = count($leads);
veblog("Processing {$nofleads} leads");


/**
 * now loop trough
 * we started with data from query
 * dummy
 * now we loop trough the data and see what has been changed
 * we only fill empty fields
 * we have short data set or long data set / now only short is enabled
 * we start with short set
 * omzetgroep
 * creditdevice: 28092355
 * Vicus EB: 32105890
 */
foreach ($leads as $id => $lead)
{
    $crmid = $lead['leadid'];

    $request = new Vtiger_Request(array());

    $request->set('COC_Number', $lead['c_coc_number']); // "32105890"; // Must consist of 8 digits 	
    $request->set('reg_number', $lead['c_coc_number']); // "32105890"; // Must consist of 8 digits 	

    $data = VebCompanyData_SearchVebCompanyData_Action::inquireModuleAsArray($request); // echos the result

    $updates = prepareTheData($lead, $data);

    if (!empty($updates['coda_changed_info']))
    {
        $commentcontent = "CompanyData heeft de volgende verschillen geconstateerd:\n- ";
        $commentcontent .= implode("\n- ", $updates['coda_changed_info']);
    }
    unset($updates['coda_changed_info']);

    try {
        $wsid = vtws_getWebserviceEntityId('Leads', $crmid); // Module_Webservice_ID x CRM_ID
        $updates['id'] = $wsid;
        $updates['c_coda_last_update'] = VebCompanyData_Module_Model::companyDataFormatDate(date("Y-m-d"));
        $lead = vtws_revise($updates, $current_user);
        //$assigned_user_id = $lead['assigned_user_id'];
    } catch (WebServiceException $ex) {
        veblog("Lead $crmid error ".$ex->getMessage());
        echo $ex->getMessage();
    }

    if (!empty($commentcontent))
    {
        $assigned_user_id = vtws_getWebserviceEntityId('Users', 1);
        addModComment($commentcontent, $wsid, $assigned_user_id);
    }
    
    veblog("Lead $crmid updated ".$commentcontent);
}

////////////////////////////////////////////////////////////////////////////////////////// get Accounts

//print '<h2>Account</h2>';
$accounts = getAccounts();
//print_r($accounts);
$nofaccounts = count($accounts);
veblog("Processing {$nofaccounts} accounts");

/**
 * now loop trough
 * we started with data from query
 * dummy
 * now we loop trough the data and see what has been changed
 * we only fill empty fields
 * we have short data set or long data set / now only short is enabled
 * we start with short set
 * omzetgroep
 * creditdevice: 28092355
 * Vicus EB: 32105890
 */
foreach ($accounts as $id => $account)
{
    $crmid = $account['accountid'];
    veblog("Account Processing: $crmid");

    $request = new Vtiger_Request(array());

    $request->set('COC_Number', $account['c_coc_number']); // "32105890"; // Must consist of 8 digits 	
    $request->set('reg_number', $account['c_coc_number']); // "32105890"; // Must consist of 8 digits 	

    $data = VebCompanyData_SearchVebCompanyData_Action::inquireModuleAsArray($request); // echos the result

    veblog("CompanyData: Account found: ".$data->contact_info_name);
    var_dump($data);

    $updates = prepareTheData($account, $data);
//    veblog('Data: '.print_r($data, true));
//    veblog('Updates: '.print_r($updates, true));
//    die();

//    veblog("Account mapped: ".$updates['accountname']);

    if (!empty($updates['coda_changed_info']))
    {
        $commentcontent = "CompanyData heeft de volgende verschillen geconstateerd:\n- ";
        $commentcontent .= implode("\n- ", $updates['coda_changed_info']);
    }
    unset($updates['coda_changed_info']);

    // only if fields are filled, otherwise we maken them empty
    if ($updates['accountname'] != '') {
        $updates['accountname'] = replaceUnwanted($updates['accountname']);
    }
    if ($updates['c_tradenames'] != '') {
        $updates['c_tradenames'] = replaceUnwanted($updates['c_tradenames']);
    }
    
    try 
    {
        $wsid = vtws_getWebserviceEntityId('Accounts', $crmid); // Module_Webservice_ID x CRM_ID
        $updates['id'] = $wsid;
        $updates['c_coda_last_update'] = VebCompanyData_Module_Model::companyDataFormatDate(date("Y-m-d"));
        veblog("Account $wsid about to be revised");
        $account = vtws_revise($updates, $current_user);
        if(!$account) {
            veblog("Account $crmid error empty result (maybe an duplicate accountname)");
        } else {
            veblog("Account $wsid revised"); // .print_r($updates,true));
        }
        //$assigned_user_id = $account['assigned_user_id'];

    } catch (WebServiceException $ex) {
        veblog("Account $crmid error ".$ex->getMessage());
        echo $ex->getMessage();
    }

    if (!empty($commentcontent))
    {
        $assigned_user_id = vtws_getWebserviceEntityId('Users', 1);
        addModComment($commentcontent, $wsid, $assigned_user_id);
    }
    
    veblog("Account $crmid updated ".$commentcontent);
}

function replaceUnwanted($data)
{
    $data = str_ireplace('','', $data);
    $data = str_ireplace('&euml;','', $data);
    $data = str_ireplace('ë','', $data);
    return $data;
}

/**
 * @see https://vtiger.stefanwarnat.de/vtigercrm/documentation/using-modcomments-with-webservice/
 */
function addModComment($commentcontent, $relatedToWebsId, $assignedUserId)
{
    global $current_user;
    $parameters = array();

    try {
        $parameters['commentcontent'] = $commentcontent;
        $parameters['related_to'] = $relatedToWebsId;
        $parameters['assigned_user_id'] = $assignedUserId;
        $ModComments = vtws_create('ModComments', $parameters, $current_user);
    } catch (WebServiceException $ex) {
        echo $ex->getMessage();
    }
}

veblog("Ready");

// ============================================ functions ============================================

/*
 * 
 * We can have the data (action per field):
 * if the keys exists in the mapping!
 * 1. same in both -> do nothing
 * 2. emty in crm, filled in provider data -> update data in crm
 * 3. filled in crm, empty in provider data -> do nothing
 * 4. filled in crm, filled in provider data but different -> set marking 'record change !' - need manual interaction
 *
 * @param	object	data in CRM
 * @param	object	data from DataProvider
 * @return	array	data to be updated
 */

function prepareTheData($crmdata, $providerdata)
{
    $newvalue = array();

    switch  ($crmdata['setype'] )
    {
        case 'Leads':
            $mapping = VebCompanyData_Module_Model::getMappingLead();
            break;
        case 'Accounts':
            $mapping = VebCompanyData_Module_Model::getMappingAccount();
            break;
        default:
            // no mapping
    }

/**
* @todo matching bedrijfsnaam etc op special characters
* @todo telnummer kan al in ander veld staan, evenals emailadres
*/
    $compareTable = '<hr>- '.$crmdata['setype']."\n";
    $compareTable .= "<table border=1>";
    foreach ($providerdata as $providerkey => $providerfieldvalue)
    {
        $compareTable .= "<tr>";
        if (isset($mapping[$providerkey]))
        {
            $crmkey = $mapping[$providerkey];
            $crmfieldvalue = $crmdata[$crmkey];
            $compareTable .= "<td>$providerkey</td><td>=> $providerfieldvalue</td><td>$crmkey</td><td>=> $crmfieldvalue</td>";

            if ($crmfieldvalue == $providerfieldvalue || html_entity_decode($crmfieldvalue, ENT_QUOTES) == $providerfieldvalue || $crmfieldvalue == html_entity_decode($providerfieldvalue, ENT_QUOTES) )
            {
                $compareTable .= "<td>situation 1 -> do nothing</td>";
            } elseif ($crmfieldvalue == "" && $providerfieldvalue != "")
            {
                $compareTable .= "<td>situation 2 -> update data in crm</td>";
                $newvalue[$crmkey] = $providerfieldvalue;
            } elseif ($crmfieldvalue != "" && $providerfieldvalue == "")
            {
                $compareTable .= "<td>situation 3 -> do nothing</td>";
            } elseif ($crmfieldvalue != $providerfieldvalue && strtolower($crmfieldvalue) == strtolower($providerfieldvalue))
            {
                $compareTable .= "<td>situation 4 -> do nothing capitalization is different</td>";
                //$newvalue['coda_changed_info'][] = "Skipped - $crmkey verschil in hoofletters (Dataprovider: $providerfieldvalue)"; // no need to put that in the comments
            } elseif ($crmfieldvalue != $providerfieldvalue && ($crmfieldvalue == 'Unknown' || $crmfieldvalue == 'Onbekend'))
            {
                $compareTable .= "<td>situation 5a -> update data in crm</td>";
                $newvalue[$crmkey] = $providerfieldvalue;
            } elseif (in_array($providerkey, array('contact_info_address_office_zipcode', 'contact_info_address_postal_zipcode')))
            {
                $zipcrmfieldvalue = VebCompanyData_Module_Model::formatPostalcode($crmfieldvalue);
                if ($zipcrmfieldvalue != $providerfieldvalue) {
                    $compareTable .= "<td>situation 5b -> Postalcode (formatting naar $providerfieldvalue) update data in crm</td>";
                    $newvalue[$crmkey] = $providerfieldvalue;
                } else {
                    $compareTable .= "<td>situation 5b -> Postalcode no update data in crm</td>";
                }
            } elseif (in_array($providerkey, array('contact_info_tel_number', 'contact_info_fax_number', 'contact_info_mob_number', )))
            {
                $phonecrmfieldvalue = VebCompanyData_Module_Model::formatPhone($crmfieldvalue);
                if ($phonecrmfieldvalue != $providerfieldvalue) {
                    $compareTable .= "<td>situation 5c -> Postalcode (formatting naar $providerfieldvalue) update data in crm</td>";
                    $newvalue[$crmkey] = $providerfieldvalue;
                } else {
                    $compareTable .= "<td>situation 5c -> Postalcode no update data in crm</td>";
                }
            } 
            elseif ($crmfieldvalue != $providerfieldvalue && ($crmkey == 'employees' && $crmfieldvalue == 0))
            {
                $compareTable .= "<td>situation 5d -> update data in crm</td>";
                $newvalue[$crmkey] = $providerfieldvalue;
            } elseif ($crmfieldvalue != $providerfieldvalue && in_array($crmkey, array('accountname', 'company', 'annualrevenue', 'noofemployees', 'c_tradenames', 'c_employeehistory_text', 'c_is_insolvent', 'c_kvk_nomailindicator', 'c_branchnumber', 'c_coda_legal_entity', 'c_companyactive', 'c_date_registration', 'c_date_settlement', 'c_coda_sourceid', 'c_sbi_code', 'c_sbi_description', 'c_economically_active', 'c_first_manager')))
            {
                $compareTable .= "<td>situation 5e -> update data in crm</td>";
                //$newvalue['coda_changed_info'][] = "Overschreven - KvK $crmkey van: $crmfieldvalue naar $providerfieldvalue";
                $newvalue[$crmkey] = $providerfieldvalue;
            } elseif ($crmfieldvalue != $providerfieldvalue)
            {
                $compareTable .= "<td>situation 6 -> set marking, but dont change anything</td>";
                $newvalue['c_coda_changed'] = true;
                $newvalue['coda_changed_info'][] = "Skipped - $crmkey in crm: $crmfieldvalue (DataProvider: $providerfieldvalue)";
            } else
            {
                $compareTable .= "<td>unexpected situation should never occur!</td>";
            }
        } 
        else
        {
            $compareTable .= "<td>$providerkey</td><td>=> $providerfieldvalue<td><td>=> </td>";
            $compareTable .= "<td>situation 0 -> providerkey: {$providerkey} not mapped</td>";
        }
        $compareTable .= "</tr>";
    }
    $compareTable .= "</table>";
    file_put_contents(__FILE__ . ".log.html", $compareTable, FILE_APPEND);
    return $newvalue;
}

/**
 *
 * c_coc_number may not be empty (cause we use it to look for the dossier!
 * 
 * @todo	c_companydata_block > als dat gezet is dan slaan we hem over in de controle
 * @todo	c_compdata_last_update > xx period
 * @todo	test is now limit 1, needs to be expanded later
 *
 */
function getAccounts($where = '')
{

    global $adb;

    //  Foreign dossiers cannot be found, so skip
    $oneYearOff = date('Y-m-d', strtotime(date("Y-m-d", mktime()) . " - 365 day"));
    $where .= " AND ( (DATE_FORMAT(acc.c_coda_last_update, '%Y-%m-%d') < '{$oneYearOff}' ) OR (acc.c_coda_last_update IS NULL) ) "; // date -/- update frequency
    $where .= " AND (aba.bill_country = '' OR asa.ship_country = '' OR aba.bill_country = 'Nederland' OR asa.ship_country = 'Nederland' ) ";

    $sql = "SELECT *
		FROM vtiger_account AS acc
		INNER JOIN vtiger_crmentity AS ce
		ON acc.accountid = ce.crmid
		INNER JOIN vtiger_accountbillads AS aba
		ON acc.accountid = aba.accountaddressid
		INNER JOIN vtiger_accountshipads AS asa
		ON acc.accountid = asa.accountaddressid
		WHERE ce.deleted=0
		AND (acc.c_coc_number != '' AND acc.c_coc_number IS NOT NULL)
		AND (acc.c_coda_blockupdates = '0' OR acc.c_coda_blockupdates IS NULL)
		{$where}
		ORDER BY ce.createdtime DESC LIMIT 2;";

print $sql;

    $result = $adb->pquery($sql);
//    var_dump($adb);
    $data = array();
    
    while($resultrow = $adb->fetch_array($result)) {
        $data[]=$resultrow;
    }

    return $data;
}

/**
 *
 * c_coc_number may not be empty (cause we use it to look for the dossier!
 * 
 * @todo	c_companydata_block > als dat gezet is dan slaan we hem over in de controle
 * @todo	c_compdata_last_update > xx period
 * @todo	test is now limit 1, needs to be expanded later
 *
 */
function getLeads($where = '')
{

    global $adb;

    //  Foreign dossiers cannot be found, so skip
    $oneYearOff = date('Y-m-d', strtotime(date("Y-m-d", mktime()) . " - 365 day"));
    $where .= " AND ( (DATE_FORMAT(lea.c_coda_last_update, '%Y-%m-%d') < '{$oneYearOff}' ) OR (lea.c_coda_last_update IS NULL) ) "; // date -/- update frequency
    $where .= " AND (lad.country = '' OR lad.country = 'Nederland') ";
    $where .= " AND lea.c_lead_products LIKE '%Vtiger%' ";

    $sql = "SELECT *
		FROM vtiger_leaddetails AS lea
		INNER JOIN vtiger_crmentity AS ce
		ON lea.leadid = ce.crmid
		
		INNER JOIN vtiger_leadsubdetails AS lsd
		ON lea.leadid = lsd.leadsubscriptionid
		
		INNER JOIN vtiger_leadaddress AS lad
		ON lea.leadid = lad.leadaddressid

		WHERE ce.deleted=0
		AND (lea.c_coc_number != '' AND lea.c_coc_number IS NOT NULL)
		AND (lea.c_coda_blockupdates = '0' OR lea.c_coda_blockupdates IS NULL)
		{$where}
		ORDER BY ce.createdtime DESC LIMIT 1;";

    $result = $adb->pquery($sql);
    $data = array();
    
    while($resultrow = $adb->fetch_array($result)) {
        $data[]=$resultrow;
    }

    return $data;
}

function veblog($msg){
    file_put_contents(__FILE__.'.log', date("Y-m-d H:m:i").' '.$msg."\n", FILE_APPEND);
}