<?php

namespace VebDripHandler;

class DripHandler {
  //TODO config
  private $allFilterId = 29;
  private $executingUser = 1;
  private $activeDripCampaigns = array();

  public function __construct(){
    $this->setUser();
    $this->setActiveCampaigns();
  }

  public function handleDripCampaigns(){
    foreach($this->activeDripCampaigns as $campaign){ $campaign->runDrip(); }
  }

  public function setActiveCampaigns():void {

    try {
      $pagingModel = new \Vtiger_Paging_Model;
      //TODO php_int_max doesnt seem to work
      $pagingModel->set('limit', 1000000);
      $listViewModel = \Vtiger_ListView_Model::getInstance('Campaigns', $this->allFilterId);
      $allCampaigns = $listViewModel->getListViewEntries($pagingModel);

      foreach($allCampaigns as $campaign){
        if($campaign->get('campaigntype') == 'E-mail drip' && $campaign->getRaw('campaignstatus') == 'Active'){
          $this->activeDripCampaigns[] = new Campaign($campaign);
        }
      }
    } catch (\Exception $e) {
      //TODO
    }
  }

  public function setUser(){
    $user = new \Users;
    $current_user = $user->retrieveCurrentUserInfoFromFile($this->executingUser);
    $current_user->authenticated = true;
    vglobal('current_user', $current_user);
  }
}