<?php
//TODO log directly, not at the end. Verbeter logging in general. Subscription CSU3 moet bijv error worden

namespace VebDripHandler;

class Campaign{
  private $vtigerCampaignModel;
  private $receiverTypes = array('Leads', 'Contacts');
  private $receivers = array();
  private $stages = array();

  //TODO external config
  //TODO $adb as a class property?
  private $sendFromHour = '08';
  private $sendTillHour = '20';
  private $sendFromDay = '1';
  private $sendTillDay = '5';

  private $currentReceiver;
  private $currentSubscription;
  private $newStatus;
  private $newStatusMessage;

  private $log = array();
  private $logFile = 'dripLog.txt';

  public function __construct(\Campaigns_Record_Model $campaignModel){
    $this->vtigerCampaignModel = $campaignModel;
    $this->setReceivers();
    $this->setStages();
  }

  public function runDrip():void {
    $this->log[] = 'Campaign '.$this->vtigerCampaignModel->getName();
    $this->log[] = 'Found '.count($this->receivers).' receivers';

    foreach($this->receivers as $receiver){
      try{
        $this->log[] = '--Receiver: '.$receiver->getId().'--';
        $this->currentReceiver = $receiver;
        $this->currentSubscription = $this->getSubscription();
        $this->newStatus = '';
        $this->newStatusMessage = array();
        $this->executeNextStage();
      }catch(Throwable $t){
        echo $t->getMessage();
        $this->log[] = $t->getMessage();
      }
    }
    $this->log();
    echo 'Done ';
  }

  public function executeNextStage() :void {
    $currentStatus = $this->currentSubscription->get('campaignsubscription_status');

    if($currentStatus == 'Done' || $currentStatus == 'Dropped out'){
      $this->log[] = 'Current status '.$currentStatus.', quit.';
      return;
    }
    $lastExecutedStageId = $this->currentSubscription->get('last_executed_stage');
    $this->log[] = 'Last stage: '.$lastExecutedStageId;
    $nextStage = $this->getNextStageByLastStageId($lastExecutedStageId);
    if(!$nextStage){
      $this->newStatus = 'Done';
      $this->log[] = 'No next stage found, set subscriptionstatus to Done';
      return;
    }
    $this->log[] = 'Next stage: '.$nextStage->getId();
    if(!$this->itsTime($nextStage)) return;
    $templateId = $this->getTemplateId($nextStage);
    $this->sendEmail($templateId);
    $this->updateSubscription($nextStage);
    $this->updateVtigerCampaignStatus();
   }

  public function updateSubscription(\Vtiger_Record_Model $doneStage){

    $moduleName = 'VebCampaignSubscription';
    $id = $this->currentSubscription->getId();
    $now = $this->getNow();
    $this->setNewStatus($doneStage);

    //If record is deleted, this wil NOT throw an exception. It will just stop in retrieve_entity_info
    $focus = \CRMEntity::getInstance($moduleName);
    $focus->retrieve_entity_info($id, $moduleName);
    $focus->id = $id;
    $focus->mode = 'edit';
    if($this->newStatus != 'Error') {
      $focus->column_fields['le_date'] = $now->format('Y-m-d');
      $focus->column_fields['le_time'] = $now->format('H:i:s');
      $focus->column_fields['last_executed_stage'] = $doneStage->getId();
    }
    $focus->column_fields['campaignsubscription_status'] = $this->newStatus;

    if($this->newStatus == 'Error') {
      $focus->column_fields['description'] = implode('
', $this->newStatusMessage);
    };

    //save does trigger workflows.
    $focus->save($moduleName);
  }

  public function setNewStatus(\Vtiger_Record_Model $doneStage) :void {
    if(!$this->newStatus) { $this->newStatus = $this->isLastStage($doneStage) ? 'Done' : 'Running'; }
  }

  public function updateVtigerCampaignStatus() :void {
    global $adb;

    switch ($this->currentReceiver->getModuleName()) {
      case 'Leads':
        $table = 'vtiger_campaignleadrel';
        $receiverField = 'leadid';
        break;
      case 'Contacts':
        $table = 'vtiger_campaigncontrel';
        $receiverField = 'contactid';
        break;
      case 'Accounts':
        $table = 'vtiger_campaignaccountrel';
        $receiverField = 'accountid';
        break;
      default: return;
    }

   $query = "UPDATE ".$table."
             SET campaignrelstatusid =
             (SELECT campaignrelstatusid
              FROM vtiger_campaignrelstatus
              WHERE campaignrelstatus = ?
              LIMIT 1)
             WHERE campaignid = ?
             AND ".$receiverField." = ?";
   $result = $adb->pquery($query, array($this->newStatus, $this->vtigerCampaignModel->getId(), $this->currentReceiver->getId()));
  }

  public function isLastStage(\Vtiger_Record_Model $stage) :bool {
    if($this->getLastStage() == $stage) return TRUE;
    return FALSE;
  }

  public function setReceivers():void{
    foreach($this->receiverTypes as $type){
      $this->receivers = array_merge($this->getRelatedRecords($type), $this->receivers);
   }
   //For safety mode
   //if(count($this->receivers) > 6) $this->receivers = array();
  }

  public function getRelatedRecords($entityType):iterable {
    $relationListView = \Vtiger_RelationListView_Model::getInstance($this->vtigerCampaignModel, $entityType);
    $relPageModel = new \Vtiger_Paging_Model;
    $relPageModel->set('limit', $relationListView->getRelatedEntriesCount());
    //getEntries returns array of id => Vtiger_Record_Model
    return $relationListView->getEntries($relPageModel);

  }

  public function getSubscription() :\Vtiger_Record_Model {
    global $adb;

    try{
      $query = "SELECT vebcampaignsubscriptionid
                FROM vtiger_vebcampaignsubscription, vtiger_crmentity
                WHERE vtiger_vebcampaignsubscription.vebcampaignsubscriptionid = vtiger_crmentity.crmid
                AND deleted != 1
                AND campaign = ?
                AND subscriber = ?";
      $result = $adb->pquery($query, array($this->vtigerCampaignModel->getId(), $this->currentReceiver->getId()));

      if(!$result || $result->numRows() == 0){
        $this->log[] = 'Create subscription';
        return $this->createSubscription();
      }
      if($result->numRows() == 1){
        $this->log[] = 'Subscription found';
        return \Vtiger_Record_Model::getInstanceById($adb->query_result($result, 0, 'vebcampaignsubscriptionid'), 'VebCampaignSubscription');
      }
      if($result->numRows() > 1){
        $this->log[] = 'More than one subscription found';
        //TODO deleted the one with the lowest last stage(?)
        return \Vtiger_Record_Model::getInstanceById($adb->query_result($result, 0, 'vebcampaignsubscriptionid'), 'VebCampaignSubscription');
      }
    }catch(Exception $e){
      echo $e->getMessage();
      $this->log[] = $e->getMessage();
    }
  }

  public function createSubscription() :\Vtiger_Record_Model {
    $moduleName = 'VebCampaignSubscription';
    $focus = \CRMEntity::getInstance($moduleName);
    $focus->column_fields['campaignsubscription_status'] = 'Not started';
    $focus->column_fields['campaign'] = $this->vtigerCampaignModel->getId();
    $focus->column_fields['subscriber'] = $this->currentReceiver->getId();
    //saveentity does trigger workflows.
    $focus->save($moduleName);

    return \Vtiger_Record_Model::getInstanceById($focus->id);
  }

  public function setStages():void {
    $relationListView = \Vtiger_RelationListView_Model::getInstance($this->vtigerCampaignModel, 'VebCampaignStage');
    $relPageModel = new \Vtiger_Paging_Model;
    $relPageModel->set('limit', $relationListView->getRelatedEntriesCount());
    //getEntries returns array of id => Vtiger_Record_Model
    $stages = $relationListView->getEntries($relPageModel);
    uasort($stages, array($this,'sortStages'));
    $this->stages = $stages;
  }

  public function sortStages($stageA, $stageB) :int {
    $order = $stageA->get('sequence') <=> $stageB->get('sequence');
    //If two or more stages have the same sequence, than place the highest id last
    if ($order == 0) return $stageA->getId() <=> $stageB->getId();
    return $order;
  }

  public function getNextStageByLastStageId(int $lastStageId):? \Vtiger_Record_Model {
    if(!$lastStageId) return $this->getFirstStage();

    //getNext in array
    $nextStageIsTheOne = FALSE;
    foreach($this->stages as $stageId => $stage){
      if($nextStageIsTheOne == TRUE){
        $this->log[] = 'Next stage: '.$stage->getId();
        return $stage;
      }
      if($stageId == $lastStageId) { $nextStageIsTheOne = TRUE; }
    }
    return NULL;
  }

  public function getFirstStage():? \Vtiger_Record_Model{
    if(!$this->stages) return NULL;
    return (reset($this->stages));
  }

  public function getLastStage():? \Vtiger_Record_Model{
    if(!$this->stages) return NULL;
    return (end($this->stages));
  }

  public function itsTime(\Vtiger_Record_Model $stage) :bool {
    $now = $this->getNow();

    //Send only during daytime
    //TODO place these restrictions in general driphandler
    //TODO not on a public holiday?
    if($now->format('H') < $this->sendFromHour || $now->format('H') > $this->sendTillHour){
      $this->log[] = 'Not sending, only send during daytime';
      return FALSE;
    }
    //Send not in the weekend
    if($now->format('w') < $this->sendFromDay || $now->format('w') > $this->sendTillDay){
      $this->log[] = 'Not sending, only send during weekdays';
      return FALSE;
    }

    //Aparently, we dont have to deal with user settings here.
    $timeLastStageExecuted = \DateTime::createFromFormat('Y-m-d H:i:s', $this->currentSubscription->get('le_date').' '.$this->currentSubscription->get('le_time'), new \DateTimeZone('Europe/Amsterdam'));

    if(!$timeLastStageExecuted){
      $this->log[] = 'No date last stage executed found. Continue with next stage.';
      return TRUE;
    }
    //TODO add() could return FALSE on failure
    $timeThisStageShouldExecute = clone $timeLastStageExecuted;
    $timeThisStageShouldExecute->add(new \DateInterval('PT'.(int) $stage->get('hoursafter').'H'));

    if($timeThisStageShouldExecute < $now){
      $this->log[] = 'Time to execute!';
      return TRUE;
    }
    $this->log[] = 'No time to execute yet.';
    return FALSE;
  }

  public function getNow() :? \DateTime {
    //TODO centralize timezone
    $timeZone = new \DateTimeZone('Europe/Amsterdam');
    $now = new \DateTime('now', $timeZone);

    //Because of server time diff
   // $offset = $timeZone->getOffset($now) / 3600;
    //$now->add(new \DateInterval('PT'.$offset.'H'));
    if(!$now){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'DateTime issue. '.implode(' ',\DateTime::getLastErrors());
      return void;
    }
    return $now;
  }

  public function getTemplateId(\Vtiger_Record_Model $stage) :int {
    //TODO why not working?
    //$templateId = $stage->get('template_for_'.strtolower($receiver->getModuleName()));
    global $adb;

    $field = 'template_for_'.strtolower($this->currentReceiver->getModuleName());
    $query = "SELECT ".$field." FROM vtiger_vebcampaignstage WHERE vebcampaignstageid = ?";
    $result = $adb->pquery($query, array($stage->getId()));
    if(!$result || !$result->NumRows()){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'Template not found for stage '.$stage->getId();
      $this->log[] = 'Template not found for stage '.$stage->getId();
      return 0;
    }
    return $templateId = $adb->query_result($result, 0, $field);
  }

  public function getAssignedUserId():int {
    global $adb;

    $userId = $this->currentReceiver->get('assigned_user_id');
    /*
    if(!$userId){
      $query = "SELECT smownerid FROM vtiger_crmentity WHERE crmid = ?";
      $result = $adb->pquery($query, array($this->currentReceiver->getId()));
      $userId = $adb->query_result($result, 0, 'smownerid');
    }
    */
    if($this->isAUser($userId)){
      return $userId;
    }
     return 1;
  }

  public function isAUser(int $id):bool{
    $recordModel = \Vtiger_Record_Model::getInstanceById($id, 'Users');
    if(strlen($recordModel->getName()) > 1) return TRUE;
    return FALSE;
  }

  public function sendEmail(int $templateId) :void {
    global $adb;
    global $current_user;

    $oldUser = $current_user;
    //TODO make possible to send from configured user
    $assignedUserId = $this->getAssignedUserId();
    $this->setUser($assignedUserId);

    if(!$templateId){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'Template not found.';
      $this->log[] = 'No templateId.';
      return;
    }

    //TODO lead and contact both have field email, but what a new module doesn't?
    $emailAddress = filter_var($this->currentReceiver->get('email'), FILTER_VALIDATE_EMAIL);

    if(!$emailAddress){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'No e-mailaddress for '.$this->currentReceiver->getDisplayName().'.';
      $this->log[] = $this->currentReceiver->getDisplayName().' does not have correct e-mailaddress.';
      return;
    }

    //Get templateinfo
    //If a template is deleted, it will not be in vtiger_emailtemplates anymore
    $query = 'SELECT subject, body, templatename, module
                FROM vtiger_emailtemplates
                WHERE templateid = ?';

    $result = $adb->pquery($query, array($templateId));
    if(!$result || !$result->NumRows()){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'Template not found';
      $this->log[] = 'Template not found';
      return;
    }
    if($result->NumRows() > 1){
      $this->log[] = 'More than one template found! Take the first.';
    }
    $body = decode_html($adb->query_result($result, 0, 'body'));
    $subject = decode_html($adb->query_result($result, 0, 'subject'));
    $templatename = decode_html($adb->query_result($result, 0, 'templatename'));
    $signature = 'Yes';
    $templateModule = decode_html($adb->query_result($result, 0, 'module'));

    if($templateModule != $this->currentReceiver->getModuleName()){
      $this->newStatus = 'Error';
      $this->newStatusMessage[] = 'Template is not for '.$this->currentReceiver->getModuleName().'.';
      $this->log[] = 'Template is not for '.$this->currentReceiver->getModuleName().'.';
      return;
    }

    //Build e-mail
    try{
      $recordModel = \Vtiger_Record_Model::getCleanInstance('Emails');
      $recordModel->set('mode', '');
      $recordModel->set('description', $body);
      $recordModel->set('subject', $subject);
      $recordModel->set('saved_toid', $emailAddress);
      $recordModel->set('ccmail', array());
      $recordModel->set('bccmail', array());
      $recordModel->set('assigned_user_id', $assignedUserId);
      $recordModel->set('email_flag', 'SENT');
      $recordModel->set('signature' , $signature);

      //Fill the required array (dont know why, just need to be filled). See modules\Emails\models\Record.php aprox line 122
      $toemailinfo = array();
      $toemailinfo[$this->currentReceiver->getId()] = array($emailAddress);
      $recordModel->set('toemailinfo' , $toemailinfo);

      $parentIds = $this->currentReceiver->getId() . '@1|';
      $recordModel->set('parent_id', $parentIds);

      //TODO Save_module still depends on the $_REQUEST, need to clean it up
      $_REQUEST['parent_id'] = $parentIds;
      //TODO not standard!!
      $_REQUEST['tkstempid'] = $templateId;
      $_REQUEST['tkstempname'] = $templatename;

      //Save the record - gets the id for email tracking (if enabled)
      $recordModel->save();

      $status = $recordModel->send();

      //This is needed to set vtiger_email_track table as it is used in email reporting
      if ($status === TRUE){
        $recordModel->setAccessCountValue();
        $this->log[] = 'E-mail sent';
      }
      if ($status === FALSE){
        $this->newStatus = 'Error';
        $this->newStatusMessage[] = 'Sending e-mail did not succeed!';
        $this->log[] = 'Sending e-mail did not succeed.'.print_r($recordModel, TRUE);
        return;
      }
    }catch(Exception $e){
      $this->log[] = $e->getMessage();
    }
    vglobal('current_user', $oldUser);
  }

  public function setUser($userId) :void {
    global $current_user;

    $user = new \Users;
    $current_user = $user->retrieveCurrentUserInfoFromFile($userId);
    $current_user->authenticated = true;
    vglobal('current_user', $current_user);
  }

  public function log() :void {
     $now = $this->getNow();
     file_put_contents($this->logFile, "\n".print_r($now->format('== Ydm H:i:s =='), true)."\n", FILE_APPEND);
     file_put_contents($this->logFile, print_r(implode("\n", $this->log), true)."\n", FILE_APPEND);
  }

}