<?php

/**
 * script to calculate scores
 * 
 * @package	WebVisitAnalyser
 * @author	l.roovers
 * @version	12 feb 2017
 *
 * Version 3 feb 2016
 * - added query to get all Webvisits related to Accounts
 * - removed some debugging leftovers
 * - reduced errorreporting level
 *
 * version 12 feb 2017
 * - caching added, no duplicate queries are called
 * - reset all dates to NULL first (so we are sure to remove all wrong values, even if visits here removed)
 * - check for resulting 0000-00-00 and change that to NULL
 * - only write date (no more time) preparing for removing the uitype 1000
 * - shortRun can be started with cli param (--mode=shortrun) shortRun (or ?mode=shortrun
 *
 * @todo	use script from WebVisitAnalyser must be part of crm/vtiger or do this via the api!
 * @todo	add other modules (Contacts) to the update query
 */
ini_set("include_path", "../");
ini_set('memory_limit', '-1');
set_time_limit(0);

chdir( dirname(__FILE__) );

require_once('config.php');
require_once('include/utils/utils.php');

error_reporting(E_ALL & ~E_NOTICE);

// Klanten
$accounts = getAccounts(" account_type IN ('Klant', 'Ind-Klant') ");
$run = update($accounts, " sales_stage IN ('Project in Uitvoering', 'Project Afgeleverd', 'Won') ");

// Prospects
$accounts = getAccounts(" account_type NOT IN ('Klant', 'Ind-Klant') ");
$run = update($accounts, " sales_stage NOT IN ('Project in Uitvoering', 'Project Afgeleverd', 'Won') ");

echo 'done';

function getAccounts($where)
{
  global $adb;
  
  $sql = "SELECT *
        FROM vtiger_account AS acc
        INNER JOIN vtiger_crmentity AS ce
        ON acc.accountid = ce.crmid
        WHERE ce.deleted=0
        AND ( {$where} )
        ;";
          
  $accounts = $adb->pquery($sql);
  
  if ($accounts === FALSE) {
    print "<li>EMPTY accounts from query!";
    var_dump($adb);
    die();
  }
  return $accounts;
}

function update($accounts, $where)
{
  global $adb;
  
  $rows = $adb->num_rows($accounts);
  
  echo "<br>\n- #accounts: {$rows}\n";
  echo "<br>\n- accounts: {$where}: \n";
  
  for($i=0; $i<$rows; $i++)
  {
  
    $accountid = $adb->query_result($accounts, $i, 'accountid');
  
    echo " - {$accountid}";
    // 
    // find related potentials
    $sql2 = "SELECT c_lead_solutions, c_lead_products
        FROM vtiger_potential AS pot
        INNER JOIN vtiger_crmentity AS ce
        ON pot.potentialid = ce.crmid
        WHERE ce.deleted=0
        AND ( {$where} )
        AND related_to = {$accountid}
        ";
  
    $pots = $adb->pquery($sql2);
    $rows2 = $adb->num_rows($pots);
  
    //echo "<br>--- potentials: {$rows2}\n";
    // echo "-{$rows2}-";
  
    $prodsol = '';
    $prodsol2 = array();
    
    for($i2=0; $i2<$rows2; $i2++)
    {
      // $output = $adb->query_result_rowdata($pots, 0);
      // print_r($output);
  
      $solutions = $adb->query_result($pots, $i2, 'c_lead_solutions');
      $prodsol .= str_replace(" |##| ",",", $solutions).',';
  
      $products = $adb->query_result($pots, $i2, 'c_lead_products');
      $prodsol  .= str_replace(" |##| ",",", $products).',';
    }
  
    // update in account kaart veld:   
    $prodsol = trim($prodsol,',');
    $prodsol2 = array_unique(explode(',', $prodsol));
    asort($prodsol2);
    foreach($prodsol2 as $id => $sol) {
      if ($sol == '') {
        unset($prodsol2[$id]);
      }
    }
    
    $sql3 = "UPDATE vtiger_accountscf SET `cf_1647` = '".implode(', ', $prodsol2) . "' WHERE accountid = {$accountid};";
    
    $adb->pquery( $sql3 );
    
    //echo '--- '.$sql3;
  //  var_dump($adb);
  }
}