<?php
/* +***********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 * *********************************************************************************** */

class PDFMaker_PayBySquare_Helper extends Vtiger_Base_Model
{
    public $paymentParams = array(
        'iban',
        'amount',
        'currency',
        'vs',
        'ss',
        'cs',
        'note',
        'due_date',
        'swift',
        'size',
    );

    public static function getInstance($iban = '', $amount = '')
    {
        $self = new self();
        $self->setIBAN($iban);
        $self->setAmount($amount);
        $self->set('size', 200);
        $self->set('currency', 'EUR');

        return $self;
    }

    public function convertFromArray($data)
    {
        foreach ($data as $key => $value) {
            if (in_array($key, $this->paymentParams)) {
                $this->set($key, $value);
            }
        }
    }

    public function setIBAN($value)
    {
        $this->set('iban', $value);
    }

    public function setAmount($value)
    {
        $this->set('amount', $value);
    }

    public function getImage($qrGeneratorSk = false)
    {
        if (!$qrGeneratorSk) {
            $link = $this->getLink();
        } else {
            $link = $this->getQRGeneratorLink();
        }

        return sprintf('<img width="%s" src="%s" alt="payBySquare">', $this->getSize(), $link);
    }

    public function getLink()
    {
        $data = array(
            'iban' => $this->getIBAN(),
            'amount' => $this->getAmount(),
            'currency' => $this->getCurrency(),
            'vs' => $this->getVariableSymbol(),
            'ss' => $this->getSpecialSymbol(),
            'cs' => $this->getConstantSymbol(),
            'note' => $this->getNote(),
            'due_date' => $this->getDueDate(),
            'swift' => $this->getSwift(),
        );

        return sprintf('https://its4you.sk/en/api/app/pay?%s',
            http_build_query($data, '', '&amp;')
        );
    }

    public function getIBAN()
    {
        return $this->get('iban');
    }

    public function getAmount()
    {
        return $this->get('amount');
    }

    public function getCurrency()
    {
        return $this->get('currency');
    }

    public function getVariableSymbol()
    {
        return $this->get('vs');
    }

    public function getSpecialSymbol()
    {
        return $this->get('ss');
    }

    public function getConstantSymbol()
    {
        return $this->get('cs');
    }

    public function getNote()
    {
        return $this->get('note');
    }

    public function getDueDate()
    {
        return $this->get('due_date');
    }

    public function getSwift()
    {
        return $this->get('swift');
    }

    /**
     * https://www.qrgenerator.sk/
     * @return string
     */
    public function getQRGeneratorLink()
    {
        $data = array(
            'iban' => $this->getIBAN(),
            'amount' => $this->getAmount(),
            'currency' => $this->getCurrency(),
            'vs' => $this->getVariableSymbol(),
            'ss' => $this->getSpecialSymbol(),
            'cs' => $this->getConstantSymbol(),
            'payment_note' => $this->getNote(),
            'due_date' => $this->getDueDate(),
        );

        return sprintf('https://api.QRGenerator.sk/by-square/pay/qr.png?%s',
            http_build_query($data, '', '&amp;')
        );
    }

    public function getSize()
    {
        return $this->get('size');
    }
}