<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

Class CTMobileSettings_ManualSync_View extends Settings_Vtiger_Index_View {

    public function process(Vtiger_Request $request) {
        global $adb;
        $viewer = $this->getViewer ($request);
        $module = $request->getModule();
        $mode = $request->get('mode');

        if($mode == 'fieldMapping'){
            $sourcemodule = $request->get('search_module');
            $moduleModel = Vtiger_Module_Model::getInstance($sourcemodule);
            $recordStructureInstance = Vtiger_RecordStructure_Model::getInstanceForModule($moduleModel);
            $recordStructure = $recordStructureInstance->getStructure();
            $refrenceUitypes = array(10,51,57,58,59,66,73,75,76,78,80,81,101,53,5,6,23,70);
            $viewer->assign('RECORD_STRUCTURE', $recordStructure);
            $viewer->assign('SKIPUITYPES', $refrenceUitypes);
            $viewer->assign('SOURCE_MODULE', $sourcemodule);
            $viewer->view('getSyncFieldMappingData.tpl', $module);

        }else if($mode == 'genarateCSVFile'){
            $columnslist = $request->get('columns');
            
            $csv ="";
            foreach ($columnslist as $field){
                $csv .= $field.',';
            }
            $csv .= "latitude,longitude\n";
            $csv_handler = fopen ('layouts/v7/modules/CTMobileSettings/sample.csv','w');
            fwrite ($csv_handler,$csv);
            fclose ($csv_handler);  

        }else if($mode == 'showImportStatus'){
            $totalScannedRows  = $request->get('totalScannedRows');
            $totalAffectedRows  = $request->get('totalAffectedRows');
            $totalCreatedRows  = $request->get('totalCreatedRows');
            $totalUpdatedRows  = $request->get('totalUpdatedRows');
            $totalSkippedRows  = $totalScannedRows - $totalAffectedRows;

            $viewer->assign('MODULE', 'CTMobileSettings');

            $viewer->assign('totalScannedRows', $totalScannedRows);
            $viewer->assign('totalAffectedRows', $totalAffectedRows);
            $viewer->assign('totalCreatedRows', $totalCreatedRows);
            $viewer->assign('totalUpdatedRows', $totalUpdatedRows);
            $viewer->assign('totalSkippedRows', $totalSkippedRows);

            $viewer->view('ImportStatus.tpl', 'CTMobileSettings');
        }else{

            /* module list */
            $allModules = Vtiger_Module_Model::getSearchableModules();
            $AddressModules =  array("Contacts","Leads","Accounts","Calendar","Events");
            foreach($allModules as $key => $value){
                if(in_array($key,$AddressModules)){
                    $allModule[$key] = $value;
                }
            }

            $viewer->assign('ALL_MODULE', array_keys($allModule));
            $viewer->assign('SOURCE_MODULE', $moduleName);
            echo $viewer->view('ManualSync.tpl', $module, true);
        }
        
    }
    function getHeaderScripts(Vtiger_Request $request) {
        $headerScriptInstances = parent::getHeaderScripts($request);
        $moduleName = $request->getModule();

        $jsFileNames = array(
            "modules.CTMobileSettings.resources.ManualSync"
            
        );

        $jsScriptInstances = $this->checkAndConvertJsScripts($jsFileNames);
        $headerScriptInstances = array_merge($headerScriptInstances, $jsScriptInstances);
        return $headerScriptInstances;
    }
}
