 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
jQuery.Class("CTMobileSettings_ManualSync_Js",{
    editInstance:false,
    getInstance: function(){
        if(CTMobileSettings_Settings_Js.editInstance == false){
            var instance = new CTMobileSettings_Settings_Js();
            CTMobileSettings_Settings_Js.editInstance = instance;
            return instance;
        }
        return CTMobileSettings_Settings_Js.editInstance;
    }
},{
    
    registerImportFile:function() {
       
        jQuery("#filename").on("change", function(e) {
          var fp = $("#filename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFileDetails #uploadedFileName").text(name);
        });
        jQuery("#fieldfilename").on("change", function(e) {
          var fp = $("#fieldfilename");
          var lg = fp[0].files.length;
          var items = fp[0].files;
          var name = items[0].name;
          $(".uploadedFieldFileDetails #uploadedFieldFileName").text(name);
        });
        jQuery("#uploadForm").on("submit", function(e) {
            var fp = $("#filename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              app.helper.showProgress();
              app.request.post(params).then(function(e,res) {
                app.helper.hideProgress();
                if(res['success']){
                   app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});

                }else{
                    app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              app.helper.showErrorNotification({
                'message' : app.vtranslate('JS_PLEASE_SELECT_A_FILE')
              });
              return false;
            }
        });
        jQuery("#uploadEntityForm").on("submit", function(e) {
            var fp = jQuery("#fieldfilename");
            var lg = fp[0].files.length;
            if(lg > 0){
              e.preventDefault();
              var formData = new FormData(this);
              
              var params = {
                url: "index.php",
                type: "POST",
                data: formData,
                processData: false,
                contentType: false
              };
              app.helper.showProgress();
              app.request.post(params).then(function(e,res) {
                app.helper.hideProgress();
                if(res.success){
                   jQuery('#uploadEntityForm').reset();
                   var popup_params = {
                      "module": 'CTMobileSettings',
                      "view": 'ManualSync',
                      "mode":'showImportStatus',
                      "totalAffectedRows": res.totalAffectedRows,
                      "totalCreatedRows": res.totalCreatedRows,
                      "totalScannedRows": res.totalScannedRows,
                      "totalUpdatedRows": res.totalUpdatedRows
                  }
                   var popupInstance = Vtiger_Popup_Js.getInstance();
                   popupInstance.showPopup(popup_params);
                   //app.helper.showSuccessNotification({'message' : app.vtranslate('JS_UPLOAD_SUCCESSFUL')});
                   //location.reload();
                }else{
                    app.helper.showErrorNotification({'message' : res['msg'] });
                }
              });
            }else{
              app.helper.showErrorNotification({
                'message' : app.vtranslate('JS_PLEASE_SELECT_A_FILE')
              });
              return false;
            }
        });
    },

    //hide and show file and field selection
    registerSelectChangeEvent : function(){
        jQuery("#search_module").on("change", function(e) {
          var modulename = $('#search_module').val();
          
          if(modulename != "")
            $('.contentBlock').show();
          else
            $('.contentBlock').hide();
        });
        jQuery("#entity_search_module").on("change", function(e) {

          var progressIndicatorElement = jQuery.progressIndicator({
            'position' : 'html',
            'blockInfo' : {
             'enabled' : true
            }
          });
          var modulename = $('#entity_search_module').val();
          var selectedFields=jQuery("#uploadEntityForm").find("#fieldMappingData");
          if(modulename != ""){
            $('#fieldMappingData').show();
            var params= {
                "module" : "CTMobileSettings",
                "view" :"ManualSync",
                "search_module" : modulename,
                "mode" : "fieldMapping",
                "data" : {}
            };
            AppConnector.request(params).then(
                function(data) {
                    
                    progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                    selectedFields.html(data.result);
                    app.changeSelectElementView(selectedFields);
                    app.showSelect2ElementView(selectedFields.find('select.select2'));
                }
            )
          }else{
            $('#fieldMappingData').hide();
            progressIndicatorElement.progressIndicator({'mode' : 'hide'});
                selectedFields.html('');
            $('.entityContentBlock').hide();
          }
        });

        //change event of field selection
        jQuery("#search_field_module").live("change", function(e) {
          var modulefields = $('#search_field_module').val();

          if(modulefields == null){
            $('.entityContentBlock').hide();
          }else{
            $('.entityContentBlock').show();
            var params = {
                "module" : "CTMobileSettings",
                "view" :"ManualSync",
                "mode" : "genarateCSVFile",
                "columns" : modulefields
               
            };
            app.helper.showProgress();
            app.request.post({data: params}).then(function (err, res) {
                app.helper.hideProgress();
                
            });
          }
        });


    },

    registerAppTriggerEvent : function() {
        jQuery('.app-menu').removeClass('hide');
        var toggleAppMenu = function(type) {
            var appMenu = jQuery('.app-menu');
            var appNav = jQuery('.app-nav');
            appMenu.appendTo('#page');
            appMenu.css({
                'top' : appNav.offset().top + appNav.height(),
                'left' : 0
            });
            if(typeof type === 'undefined') {
                type = appMenu.is(':hidden') ? 'show' : 'hide';
            }
            if(type == 'show') {
                appMenu.show(200, function() {});
            } else {
                appMenu.hide(200, function() {});
            }
        };

        jQuery('.app-trigger, .app-icon, .app-navigator').on('click',function(e){
            e.stopPropagation();
            toggleAppMenu();
        });

        jQuery('html').on('click', function() {
            toggleAppMenu('hide');
        });

        jQuery(document).keyup(function (e) {
            if (e.keyCode == 27) {
                if(!jQuery('.app-menu').is(':hidden')) {
                    toggleAppMenu('hide');
                }
            }
        });

        jQuery('.app-modules-dropdown-container').hover(function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            jQuery('.dropdown').removeClass('open');
            if(dropdownContainer.length) {
                if(dropdownContainer.hasClass('dropdown-compact')) {
                    dropdownContainer.find('.app-modules-dropdown').css('top', dropdownContainer.position().top - 8);
                } else {
                    dropdownContainer.find('.app-modules-dropdown').css('top', '');
                }
                dropdownContainer.addClass('open').find('.app-item').addClass('active-app-item');
            }
        }, function(e) {
            var dropdownContainer = jQuery(e.currentTarget);
            dropdownContainer.find('.app-item').removeClass('active-app-item');
            setTimeout(function() {
                if(dropdownContainer.find('.app-modules-dropdown').length && !dropdownContainer.find('.app-modules-dropdown').is(':hover') && !dropdownContainer.is(':hover')) {
                    dropdownContainer.removeClass('open');
                }
            }, 500);

        });

        jQuery('.app-item').on('click', function() {
            var url = jQuery(this).data('defaultUrl');
            if(url) {
                window.location.href = url;
            }
        });

        jQuery(window).resize(function() {
            jQuery(".app-modules-dropdown").mCustomScrollbar("destroy");
            app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
                setHeight: $(window).height(),
                autoExpandScrollbar: true
            });
            jQuery('.dropdown-modules-compact').each(function() {
                var element = jQuery(this);
                var heightPer = parseFloat(element.data('height'));
                app.helper.showVerticalScroll(element, {
                    setHeight: $(window).height()*heightPer - 3,
                    autoExpandScrollbar: true,
                    scrollbarPosition: 'outside'
                });
            });
        });
        app.helper.showVerticalScroll(jQuery(".app-modules-dropdown").not('.dropdown-modules-compact'), {
            setHeight: $(window).height(),
            autoExpandScrollbar: true,
            scrollbarPosition: 'outside'
        });
        jQuery('.dropdown-modules-compact').each(function() {
            var element = jQuery(this);
            var heightPer = parseFloat(element.data('height'));
            app.helper.showVerticalScroll(element, {
                setHeight: $(window).height()*heightPer - 3,
                autoExpandScrollbar: true,
                scrollbarPosition: 'outside'
            });
        });
    },

    /**
     * Function which will handle the registrations for the elements
     */
    registerEvents : function() {
        $('.contentBlock').hide();
        $('.entityContentBlock').hide();
        this.registerImportFile();
        this.registerSelectChangeEvent();
        this.registerAppTriggerEvent();
    }
});


jQuery(document).ready(function () {
    var instance = new CTMobileSettings_ManualSync_Js();
    instance.registerEvents();

});
