<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/models/Alert.php';
include_once dirname(__FILE__) . '/models/SearchFilter.php';
include_once dirname(__FILE__) . '/models/Paging.php';

class CTMobile_WS_ListRecordComment extends CTMobile_WS_Controller {
	
	
	function getSearchFilterModel($module, $search) {
		return CTMobile_WS_SearchFilterModel::modelWithCriterias($module, Zend_JSON::decode($search));
	}
	
	function getPagingModel(CTMobile_API_Request $request) {
		$page = $request->get('page', 0);
		return CTMobile_WS_PagingModel::modelWithPageStart($page);
	}
	
	function process(CTMobile_API_Request $request) {
		global $current_user,$adb, $site_URL;
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		$record = trim($request->get('record'));
		if(empty($record)){
			$message = vtranslate('Required fields not found','CTMobile');
			throw new WebServiceException(404,$message);
		}
		$index = trim($request->get('index'));
		$size = trim($request->get('size'));
		$limit = ($index*$size) - $size;
		
		$query = "SELECT vtiger_modcomments.*, vtiger_crmentity.createdtime, vtiger_crmentity.smownerid from vtiger_modcomments INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_modcomments.modcommentsid where vtiger_crmentity.deleted = 0 and vtiger_modcomments.related_to = ? ORDER BY vtiger_modcomments.modcommentsid DESC";
		if(!empty($index) && !empty($size)){
			$query .= sprintf(" LIMIT %s, %s", $limit, $size);
		}
		$getCommentQuery = $adb->pquery($query, array($record));
		$countComment = $adb->num_rows($getCommentQuery);
		
		$modcommentsData = array();
		for($i=0;$i<$countComment;$i++) {
			$modcommentId = $adb->query_result($getCommentQuery, $i, 'modcommentsid');
			$commentcontent = $adb->query_result($getCommentQuery, $i, 'commentcontent');
			$commentcontent = html_entity_decode($commentcontent, ENT_QUOTES, $default_charset);																										
			$relatedTo = $adb->query_result($getCommentQuery, $i, 'related_to');
			$fileid = $adb->query_result($getCommentQuery, $i, 'filename');
			$filename = "";
			$file_URL = "";
			$fileAccess =  true;
			$AccessMessage = "";
			if($fileid != '' && $fileid != 0){
				$fileDetails = $this->getAttachments($fileid,$modcommentId);
				$filename = $fileDetails['filename'];
				$file_URL = $fileDetails['file_URL'];
				if(file_get_contents($file_URL) == ""){
					$fileAccess = false;
					$AccessMessage = vtranslate("You don't have permission to access this resource",'CTMobile');
				}
			}
			
			$userId = $adb->query_result($getCommentQuery, $i, 'smownerid');
			$createdtime = $adb->query_result($getCommentQuery, $i, 'createdtime');
			$commentedtime = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
			
			if($userId) {
				$userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');
				$firstname = $userRecordModel->get('first_name');
				$firstname = html_entity_decode($firstname, ENT_QUOTES, $default_charset);
				$lastname = $userRecordModel->get('last_name');
				$lastname = html_entity_decode($lastname, ENT_QUOTES, $default_charset);
			}
			$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId('ModComments');
			$modcommentsData[] = array('modcommentId'=>$moduleWSId.'x'.$modcommentId, 'commentcontent'=>$commentcontent, 'relatedTo' => $relatedTo, 'userid'=>$userId,'filename'=>$filename,'file_URL'=>$file_URL,'fileAccess'=>$fileAccess,'AccessMessage'=>$AccessMessage,'userName'=>$firstname." ".$lastname, 'createdtime'=>$createdtime,'ModifiedTime'=>$commentedtime);
		}
		$response = new CTMobile_API_Response();
		if(count($modcommentsData) == 0){
			$response->setResult(array('record'=>array(),'code'=>404,'message'=>vtranslate('LBL_NO_RECORDS_FOUND','Vtiger')));
		}else{
			$response->setResult(array('record'=>$modcommentsData,'message'=>''));
		}
		return $response;
	}
	
	public function getDisplayValue($value) {
		$dateValue = '--';

		if ($value != '') {
			$date = new DateTimeField($value);
			$dateTimeValue = $date->getDisplayDateTimeValue();;
			list($startDate, $startTime) = explode(' ', $dateTimeValue);

			$currentUser = Users_Record_Model::getCurrentUserModel();
			if ($currentUser->get('hour_format') == '12') {
				$startTime = Vtiger_Time_UIType::getTimeValueInAMorPM($startTime);
			}

			$dateValue = "$startDate $startTime";
		}
		return $dateValue;
	}

	public function getAttachments($fileid,$modcommentsid){
		global $adb,$site_URL;
		$query = "SELECT * FROM vtiger_attachments INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_attachments.attachmentsid INNER JOIN vtiger_seattachmentsrel ON vtiger_seattachmentsrel.attachmentsid = vtiger_attachments.attachmentsid WHERE vtiger_crmentity.deleted = 0 AND vtiger_attachments.attachmentsid = ? AND vtiger_seattachmentsrel.crmid = ?";
		$params = array($fileid,$modcommentsid);
		$result = $adb->pquery($query,$params);
		$data['file_URL'] = "";
		$data['filename'] = "";
		if($adb->num_rows($result) > 0){
			$name = $adb->query_result($result,0,'name');
			$path = $adb->query_result($result,0,'path');
			$data['file_URL'] = $site_URL.$path.$fileid.'_'.$name;
			$data['filename'] = $name;
		}
		return $data;
	}
}
