<?php
/*+**********************************************************************************
 * The contents of this file are subject to the vtiger CRM Public License Version 1.0
 * ("License"); You may not use this file except in compliance with the License
 * The Original Code is:  vtiger CRM Open Source
 * The Initial Developer of the Original Code is vtiger.
 * Portions created by vtiger are Copyright (C) vtiger.
 * All Rights Reserved.
 ************************************************************************************/

include_once 'modules/Vtiger/CRMEntity.php';

class WebLocationSources extends Vtiger_CRMEntity {
	var $table_name = 'vtiger_weblocationsources';
	var $table_index= 'weblocationsourcesid';

	/**
	 * Mandatory table for supporting custom fields.
	 */
	var $customFieldTable = Array('vtiger_weblocationsourcescf', 'weblocationsourcesid');

	/**
	 * Mandatory for Saving, Include tables related to this module.
	 */
	var $tab_name = Array('vtiger_crmentity', 'vtiger_weblocationsources', 'vtiger_weblocationsourcescf');

	/**
	 * Mandatory for Saving, Include tablename and tablekey columnname here.
	 */
	var $tab_name_index = Array(
		'vtiger_crmentity' => 'crmid',
		'vtiger_weblocationsources' => 'weblocationsourcesid',
		'vtiger_weblocationsourcescf'=>'weblocationsourcesid');

	/**
	 * Mandatory for Listing (Related listview)
	 */
	var $list_fields = Array (
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Web Source Location No' => Array('weblocationsources', 'weblocationsource_no'),
		'Assigned To' => Array('crmentity','smownerid')
	);
	var $list_fields_name = Array (
		/* Format: Field Label => fieldname */
		'Web Source Location No' => 'weblocationsource_no',
		'Assigned To' => 'assigned_user_id',
	);

	// Make the field link to detail view
	var $list_link_field = 'weblocationsource_no';

	// For Popup listview and UI type support
	var $search_fields = Array(
		/* Format: Field Label => Array(tablename, columnname) */
		// tablename should not have prefix 'vtiger_'
		'Web Location No' => Array('weblocationsources', 'weblocationsource_no'),
		'Assigned To' => Array('vtiger_crmentity','assigned_user_id'),
	);
	var $search_fields_name = Array (
		/* Format: Field Label => fieldname */
		'Web Location No' => 'weblocationsource_no',
		'Assigned To' => 'assigned_user_id',
	);

	// For Popup window record selection
	var $popup_fields = Array ('weblocationsource_no');

	// For Alphabetical search
	var $def_basicsearch_col = 'weblocationsource_no';

	// Column value to use on detail view record text display
	var $def_detailview_recname = 'weblocationsource_no';

	// Used when enabling/disabling the mandatory fields for the module.
	// Refers to vtiger_field.fieldname values.
	var $mandatory_fields = Array('weblocationsource_no','assigned_user_id');

	var $default_order_by = 'weblocationsource_no';
	var $default_sort_order='ASC';

	/**
	* Invoked when special actions are performed on the module.
	* @param String Module name
	* @param String Event Type
	*/
	function vtlib_handler($moduleName, $eventType) {
		global $adb;
 		if($eventType == 'module.postinstall') {
		WebLocationSources::setWSEntity();
			// TODO Handle actions after this module is installed.
		} else if($eventType == 'module.disabled') {
			// TODO Handle actions before this module is being uninstalled.
		} else if($eventType == 'module.preuninstall') {
			// TODO Handle actions when this module is about to be deleted.
		} else if($eventType == 'module.preupdate') {
			// TODO Handle actions before this module is updated.
		} else if($eventType == 'module.postupdate') {
			// TODO Handle actions after this module is updated.
		}
 	}
	static function setWSEntity() {
		global $log;
		$log->debug("Entering setWSEntity() method....");
		global $adb;
		
		$query = "SELECT name FROM vtiger_ws_entity WHERE name=?";
		$result = $adb->pquery($query,array("WebLocationSources"));
		$norows = $adb->num_rows($result);
		if($norows==0)
		{		 
			$qry = "INSERT INTO vtiger_ws_entity (name, handler_path, handler_class, ismodule) 
					VALUES ('WebLocationSources', 'include/Webservices/VtigerModuleOperation.php', 'VtigerModuleOperation', '1')";
			$res = $adb->pquery($qry,array());
		}
		
		$log->debug("Exiting setWSEntity() method....");					
	}
}