<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_SaveRoute extends CTMobile_WS_Controller {
	protected $recordValues = false;
	function process(CTMobile_API_Request $request) {
		global $adb,$current_user;
		$current_user = $this->getActiveUser();
		
		$record = trim($request->get("record"));
		$isEditRoute = trim($request->get("isEditRoute"));
		$ctroutename = trim($request->get("ctroutename"));
		$ctroute_date = trim($request->get("ctroute_date"));
		$ctroute_status = trim($request->get("ctroute_status"));
		$assigned_user_id = trim($request->get("assigned_user_id"));
		$isduplicateroute = trim($request->get("isduplicate"));
		$isRepeatRoute = trim($request->get("isRepeatRoute"));
		$NoOfRepeateDays = trim($request->get("NoOfRepeateDays"));
		if(is_array( $request->get('ctroute_realtedto'))){
			$ctrouteidlist = $request->get('ctroute_realtedto');
		}else{
			$ctrouteidlist = Zend_Json::decode($request->get('ctroute_realtedto'));
		}

		$insertion_mode = "";
		$moduleName = 'CTRoutePlanning';
		$response = new CTMobile_API_Response();

		if(!empty($record)){
			$record_id = explode('x', $record);
			$recordId = $record_id[1];

			$editAction = Users_Privileges_Model::isPermitted('CTRoutePlanning', 'EditView', $recordId);
			if(!$editAction){
				$message = 'You don\'t have permission';
				$response->setError(403,$message);
				return $response;
				exit;
			}
		}else{
			$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
			$moduleModel = Vtiger_Module_Model::getInstance('CTRoutePlanning');
			$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'CreateView');
			if(!$createAction){
				$response = new CTMobile_API_Response();
				$message = 'You don\'t have permission';
				$response->setError(403,$message);
				return $response;
				exit;
			}
		}
		if($isEditRoute && !empty($record)){
			$insertion_mode = "edit";
			$record_id = explode('x', $record);
			$recordId = $record_id[1];
			$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
			$recordModel->set('id', $recordId);
			$recordModel->set('mode', 'edit');
			if($ctroute_status){
				$recordModel->set('ctroute_status',$ctroute_status);
			}
			if($ctroutename){
				$recordModel->set('ctroutename',$ctroutename);
			}
			if($ctroute_date){
				$recordModel->set('ctroute_date',$ctroute_date);
			}
			//$recordModel->set('ctroute_status',$ctroute_status);
			if($assigned_user_id){
				if($ctroute_status == "" && $ctroutename == "" && $ctroute_date == ""){
					$insertion_mode = "";
				}
				$assigned_user = explode('x', $assigned_user_id);
				$recordModel->set('assigned_user_id',$assigned_user[1]);
			}
			$recordModel->save();
			$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($moduleName);
			$recordId = $recordModel->getId();
			$ctroutename = $recordModel->get('ctroutename');
			$this->recordValues['id'] = $moduleWSId.'x'.$recordId;

			if(!empty($ctrouteidlist) && !empty($recordId)) {
				$adb->pquery( 'DELETE from vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));

				$count = count($ctrouteidlist);

				$sql = 'INSERT INTO vtiger_ctrouteplanrel VALUES ';
				/*for($i=0; $i<$count; $i++) {
					$ctrouteid = explode('x',$ctrouteidlist[$i]);
					$sql .= " ($recordId,$ctrouteid[1])";
					if ($i != $count - 1) {
						$sql .= ',';
					}
				}*/
				for($i=0; $i<$count; $i++) {
					$ctrouteid = explode('x',$ctrouteidlist[$i]['id']);
					$ctroute_priority = $ctrouteidlist[$i]['ctroute_priority'];
					$sql .= " ($recordId,$ctrouteid[1],'$ctroute_priority')";
					if ($i != $count - 1) {
						$sql .= ',';
					}
				}
				$adb->pquery($sql, array());
			}else if ($insertion_mode == "edit" && !empty($recordId)) {
				$adb->pquery('DELETE FROM vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));
			}
			
			$recordLabel = $ctroutename;
			$message = $this->CTTranslate('Route status updated successfully');
			$result = array('id'=>$this->recordValues['id'],'recordLabel'=>$recordLabel,'module'=>$moduleName,'message'=>$message);
			$response->setResult($result);
		}else if(!empty($record)){
			$insertion_mode = "edit";
			$record_id = explode('x', $record);
			$recordId = $record_id[1];
			$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
			$recordModel->set('id', $recordId);
			$recordModel->set('mode', 'edit');
			$recordModel->set('ctroute_status',$ctroute_status);
			$recordModel->save();
			$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($moduleName);
			$recordId = $recordModel->getId();
			$ctroutename = $recordModel->get('ctroutename');
			$this->recordValues['id'] = $moduleWSId.'x'.$recordId;

			$recordLabel = $ctroutename;
			$message = $this->CTTranslate('Route status updated successfully');
			$result = array('id'=>$this->recordValues['id'],'recordLabel'=>$recordLabel,'module'=>$moduleName,'message'=>$message);
			$response->setResult($result);
		}else{

			if($ctroutename == '' || $ctroute_date == '' || $assigned_user_id == ''){
				$message = $this->CTTranslate('Required fields not found');
				throw new WebServiceException(404,$message);
			}
			$recordModel = Vtiger_Record_Model::getCleanInstance($moduleName);
			$recordModel->set('mode', '');

			$assigned_user = explode('x', $assigned_user_id);
			$recordModel->set('ctroutename',$ctroutename);
			$recordModel->set('ctroute_date',$ctroute_date);
			//$recordModel->set('ctroute_status',$ctroute_status);
			$recordModel->set('assigned_user_id',$assigned_user[1]);

			$recordModel->save();
			$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($moduleName);
			$recordId = $recordModel->getId();
			$this->recordValues['id'] = $moduleWSId.'x'.$recordId;

			if(!empty($ctrouteidlist) && !empty($recordId)) {
				$adb->pquery( 'DELETE from vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));

				$count = count($ctrouteidlist);

				$sql = 'INSERT INTO vtiger_ctrouteplanrel VALUES ';
				/*for($i=0; $i<$count; $i++) {
					$ctrouteid = explode('x',$ctrouteidlist[$i]);
					$sql .= " ($recordId,$ctrouteid[1])";
					if ($i != $count - 1) {
						$sql .= ',';
					}
				}*/
				for($i=0; $i<$count; $i++) {
					$ctrouteid = explode('x',$ctrouteidlist[$i]['id']);
					$ctroute_priority = $ctrouteidlist[$i]['ctroute_priority'];
					$sql .= " ($recordId,$ctrouteid[1],'$ctroute_priority')";
					if ($i != $count - 1) {
						$sql .= ',';
					}
				}
				$adb->pquery($sql, array());
			} else if ($insertion_mode == "edit" && !empty($recordId)) {
				$adb->pquery('DELETE FROM vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?', array($recordId));
			}

			if ($isRepeatRoute ==  true && $NoOfRepeateDays) {
				$record = $this->recordValues['id'];
		 
		        for ($i = 1; $i <= $NoOfRepeateDays; $i++) {
				    $ctroute_date = date("Y-m-d", strtotime($ctroute_date . " +1 day"));
				    
				    $response = $this->createmultipleduplicaterecord($request, $record, $assigned_user_id, $ctroute_date, $moduleName);
				}
				$message = $this->CTTranslate('Multiple Route created successfully');
		        $result = array('message' => $message);
		        $response->setResult($result);
		    }

			$recordLabel = $ctroutename;
			$message = $this->CTTranslate('Route save successfully');
			$result = array('id'=>$this->recordValues['id'],'recordLabel'=>$recordLabel,'module'=>$moduleName,'message'=>$message);
			$response->setResult($result);
		}
    
	   	if ($isduplicateroute == true && !empty($record)) {
		    $response = $this->createmultipleduplicaterecord($request, $record, $assigned_user_id, $ctroute_date, $moduleName);
		}
		if ($isRepeatRoute == true && !empty($record)) {

		    $record = trim($request->get("record"));
	        $record_id = explode('x', $record);
	        $recordId = $record_id[1];

		    if ($NoOfRepeateDays) {
		    	$response = new CTMobile_API_Response();
        		$ctroute_date = Vtiger_Date_UIType::getDBInsertedValue(trim($request->get("ctroute_date")));
		        for ($i = 1; $i <= $NoOfRepeateDays; $i++) {
				    $ctroute_date = date("Y-m-d", strtotime($ctroute_date . " +1 day"));
				    $response = $this->createmultipleduplicaterecord($request, $record, $assigned_user_id, $ctroute_date, $moduleName);
				}
		        $message = $this->CTTranslate('Multiple Route created successfully');
		        $result = array('message' => $message);
		        $response->setResult($result);
		    } else {
		        $message = $this->CTTranslate('Multiple Route failed');
		        $response->setError(404, $message);
		    }
		}
    
		return $response;
	}
	function createmultipleduplicaterecord(CTMobile_API_Request $request,$record,$assigned_user_id,$ctroute_date,$moduleName) {
	    $response = new CTMobile_API_Response(); 

	    if (!empty($record)) {
	        global $adb;
	        //$ctroute_date = trim($request->get("ctroute_date"))	;
	        $assigned_user = explode('x', $assigned_user_id);

	        if ($record == '' || $ctroute_date == '' || $assigned_user_id == '') {
	            $message = $this->CTTranslate('Required fields not found'); 
	            throw new WebServiceException(404, $message);
	        }

	       // $record = trim($request->get("record"));
	        $record_id = explode('x', $record);
	        $recordId = $record_id[1];

	        $NewRecordModel = Vtiger_Record_Model::getCleanInstance($moduleName);

	        $existingRecord = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
	        $NewRecordModel->set('mode', '');
	        $NewRecordModel->set('ctroutename', $existingRecord->get('ctroutename'));
	        //$NewRecordModel->set('ctroute_status', $existingRecord->get('ctroute_status'));
	        $NewRecordModel->set('ctroute_status', "");
	        $NewRecordModel->set('ctroute_date', $ctroute_date);
	        $NewRecordModel->set('assigned_user_id', $assigned_user[1]);

	        $NewRecordModel->save();
	        $newRecordId = $NewRecordModel->getId();

	        $query = 'SELECT * FROM vtiger_ctrouteplanrel WHERE ctrouteplanningid = ?';
	        $result1 = $adb->pquery($query, array($recordId));
	        $NoOfRows = $adb->num_rows($result1);

	        for ($i = 0; $i < $NoOfRows; $i++) {
	            $row = $adb->query_result_rowdata($result1, $i);
	            $ctrouteid1 = $row['ctroute_realtedto'];
	            $ctroute_priority = $row['ctroute_priority'];
	            $insertQuery = 'INSERT INTO vtiger_ctrouteplanrel (ctrouteplanningid, ctroute_realtedto,ctroute_priority) VALUES (?,?,?)';
	            $adb->pquery($insertQuery, array($newRecordId, $ctrouteid1,$ctroute_priority));
	        }
	       	$message = $this->CTTranslate('Route duplicated successfully');
	        $result = array('id' => $newRecordId, 'module' => $moduleName, 'message' => $message);
	        $response->setResult($result);
	    } else {
	        $message = $this->CTTranslate('Route duplication failed');
	        $response->setError(404, $message);
	    }
	    return $response;
	}
}

