<?php
/*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_GetRoutePriority extends CTMobile_WS_Controller {

    function process(CTMobile_API_Request $request) {
        $default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
        global $current_user, $adb;
        $current_user = $this->getActiveUser();
        $roleid = $current_user->roleid;
        $module = 'CTRoutePlanning';
        $mode = trim($request->get('mode'));

        $response = new CTMobile_API_Response();
        if ($mode == 'getroutepriority') {
            $picklistValues = array();

            $picklistValues[] = array('value' => "Low", 'label' => vtranslate('Low', $module));
            $picklistValues[] = array('value' => "Medium", 'label' => vtranslate('LBL_DISPLAY_MEDIUMTYPE', $module));
            $picklistValues[] = array('value' => "High", 'label' => vtranslate('High', $module));
            $response->setResult(array('module' => $module, 'ctroute_priority' => $picklistValues));
            return $response;
        }else {
            $message = $this->CTTranslate('Invalid status');
            $response->setError(404, $message);
            return $response;
        }
    }
}


?>