<?php
/*
 * class token
 *
 * this class is dedicated to version 1 - token
 * - predefined method of hashing (md5)
 * - predefined layout of token
 *
 * the token url is always:
 * <something>/hub.php?a=action&ts=ts&m=objectTypeId&i=objectId&v=version&t=token
 *
 * config defined per hub-action
 * see: More->Support->Hubconfigurator
 *
 */
class hubToken
{
  // version dictates the method and format
  private $_adb = null;
  private $_secret = null;
  private $_hubUrl = null;
  private $_hubAction = null;
  private $_objectId = null;
  private $_objectTypeId = null;
  private $_ts = null;
  private $_token = null;
  private $_version = 1;
  private $_format = '/hub.php?a=%s&ts=%s&m=%s&i=%s&v=%s&t=%s';

  private $_params = array();

  public function __construct($hubAction)
  {
    // get the settings for this hubAction from hubconfig config
    global $adb, $site_URL;

    $this->_adb = $adb;

    $query= "SELECT * FROM vtiger_hubconfigurator h, vtiger_hubconfiguratorcf c
             WHERE h.hubconfiguratorid = c.hubconfiguratorid
             AND h.hubaction = ?";

    $params = array($hubAction);
    $result = $this->_adb->pquery($query, $params);

    $this->_secret  = $this->_adb->query_result($result, 0, 'hub_secretkey');
    $this->_version = $this->_adb->query_result($result, 0, 'hub_version');
    $this->_hubUrl = rtrim($site_URL, '/');

    // default
    $this->_params['utm_content'] = 'textlink';
    $this->_params['utm_medium']  = 'email';

    $this->_params['utm_source']   = $this->_adb->query_result($result, 0, 'hub_utm_source');
    $this->_params['utm_term']     = $this->_adb->query_result($result, 0, 'hub_utm_term');
    $this->_params['utm_campaign'] = $this->_adb->query_result($result, 0, 'hub_utm_campaign');

    $this->_hubAction = $hubAction;
  }

  public function setParams($params)
  {
    $this->_params = $params;
  }

  public function setObjectTypeId($objectTypeId)
  {
    // need to have the webservice id, not the name of module
    $query = "SELECT id FROM vtiger_ws_entity WHERE name = ?";

    $params = array($objectTypeId);
    $result = $this->_adb->pquery($query, $params);

    $this->_objectTypeId  = $this->_adb->query_result($result, 0, 'id');
  }

  public function setObjectId($objectId)
  {
    $this->_objectId = $objectId;
  }

  public function setObject($object)
  {
    list($this->_objectTypeId, $this->_objectId) = explode('x', $object);
  }

  public function generateTokenLink($uri = false)
  { 
    $this->_ts = time();

    if ($this->_generateToken())
    {
      $tokenLink = sprintf($this->_format, $this->_hubAction, $this->_ts, $this->_objectTypeId, $this->_objectId, $this->_version, $this->_token);

      if (sizeof($this->_params) > 0)
      {
        foreach($this->_params as $key => $value)
        {
          if ($value != '' && $value != null)
          {
            $tokenLink .= '&' . $key . '=' . $value;
          }
        }
      }

      if ($uri === true)
      {
        return $this->_hubUrl . $tokenLink;
      }

      return $tokenLink;
    }

    return false;
  }

  private function _generateToken()
  {
    $token = $this->_secret . $this->_hubAction . $this->_ts . $this->_objectTypeId . $this->_objectId . $this->_version;
    $this->_token = md5($token);
    return true;
  }
}
