{*<!--
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
-->*}
<style type="text/css">
  .search-container1 {
position: relative;
/*max-width: 300px;*/
margin: 0 auto;
text-align: center;
padding: 15px;
display:block;
}

.search-title {
margin-top: 0;
margin-bottom: 5px;
color: #1ca0b8;
}

#search-input {
width: 80%;
padding: 13px;
/*border-radius: 4px;*/
/*border: 2px solid #1ca0b8;*/
font-size: 15px;
}

#search-input:focus {
outline: none;
}

#search-results {
position: absolute;
z-index: 10;
margin: 1px auto;
background: #1ca0b8;
width: 80%;
text-align: left;
border-radius: 4px;
border: 2px solid #1ca0b8;
display: none;
}
.search-item {
color: white;
cursor: pointer;
}
.search-item p {
margin: 0;
padding: 10px;
}
.search-item:hover {
background: #2cc7e2;
}
#search-data {
margin-top: 10px;
color: #1ca0b8;
}
#search-data p {
margin: 0;
padding: 6px;
font-size: 16px;
}
</style>
{strip}
<div class="modal-dialog">
    <div class="modal-content">
            <div class="modal-header">
                <div class="clearfix">
                    <div class="pull-right " >
                        <button type="button" class="close" aria-label="Close" data-dismiss="modal">
                            <span aria-hidden="true" class='fa fa-close'></span>
                        </button>
                    </div>
                    <h4 class="pull-left">
                        {vtranslate('Add Stops - Route Planning','CTMobileSettings')}
                    </h4>
                </div>
            </div>
        <div class="modal-body">
            <div id="popupPageContainer" class="contentsDiv col-sm-12">
                <div id="popupContents" class="">
                    <input type="hidden" id="supportedImageFormats" value='["png"]'/>
                   
                    <div class="row">
                          <select class="selec2 inputElement" name="IconModule">
                            {foreach item=modulelabel key=modulename from=$ALL_MODULES}
                            <option value="{$modulename}" {if $MODULE_NAME eq $modulename} selected {/if}>{$modulelabel}</option>
                            {/foreach}
                          </select>
                    </div>
                    <div class="row">

                          <div class="search-container1">
                              <div class="search-engine">
                              <input type="input" class="form-control" name="recordname" id="search-input" autocomplete="off" placeholder="Hit Enter to Search" style="display: inline-block;" />&nbsp;&nbsp;
                             <!--  <button type="button" class="btn btn-info" style="background:#287DF2 !important;display: inline-block;" id="addstop"><i class="fa fa-plus"></i> Add Stop</button> -->
                              </div>
                              <div id="search-results"></div>
                              <div id="search-data"></div>
                          </div>
                    </div>
                    <table class="table table-borderless" id="stoptable">
                            <thead>
                                <tr>
                                  <th>{vtranslate('Record Label','CTMobileSettings')}</th>
                                  <th>{vtranslate('Address','CTMobileSettings')}</th>
                                  <th>{vtranslate('Action','CTMobileSettings')}</th>
                                </tr>
                            </thead>
                            <tbody>
                              
                            </tbody>
                        </table>
            
                </div>
               
            </div>
        </div>
        <div class="modal-footer">
            <a aria-label="Close" data-dismiss="modal">{vtranslate('Close','CTMobileSettings')}</a>&nbsp;&nbsp;
            <button type="button" class="btn btn-success saveButton" id="saveStops" style="background:#287DF2 !important;">{vtranslate('Save Stops','CTMobileSettings')}</button>
        </div>
    </div>
</div>
{/strip}

{literal}
<script type="text/javascript">
    /*if (navigator.geolocation) {
      navigator.geolocation.getCurrentPosition((position)=> {
          const p=position.coords;
          console.log(p.latitude,p.longitude);
      });
    }else{
      console.log("Geolocation is not supported by this browser.");
    }*/

    
    var popupPageContainer = jQuery('#popupPageContainer');

    jQuery('#saveStops').on('click',function(){
      var trr = jQuery('#stoptable tbody').find('tr');
      var trlength = jQuery('#stoptable tbody').find('tr').length;
      if(trlength == 0){
        var params = {
            title : app.vtranslate('Please add atleast one stop'),
            text: app.vtranslate('Please add atleast one stop'),
            animation: 'show',
            type: 'error'
        };
        Vtiger_Helper_Js.showPnotify(params);
      }else{
        for(var i=0;i<trlength;i++){
          var oldtr = trr[i];
          let tr = document.createElement('tr');
          tr.setAttribute("data-crmid", oldtr.getAttribute('data-crmid'));
          tr.setAttribute("data-label", oldtr.getAttribute('data-label'));
          tr.setAttribute("data-address", oldtr.getAttribute('data-address'));
          tr.setAttribute("data-latitude", oldtr.getAttribute('data-latitude'));
          tr.setAttribute("data-longitude", oldtr.getAttribute('data-longitude'));
          tr.setAttribute("data-setype", oldtr.getAttribute('data-setype'));
          tr.setAttribute("data-modulelabel", oldtr.getAttribute('data-modulelabel'));
          let td1 = document.createElement('td');
          let td2 = document.createElement('td');
          let td3 = document.createElement('td');
          let td4 = document.createElement('td');
          td1.textContent = oldtr.getAttribute('data-modulelabel');
          td2.textContent = oldtr.getAttribute('data-label');
          td3.textContent = oldtr.getAttribute('data-address');
          td4.innerHTML = "<a class='btn btn-danger deleteStops' onclick='deleteStops(this)' title='Delete'><i class='fa fa-trash'></i></a>";
          tr.append(td1);
          tr.append(td2);
          tr.append(td3);
          tr.append(td4);
          document.querySelector('#example1 tbody').append(tr);
          $('#popupModal').modal('toggle');
        }
      }
    });

    popupPageContainer.find('#search-input').on('keydown',function(){

      hideSearchResults();
      clearSearchResults();
      clearSearchData();
      var modulename = popupPageContainer.find('[name="IconModule"]').val();
      var searchvalue = jQuery(this).val();
      if(searchvalue.length >= 3){
          var params = {};
          params['module'] = 'CTMobileSettings';
          params['view'] = 'RoutePlanning';
          params['mode'] = 'getRecordbySearch';
          params['searchvalue'] = searchvalue;
          params['modulename'] = modulename;
          AppConnector.request(params).then(function(data) {
              var searchResult = data.result;
              jQuery.each(searchResult,function(index,value){
                //console.log(value);
                //console.log(value.label);
                document.getElementById("search-results").innerHTML +=
                "<div class='search-item' data-crmid='"+value.crmid +"' data-label='"+value.label+"' data-address='"+value.address+"' data-latitude='"+value.latitude+"' data-longitude='"+value.longitude+"' data-setype='"+value.setype+"' data-modulelabel='"+value.modulelabel+"' onclick='displayData(this)'><p>" +value.label +"</p></div>";
              });
              displaySearchResults();
          });
      }
    });

    //shortens document.getEgetElementById
function element(id) {
return document.getElementById(id);
}

function clearSearchData() {
element("search-data").innerHTML = "";
}

function hideSearchResults() {
element("search-results").style.display = "none";
}

function clearSearchResults() {
element("search-results").innerHTML = "";
}

function displaySearchResults() {
element("search-results").style.display = "block";
}

function displayData(event) {
  let tr = document.createElement('tr');
  tr.setAttribute("data-crmid", event.getAttribute('data-crmid'));
  tr.setAttribute("data-label", event.getAttribute('data-label'));
  tr.setAttribute("data-address", event.getAttribute('data-address'));
  tr.setAttribute("data-latitude", event.getAttribute('data-latitude'));
  tr.setAttribute("data-longitude", event.getAttribute('data-longitude'));
  tr.setAttribute("data-setype", event.getAttribute('data-setype'));
  tr.setAttribute("data-modulelabel", event.getAttribute('data-modulelabel'));
  let td1 = document.createElement('td');
  let td2 = document.createElement('td');
  let td3 = document.createElement('td');
  td1.textContent = event.getAttribute('data-label');
  td2.textContent = event.getAttribute('data-address');
  td3.innerHTML = "<a class='btn btn-danger deleteStops' onclick='deleteStops(this)' title='Delete'><i class='fa fa-trash'></i></a>";
  tr.append(td1);
  tr.append(td2);
  tr.append(td3);
  //element("search-data").innerHTML = "<p>" + event.getAttribute('data-label') + "</p>";
  //var child = "<tr><td>"+  +"</td><td>"+ event.getAttribute('data-address') +"</td><td></td></tr>";
  document.querySelector('#stoptable tbody').append(tr);
  hideSearchResults();
  jQuery('#search-input').val('');
}





</script>
{/literal}