<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

require_once 'modules/Emails/class.phpmailer.php';
require_once 'modules/Emails/mail.php';   
class CTMobile_WS_SendEmail extends CTMobile_WS_Controller {
	
	function getFromEmailAddress() {
		global $current_user;
		$current_user = $this->getActiveUser();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();

		$fromEmail = $currentUserModel->get('email1');
		return $fromEmail;
	}
	

	function process(CTMobile_API_Request $request) {
		global $root_directory, $adb, $current_user;
		$current_user = $this->getActiveUser();
		$moduleName = trim($request->get('module'));
		if($request->get('record') != ''){
			$records = explode(',',trim($request->get('record')));
		}
		
		$toEmailInfo = $request->get('to');
		$cc = $request->get('cc');
		$files = $_FILES;
		$_FILES = array();
		$currentUserModel = Users_Record_Model::getCurrentUserModel();
		$first_name = $currentUserModel->get('first_name');
		$last_name = $currentUserModel->get('last_name');
		$fromName = $first_name.' '.$last_name;

		$body = $request->get('body');
		$subject = trim($request->get('subject'));
		$documentIdds = $request->get('documentids');
		if(!is_array($documentIdds)){
			$documentIdds = Zend_Json::decode($documentIdds);
		}
		$documentIds = array();
		foreach($documentIdds as $docids){
			$docid = explode('x',$docids);
			$documentIds[] = $docid[1];
		}
		
		if(empty($toEmailInfo) || empty($body) || empty($subject)){
			$message = $this->CTTranslate('Required fields not found');
			throw new WebServiceException(404,$message);
		}

		$recordModel = Vtiger_Record_Model::getCleanInstance("Emails");
		$recordModel->set('mode', '');

		$toMailInfo = '{}';
		$toEmailInfo = explode(",",$toEmailInfo);
		if(is_array($toEmailInfo)){
			$to = implode(',', $toEmailInfo);
			$to = '["'.$to.'"]';
			$toEmailInfo = implode(',', $toEmailInfo);
		}else{
			$to = '["'.$toEmailInfo.'"]';
		}

		$flag = 'SENT';

		$content = $request->getRaw('body');
		$processedContent = Emails_Mailer_Model::getProcessedContent($content); // To remove script tags
		$mailerInstance = Emails_Mailer_Model::getInstance();
		$processedContentWithURLS = decode_html($mailerInstance->convertToValidURL($processedContent));
		$recordModel->set('description', $processedContentWithURLS);
		$recordModel->set('subject', $request->get('subject'));
		$recordModel->set('toMailNamesList',$request->get('toMailNamesList'));
		$recordModel->set('saved_toid', $toEmailInfo);
		$recordModel->set('ccmail', $request->get('cc'));
		$recordModel->set('bccmail', $request->get('bcc'));
		$recordModel->set('assigned_user_id', $currentUserModel->getId());
		$recordModel->set('email_flag', $flag);
		$recordModel->set('documentids', $documentIds);
		//$recordModel->set('signature',$signature);

		$recordModel->set('toemailinfo', $toMailInfo);
		if(!empty($records)){
			foreach($records as $record) {
				$recordId = explode('x',$record);
				if($recordModel->getEntityType($recordId[1]) == 'Users'){
					$parentIds .= $recordId[1].'@-1|';
				}else{
					$parentIds .= $recordId[1].'@1|';
				}
			}
			$recordModel->set('parent_id', $parentIds);

			//save_module still depends on the $_REQUEST, need to clean it up
			$_REQUEST['parent_id'] = $parentIds;
		}else{
			$recordModel->set('parent_id', '');
			$_REQUEST['parent_id'] = '';
		}

		$decodedHtmlDescriptionToSend = $recordModel->get('description');
		$recordModel->set('description', to_html($decodedHtmlDescriptionToSend));
		$recordModel->save();
		// Restore content to be dispatched through HTML mailer.
		$recordModel->set('description', $decodedHtmlDescriptionToSend);
		// To add entry in ModTracker for email relation
		$emailRecordId = $recordModel->getId();
		if(!empty($records)){
			foreach($records as $record) {
				$recordId = explode('x',$record);
				$relatedModule = $recordModel->getEntityType($recordId[1]);
				if (!empty($relatedModule) && $relatedModule != 'Users') {
					$relatedModuleModel = Vtiger_Module_Model::getInstance($relatedModule);
					$relationModel = Vtiger_Relation_Model::getInstance($relatedModuleModel, $recordModel->getModule());
					if ($relationModel) {
						$relationModel->addRelation($recordId[1], $emailRecordId);
					}
				}
			}
		}

		$current_user = Users_Record_Model::getCurrentUserModel();
		$ownerId = $recordModel->get('assigned_user_id');

		if(!empty($files)){
			foreach ($files as $key => $file) {
				if($file['name'] != ''){
					$uploadedFileNames[] = $this->uploadAndSaveFiles($file,$emailRecordId,'Emails');
				}
			}
		}

		$status = $recordModel->send();
		if ($status === true) {
			// This is needed to set vtiger_email_track table as it is used in email reporting
			$recordModel->setAccessCountValue();
			$message = $this->CTTranslate('Mail send successfully');
			$result = array('code' => 1,'message' => $message);
		} else {
			$message = $this->CTTranslate('Could not send mail, Please try later');
			$result = array('code' => 0,'message' => $message);
		}
		
		$response = new CTMobile_API_Response();
		$response->setResult($result);
		return $response;
	}


	function uploadAndSaveFiles($files,$uniquecrmid,$module){
		if (!empty($files)) {
            global $adb,$site_URL,$root_directory;
            $current_user = $this->getActiveUser();
            $moduleName = $module;
            $storagePath = 'storage/';
            $year  = date('Y');
            $month = date('F');
            $day   = date('j');
            $week  = '';
            
			$date_var = date("Y-m-d H:i:s");
			
            if (!is_dir($root_directory.$storagePath . $year)) {
                mkdir($root_directory.$storagePath . $year);
                chmod($root_directory.$storagePath . $year, 0777);
            }

            if (!is_dir($root_directory.$storagePath . $year . "/" . $month)) {
                mkdir($root_directory.$storagePath . "$year/$month");
                chmod($root_directory.$storagePath . "$year/$month", 0777);
            }

            if ($day > 0 && $day <= 7){
                $week = 'week1';
            }elseif ($day > 7 && $day <= 14){
                $week = 'week2';
            }elseif ($day > 14 && $day <= 21){
                $week = 'week3';
            }elseif ($day > 21 && $day <= 28){
                $week = 'week4';
            }else{
                $week = 'week5'; 
            }
            
            if (!is_dir($root_directory.$storagePath . $year . "/" . $month . "/" . $week)) {
                mkdir($root_directory.$storagePath . "$year/$month/$week");
                chmod($root_directory.$storagePath . "$year/$month/$week", 0777);
            }
            $interior = $storagePath . $year . "/" . $month . "/" . $week . "/";
            $crm_id = $adb->getUniqueID("vtiger_crmentity");
            $upload_status = move_uploaded_file($files['tmp_name'],$interior.$crm_id.'_'. $files['name']);
            if($upload_status){
	            $lastInsertedId = $adb->pquery("select attachmentsid from vtiger_attachments order by attachmentsid DESC limit 0,1");
	            $attachmentsid = $adb->query_result($lastInsertedId, 0, 'attachmentsid');
	            $query1 = $adb->pquery("insert into vtiger_crmentity (`crmid`,`setype`) VALUES(?,?)",array($crm_id,'Emails Attachment'));
	            $query2 = $adb->pquery("insert into vtiger_attachments (`attachmentsid`,`name`,`type`,`path`) VALUES(?,?,?,?)",array($crm_id,$files['name'],$files['type'],$interior));
	            $adb->pquery("insert into vtiger_seattachmentsrel (`crmid`,`attachmentsid`) VALUES(?,?)",array($uniquecrmid,$crm_id));
            }
			return $crm_id;     
        }
	}
}
		
