<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */

class CTMobile_WS_CTRouteAttendance extends CTMobile_WS_Controller {
	
	function process(CTMobile_API_Request $request) {
		global $current_user; // Required for vtws_update API
		$current_user = $this->getActiveUser();
		$user =  Users::getActiveAdminUser();
		$module = 'CTRouteAttendance';
		$ctroute_planning = trim($request->get('ctroute_planning'));
		$related_to = trim($request->get('ctroute_realtedto'));
		$recordid = trim($request->get('record'));
		$ctroute_attendance_status = trim($request->get('ctroute_attendance_status'));
		$employee_name = trim($request->get('ctroute_user'));
		$latitude = trim($request->get('latitude'));
		$longitude = trim($request->get('longitude'));
		
		$response = new CTMobile_API_Response();
		
		if ($ctroute_attendance_status == '') {
			$message = $this->CTTranslate('Status cannot be empty');
			$response->setError(404, $message);
			return $response;
		}
		if ($employee_name == '') {
			$message = $this->CTTranslate('User cannot be empty');
			$response->setError(404, $message);
			return $response;
		}
		if ($latitude == '') {
			$message = $this->CTTranslate('Latitude cannot be empty');
			$response->setError(404, $message);
			return $response;
		}	
		if ($longitude == '') {
			$message = $this->CTTranslate('Longitude cannot be empty');
			$response->setError(404, $message);
			return $response;
		}
		if ($ctroute_planning == '') {
			$message = $this->CTTranslate('ctroute_planning cannot be empty');
			$response->setError(404, $message);
			return $response;
		}
		if ($related_to == '') {

			$message = $this->CTTranslate('ctroute_realtedto cannot be empty');
			$response->setError(1501, $message);
			return $response;
		}else{
			$routePlanningId = substr($related_to, stripos($related_to, 'x')+1);
			$editAction = Users_Privileges_Model::isPermitted('CTRoutePlanning', 'EditView', $routePlanningId);
			if(!$editAction){
				$message = 'You don\'t have permission';
				$response->setError(403,$message);
				return $response;
				exit;
			}
		}
		try {
			// Retrieve or Initalize
			if (!empty($recordid)) {
				$mode = 'edit';
				$arrRecordId = explode('x',$recordid);

				$editAction = Users_Privileges_Model::isPermitted($module, 'EditView', $arrRecordId[1]);
				if(!$editAction){
					$message = 'You don\'t have permission';
					$response->setError(403,$message);
					return $response;
					exit;
				}

				$recordModel = Vtiger_Record_Model::getInstanceById($arrRecordId[1], $module);
				$recordModel->set('id', $arrRecordId[1]);
				$recordModel->set('mode', 'edit');
			}else {

				$userPrivModel = Users_Privileges_Model::getInstanceById($current_user->id);
				$moduleModel = Vtiger_Module_Model::getInstance($module);
				$createAction = $userPrivModel->hasModuleActionPermission($moduleModel->getId(), 'CreateView');
				if(!$createAction){
					$response = new CTMobile_API_Response();
					$message = 'You don\'t have permission';
					$response->setError(403,$message);
					return $response;
					exit;
				}

				$mode = 'create';
				$recordModel = Vtiger_Record_Model::getCleanInstance($module);
				$recordModel->set('mode', '');
			}
			
			// Set the modified values
			$checkin_status = false;
			$recordModel->set('ctroute_attendance_status', $ctroute_attendance_status);
			$ctroute_user = substr($employee_name, stripos($employee_name, 'x')+1);
			$recordModel->set('ctroute_user', $ctroute_user);
			$recordModel->set('assigned_user_id', $current_user->id);
			
			if($ctroute_attendance_status == 'check_in'){
				$relatedto = substr($related_to, stripos($related_to, 'x')+1);
				$recordModel->set('related_to', $relatedto);
				$ctrouteplanning = substr($ctroute_planning, stripos($ctroute_planning, 'x')+1);
				$recordModel->set('ctroute_planning', $ctrouteplanning);
				$recordModel->set('check_in_location', "$latitude,$longitude");
				$recordModel->set('check_in_address', trim($request->get('check_in_address')));
				$checkin_status = true;
				$update_status = $this->changeStatusInprogress($ctroute_planning);
			}elseif($ctroute_attendance_status == 'check_out'){
				$recordModel->set('check_out_location', "$latitude,$longitude");
				$recordModel->set('check_out_address', trim($request->get('check_out_address')));
				$checkin_status = false;
			}
			define("SECONDS_PER_HOUR", 60*60);
			// Update or Create
			if (!empty($recordid)) {
				$recordModel->save();
				$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($module);
				$lastInsertId = $recordModel->getId();
				$lastInsertWSId= $moduleWSId.'x'.$lastInsertId;
				$message = $this->CTTranslate('Shift ended successfully');
				$check_in_time = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($recordModel->get('createdtime'));
				$check_out_time = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($recordModel->get('modifiedtime'));
				$startdatetime = strtotime($recordModel->get('createdtime'));
				$enddatetime = strtotime($recordModel->get('modifiedtime'));

			    // calulate the difference in seconds
			    $difference = $enddatetime - $startdatetime;
			    $hours = round($difference / SECONDS_PER_HOUR, 0, PHP_ROUND_HALF_DOWN);
				$minutes = round(($difference % SECONDS_PER_HOUR) / 60, 0, PHP_ROUND_HALF_DOWN);
			    // output the result
			    $duration = $hours . " hr " . $minutes . " min";
			} else {
				$recordModel->save();
				$moduleWSId = CTMobile_WS_Utils::getEntityModuleWSId($module);
				$lastInsertId = $recordModel->getId();
				$lastInsertWSId= $moduleWSId.'x'.$lastInsertId;

				$message = $this->CTTranslate('Shift started successfully');
				$check_in_time = Vtiger_Util_Helper::convertDateTimeIntoUsersDisplayFormat($recordModel->get('createdtime'));
				$startdatetime = strtotime($recordModel->get('createdtime'));
			    // calculate the end timestamp
				$enddatetime = strtotime($recordModel->get('modifiedtime'));
				$check_out_time = '';
			    // calulate the difference in seconds
			    $difference = $enddatetime - $startdatetime;
			    $hours = round($difference / SECONDS_PER_HOUR, 0, PHP_ROUND_HALF_DOWN);
				$minutes = round(($difference % SECONDS_PER_HOUR) / 60, 0, PHP_ROUND_HALF_DOWN);
			    // output the result
			    $duration = $hours . " hr " . $minutes . " min";
				
			}

			if($ctroute_attendance_status == 'check_out'){
				$update_status = $this->changeStatusCompleted($ctroute_planning);
			}

			$response->setResult(array('id'=>$lastInsertWSId,'attendance_status'=>$checkin_status,'message'=>$message,'check_in_time'=>$check_in_time,'check_out_time'=>$check_out_time,'duration'=>$duration));
			
		} catch(Exception $e) {
			$response->setError($e->getCode(), $e->getMessage());
		}
		return $response;
	}

	function changeStatusInprogress($ctroute_planning){
		if($ctroute_planning){
			$ctroute_planning_id = explode('x',$ctroute_planning);
			$recordId = $ctroute_planning_id[1];
			$moduleName = 'CTRoutePlanning';
			$ctroute_status = 'In Progress';
			$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
			$recordModel->set('id', $recordId);
			$recordModel->set('mode', 'edit');
			$recordModel->set('ctroute_status',$ctroute_status);
			$recordModel->save();
		}
	}

	function changeStatusCompleted($ctroute_planning){
		global $adb;
		if($ctroute_planning){
			$ctroute_planning_id = explode('x',$ctroute_planning);
			$recordId = $ctroute_planning_id[1];
			$statusCompleted = true;
			$query = 'SELECT * from vtiger_ctrouteplanrel where ctrouteplanningid=?';
			$result = $adb->pquery($query, array($recordId));
        	$numRows = $adb->num_rows($result);

       		$ctroute_realtedtoList = array();
        	for($i=0; $i<$numRows; $i++) {
        		$row = $adb->fetchByAssoc($result, $i);
	            $ctroute_realtedto = $row['ctroute_realtedto'];

				$checkAllCheckout = $adb->pquery("SELECT ctroute_attendance_status FROM vtiger_ctrouteattendance WHERE ctroute_planning = ? AND related_to = ?",array($recordId,$ctroute_realtedto));
				$num_rows = $adb->num_rows($checkAllCheckout);
				if($num_rows > 0){
	            	$row1 = $adb->fetchByAssoc($checkAllCheckout, 0);
	            	$ctroute_attendance_status = $row1['ctroute_attendance_status'];
	            	if($ctroute_attendance_status == 'check_in' || $ctroute_attendance_status == ''){
	            		$statusCompleted = false;
	            	}
				}else{
					$statusCompleted = false;
				}
			}
			if($statusCompleted == true){
				$moduleName = 'CTRoutePlanning';
				$ctroute_status = 'Completed';
				$recordModel = Vtiger_Record_Model::getInstanceById($recordId, $moduleName);
				$recordModel->set('id', $recordId);
				$recordModel->set('mode', 'edit');
				$recordModel->set('ctroute_status',$ctroute_status);
				$recordModel->save();
			}
		}
	}
	
}
