<?php
 /*+*******************************************************************************
 * The content of this file is subject to the CRMTiger Pro license.
 * ("License"); You may not use this file except in compliance with the License
 * The Initial Developer of the Original Code is vTiger
 * The Modified Code of the Original Code owned by https://crmtiger.com/
 * Portions created by CRMTiger.com are Copyright(C) CRMTiger.com
 * All Rights Reserved.
  ***************************************************************************** */
include_once dirname(__FILE__) . '/SaveRecord.php';

class CTMobile_WS_AddRecordComment extends CTMobile_WS_SaveRecord {
	
	function process(CTMobile_API_Request $request) {
		$default_charset = VTWS_PreserveGlobal::getGlobal('default_charset');
		global $current_user,$adb, $site_URL;
		$values = Zend_Json::decode($request->get('values'));
		$relatedTo = trim($values['related_to']);
		$commentContent = $values['commentcontent'];
		if($relatedTo == ''){		
			$message = $this->CTTranslate('Required fields not found');		
			throw new WebServiceException(404,$message);		
		}		
		if($commentContent == ''){		
			$message = $this->CTTranslate('Required fields not found');	
			throw new WebServiceException(404,$message);		
		}
		$user = $this->getActiveUser();
		$targetModule = 'ModComments';
		$response = false;
		if (vtlib_isModuleActive($targetModule)) {
			$request->set('module', $targetModule);
			$values['assigned_user_id'] = sprintf('%sx%s', CTMobile_WS_Utils::getEntityModuleWSId('Users'), $user->id);
			
			$request->set('values', Zend_Json::encode($values) );
			
			$response = parent::process($request);
			$id = $response->result['id'];
			if(!empty($id)){

				$record = explode('x',$id);
				$modcommentsid = $record[1];
				$query = "SELECT vtiger_modcomments.*, vtiger_crmentity.createdtime, vtiger_crmentity.smownerid from vtiger_modcomments INNER JOIN vtiger_crmentity ON vtiger_crmentity.crmid = vtiger_modcomments.modcommentsid where vtiger_crmentity.deleted = 0 and vtiger_modcomments.modcommentsid = ? ";

				$getCommentQuery = $adb->pquery($query, array($modcommentsid));
				$countComment = $adb->num_rows($getCommentQuery);

				$modcommentId = $adb->query_result($getCommentQuery, 0, 'modcommentsid');
				$commentcontent = $adb->query_result($getCommentQuery, 0, 'commentcontent');
				$commentcontent = html_entity_decode($commentcontent, ENT_QUOTES, $default_charset);
				$relatedTo = $adb->query_result($getCommentQuery, 0, 'related_to');
				$parent_comments = $adb->query_result($getCommentQuery, 0, 'parent_comments');
				$userId = $adb->query_result($getCommentQuery, 0, 'smownerid');
				$createdtime = $adb->query_result($getCommentQuery, 0, 'createdtime');
				$commentedtime = Vtiger_Util_Helper::formatDateDiffInStrings($createdtime);
				$modifiedtime = $adb->query_result($getCommentQuery, 0, 'modifiedtime');
				$isModified = false;
				$modifiedText = "";
				if($createdtime != $modifiedtime){
					$isModified = true;
					$modifiedtime = Vtiger_Util_Helper::formatDateDiffInStrings($modifiedtime);
					$modifiedText = vtranslate('LBL_MODIFIED','ModComments').' '.$modifiedtime;
				}
				if($userId) {
					$userRecordModel = Vtiger_Record_Model::getInstanceById($userId, 'Users');
					$firstname = $userRecordModel->get('first_name');
					$firstname = html_entity_decode($firstname, ENT_QUOTES, $default_charset);
					$lastname = $userRecordModel->get('last_name');
					$lastname = html_entity_decode($lastname, ENT_QUOTES, $default_charset);
					$userImage = CTMobile_WS_Utils::getUserImage($userId);
				}

				$isEdit = false;
				if(Users_Privileges_Model::isPermitted('ModComments', 'EditView')){
					if($userId == $current_user->id){
						$isEdit = true;
					}
				}
				$commentsWSid = CTMobile_WS_Utils::getEntityModuleWSId('ModComments');
				$modcommentsData = array('modcommentId'=>$commentsWSid.'x'.$modcommentId, 'commentcontent'=>$commentcontent, 'relatedTo' => $relatedTo,'parent_comments'=>$commentsWSid.'x'.$parent_comments, 'userid'=>$userId, 'userName'=>$firstname." ".$lastname,'userImage'=>$userImage, 'createdtime'=>$createdtime,'ModifiedTime'=>$commentedtime,'isEdit'=>$isEdit,'isModified'=>$isModified,'modifiedText'=>$modifiedText);
				$response = new CTMobile_API_Response();
				$response->setResult(array('record'=>$modcommentsData,'message'=>$this->CTTranslate('Comment saved successfully')));
			}else{
				$response = new CTMobile_API_Response();
				$response->setResult(array('record'=>array(),'message'=>$this->CTTranslate('Comment not saved')));
			}
		
		}else{
			$response = new CTMobile_API_Response();
			$message = $this->CTTranslate('Comment module is not active');
			$response->setError(403,$message);
		}
		return $response;
	}

}
